/*
 * Decompiled with CFR 0.152.
 */
package net.tintankgames.peak.mixin;

import java.util.List;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUseAnimation;
import net.minecraft.world.item.component.Consumable;
import net.minecraft.world.item.component.ConsumableListener;
import net.minecraft.world.item.consume_effects.ConsumeEffect;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.tintankgames.peak.attachments.PeakAttachmentTypes;
import net.tintankgames.peak.core.component.PeakDataComponents;
import net.tintankgames.peak.core.registries.PeakDataMaps;
import net.tintankgames.peak.stamina.AfflictionType;
import net.tintankgames.peak.stamina.StaminaBar;
import net.tintankgames.peak.world.item.component.PeakConsumable;
import net.tintankgames.peak.world.item.component.Poisonous;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Consumable.class})
public abstract class ConsumableMixin {
    @Shadow
    @Final
    private List<ConsumeEffect> onConsumeEffects;
    @Shadow
    @Final
    private ItemUseAnimation animation;

    @Shadow
    public abstract void emitParticlesAndSounds(RandomSource var1, LivingEntity var2, ItemStack var3, int var4);

    @Inject(at={@At(value="HEAD")}, method={"onConsume"}, cancellable=true)
    private void stamina(Level level, LivingEntity living, ItemStack stack, CallbackInfoReturnable<ItemStack> cir) {
        PeakConsumable peakConsumable;
        RandomSource randomsource = living.getRandom();
        this.emitParticlesAndSounds(randomsource, living, stack, 16);
        if (living instanceof ServerPlayer) {
            ServerPlayer serverplayer = (ServerPlayer)living;
            serverplayer.awardStat(Stats.ITEM_USED.get((Object)stack.getItem()));
            CriteriaTriggers.CONSUME_ITEM.trigger(serverplayer, stack);
        }
        if ((peakConsumable = (PeakConsumable)stack.get(PeakDataComponents.CONSUMABLE)) == null) {
            peakConsumable = (PeakConsumable)BuiltInRegistries.ITEM.getData(PeakDataMaps.CONSUMABLES, stack.getItemHolder().getKey());
        }
        if (peakConsumable != null && living instanceof Player) {
            Player player = (Player)living;
            if (!level.isClientSide) {
                Poisonous poisonous;
                StaminaBar bar = (StaminaBar)player.getData(PeakAttachmentTypes.STAMINA_BAR);
                peakConsumable.effects().forEach((key, value) -> bar.addStatus((LivingEntity)player, (ResourceKey<AfflictionType>)key, value.floatValue()));
                bar.addExtraStamina(peakConsumable.extraStamina());
                if (((Float)stack.getOrDefault(PeakDataComponents.INFINITE_STAMINA, (Object)Float.valueOf(0.0f))).floatValue() > 0.0f) {
                    living.setData(PeakAttachmentTypes.INFINITE_TIMER, (Object)((int)(((Float)stack.getOrDefault(PeakDataComponents.INFINITE_STAMINA, (Object)Float.valueOf(0.0f))).floatValue() * 20.0f)));
                }
                if ((poisonous = (Poisonous)stack.get(PeakDataComponents.POISONOUS)) == null) {
                    poisonous = (Poisonous)BuiltInRegistries.ITEM.getData(PeakDataMaps.POISONOUS, stack.getItemHolder().getKey());
                }
                if (poisonous != null) {
                    if ((Integer)living.getData(PeakAttachmentTypes.POISON_TIMER) > 0 && (Integer)living.getData(PeakAttachmentTypes.POISON_COOLDOWN) <= 0) {
                        living.setData(PeakAttachmentTypes.POISON_TIMER, (Object)((int)(poisonous.time() * 20.0f) + (int)(poisonous.cooldown() * 20.0f) + (Integer)living.getData(PeakAttachmentTypes.POISON_TIMER)));
                    } else {
                        living.setData(PeakAttachmentTypes.POISON_COOLDOWN, (Object)((int)(poisonous.cooldown() * 20.0f)));
                        living.setData(PeakAttachmentTypes.POISON_TIMER, (Object)((int)(poisonous.time() * 20.0f)));
                    }
                }
            }
        } else {
            stack.getAllOfType(ConsumableListener.class).forEach(p_366420_ -> p_366420_.onConsume(level, living, stack, (Consumable)this));
            if (!level.isClientSide) {
                this.onConsumeEffects.forEach(p_366779_ -> p_366779_.apply(level, stack, living));
            }
        }
        living.gameEvent((Holder)(this.animation == ItemUseAnimation.DRINK ? GameEvent.DRINK : GameEvent.EAT));
        if (stack.getMaxDamage() <= 0) {
            stack.consume(1, living);
        } else {
            stack.hurtAndBreak(1, living, living.getUsedItemHand());
        }
        cir.setReturnValue((Object)stack);
    }
}

