/*
 * Decompiled with CFR 0.152.
 */
package net.tintankgames.peak.mixin;

import net.minecraft.core.component.DataComponentHolder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.item.AdventureModePredicate;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;
import net.tintankgames.peak.world.item.ScoutEffigyItem;
import net.tintankgames.peak.world.level.block.PitonBlock;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ItemStack.class})
public abstract class ItemStackMixin
implements DataComponentHolder {
    @Shadow
    public abstract Item getItem();

    @Shadow
    public abstract boolean canPlaceOnBlockInAdventureMode(BlockInWorld var1);

    @Inject(at={@At(value="HEAD")}, method={"canPlaceOnBlockInAdventureMode"}, cancellable=true)
    private void useEffigyInAdventure(BlockInWorld blockInWorld, CallbackInfoReturnable<Boolean> cir) {
        BlockItem blockItem;
        Item item;
        if (this.getItem() instanceof ScoutEffigyItem || (item = this.getItem()) instanceof BlockItem && (blockItem = (BlockItem)item).getBlock() instanceof PitonBlock) {
            AdventureModePredicate adventuremodepredicate = (AdventureModePredicate)this.get(DataComponents.CAN_PLACE_ON);
            cir.setReturnValue((Object)(adventuremodepredicate == null || adventuremodepredicate.test(blockInWorld) ? 1 : 0));
        }
    }
}

