/*
 * Decompiled with CFR 0.152.
 */
package net.tintankgames.peak.mixin;

import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.WalkAnimationState;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.PowderSnowBlock;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.tintankgames.peak.Config;
import net.tintankgames.peak.attachments.PeakAttachmentTypes;
import net.tintankgames.peak.stamina.StaminaBar;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin
extends Entity {
    @Shadow
    protected boolean jumping;
    @Shadow
    @Final
    public WalkAnimationState walkAnimation;

    @Shadow
    protected abstract float getFrictionInfluencedSpeed(float var1);

    @Shadow
    protected abstract Vec3 handleOnClimbable(Vec3 var1);

    @Shadow
    public abstract boolean onClimbable();

    @Shadow
    protected abstract Vec3 handleRelativeFrictionAndCalculateMovement(Vec3 var1, float var2);

    @Shadow
    @Nullable
    public abstract MobEffectInstance getEffect(Holder<MobEffect> var1);

    @Shadow
    protected abstract double getEffectiveGravity();

    @Shadow
    public abstract boolean shouldDiscardFriction();

    @Shadow
    public abstract boolean isBaby();

    public LivingEntityMixin(EntityType<?> p_19870_, Level p_19871_) {
        super(p_19870_, p_19871_);
    }

    @Inject(at={@At(value="HEAD")}, method={"travelInAir"}, cancellable=true)
    private void airTime(Vec3 p_362457_, CallbackInfo ci) {
        BlockPos blockpos = this.getBlockPosBelowThatAffectsMyMovement();
        float f = this.onGround() ? this.level().getBlockState(blockpos).getFriction((LevelReader)this.level(), blockpos, (Entity)this) : 1.0f;
        float f1 = f * 0.91f;
        Vec3 vec3 = this.handleRelativeFrictionAndCalculateMovement(p_362457_, f);
        double d0 = vec3.y;
        if (((Boolean)this.getData((Supplier)PeakAttachmentTypes.CLIMBING)).booleanValue() && (((StaminaBar)this.getData((Supplier)PeakAttachmentTypes.STAMINA_BAR)).hasStamina(this, true) || ((Vec3)this.getData((Supplier)PeakAttachmentTypes.MOVEMENT_LUNGE)).length() > 0.05 || ((Vec3)this.getData((AttachmentType)PeakAttachmentTypes.MOVEMENT_ASSIST.get())).length() > 0.05) && (this.level().getBlockState(this.blockPosition().relative(this.peak$getNearestViewDirection())).isFaceSturdy((BlockGetter)this.level(), this.blockPosition().relative(this.peak$getNearestViewDirection()), this.peak$getNearestViewDirection().getOpposite()) || this.level().getBlockState(this.blockPosition().above().relative(this.peak$getNearestViewDirection())).isFaceSturdy((BlockGetter)this.level(), this.blockPosition().above().relative(this.peak$getNearestViewDirection()), this.peak$getNearestViewDirection().getOpposite()))) {
            this.setDeltaMovement(vec3.x, vec3.y, vec3.z);
        } else {
            MobEffectInstance mobeffectinstance = this.getEffect((Holder<MobEffect>)MobEffects.LEVITATION);
            d0 = mobeffectinstance != null ? (d0 += (0.05 * (double)(mobeffectinstance.getAmplifier() + 1) - vec3.y) * 0.2) : (this.level().isClientSide && !this.level().hasChunkAt(blockpos) ? (this.getY() > (double)this.level().getMinY() ? -0.1 : 0.0) : (d0 -= this.getEffectiveGravity()));
            if (this.shouldDiscardFriction()) {
                this.setDeltaMovement(vec3.x, d0, vec3.z);
            } else {
                float f2 = this instanceof FlyingAnimal ? f1 : 0.98f;
                this.setDeltaMovement(vec3.x * (double)f1, d0 * (double)f2, vec3.z * (double)f1);
            }
        }
        ci.cancel();
    }

    @Inject(at={@At(value="HEAD")}, method={"handleRelativeFrictionAndCalculateMovement"}, cancellable=true)
    private void drag(Vec3 p_21075_, float p_21076_, CallbackInfoReturnable<Vec3> cir) {
        if (((Boolean)this.getData((Supplier)PeakAttachmentTypes.CLIMBING)).booleanValue() && (((StaminaBar)this.getData((Supplier)PeakAttachmentTypes.STAMINA_BAR)).hasStamina(this, true) || ((Vec3)this.getData((Supplier)PeakAttachmentTypes.MOVEMENT_LUNGE)).length() > 0.05 || ((Vec3)this.getData((AttachmentType)PeakAttachmentTypes.MOVEMENT_ASSIST.get())).length() > 0.05) && (this.level().getBlockState(this.blockPosition().relative(this.peak$getNearestViewDirection())).isFaceSturdy((BlockGetter)this.level(), this.blockPosition().relative(this.peak$getNearestViewDirection()), this.peak$getNearestViewDirection().getOpposite()) || this.level().getBlockState(this.blockPosition().above().relative(this.peak$getNearestViewDirection())).isFaceSturdy((BlockGetter)this.level(), this.blockPosition().above().relative(this.peak$getNearestViewDirection()), this.peak$getNearestViewDirection().getOpposite()))) {
            this.setData((Supplier)PeakAttachmentTypes.MOVEMENT_OLD, (Vec3)this.getData((Supplier)PeakAttachmentTypes.MOVEMENT));
            float staminaSpeedModifier = Mth.clamp((float)(((StaminaBar)this.getData((Supplier)PeakAttachmentTypes.STAMINA_BAR)).getStamina(true) * 5.0f), (float)0.002f, (float)1.0f);
            Vec2 movement = (Vec2)this.getData((Supplier)PeakAttachmentTypes.INPUT);
            double forward = Math.abs((double)movement.x * 0.07 * (double)staminaSpeedModifier) + 0.07;
            double side = (double)movement.x * 0.07 * (double)staminaSpeedModifier;
            double speedyTime = (Integer)this.getData((Supplier)PeakAttachmentTypes.ENERGY_TIMER) > 0 ? 2.5 : 1.0;
            double multiplier = Config.getClimbSpeedMultiplier();
            Vec3 vec3 = new Vec3(this.peak$getNearestViewDirection().getAxis() == Direction.Axis.X ? (double)this.peak$getNearestViewDirection().getStepX() * forward : (double)this.peak$getNearestViewDirection().getStepZ() * side, (double)movement.y * 0.07 * (double)(movement.y < 0.0f ? 2 : 1) * (double)staminaSpeedModifier, this.peak$getNearestViewDirection().getAxis() == Direction.Axis.Z ? (double)this.peak$getNearestViewDirection().getStepZ() * forward : (double)(-this.peak$getNearestViewDirection().getStepX()) * side).subtract(0.0, this.level().isRainingAt(this.blockPosition()) && movement.length() > 0.05f ? 0.03 * (double)staminaSpeedModifier : 0.0, 0.0).multiply(multiplier, multiplier, multiplier).multiply(speedyTime, speedyTime, speedyTime).add((Vec3)this.getData((Supplier)PeakAttachmentTypes.MOVEMENT_LUNGE)).add((Vec3)this.getData((Supplier)PeakAttachmentTypes.MOVEMENT_ASSIST));
            if (movement.length() <= 0.05f) {
                this.setData((Supplier)PeakAttachmentTypes.MOVEMENT, Mth.lerp((double)0.5, (Vec3)((Vec3)this.getData((Supplier)PeakAttachmentTypes.MOVEMENT_OLD)), (Vec3)Vec3.ZERO));
            } else {
                this.setData((Supplier)PeakAttachmentTypes.MOVEMENT, vec3);
            }
            this.setData((Supplier)PeakAttachmentTypes.MOVEMENT_LUNGE, Mth.lerp((double)0.2, (Vec3)((Vec3)this.getData((Supplier)PeakAttachmentTypes.MOVEMENT_LUNGE)), (Vec3)Vec3.ZERO));
            if (((Vec3)this.getData((Supplier)PeakAttachmentTypes.MOVEMENT_LUNGE)).length() <= 0.05) {
                this.setData((Supplier)PeakAttachmentTypes.MOVEMENT_LUNGE, Vec3.ZERO);
            }
            this.setData((Supplier)PeakAttachmentTypes.MOVEMENT_ASSIST, Mth.lerp((double)0.5, (Vec3)((Vec3)this.getData((Supplier)PeakAttachmentTypes.MOVEMENT_ASSIST)), (Vec3)Vec3.ZERO));
            if (((Vec3)this.getData((Supplier)PeakAttachmentTypes.MOVEMENT_ASSIST)).length() <= 0.05) {
                this.setData((Supplier)PeakAttachmentTypes.MOVEMENT_ASSIST, Vec3.ZERO);
            }
            this.move(MoverType.SELF, this.getDeltaMovement());
            cir.setReturnValue((Object)((Vec3)this.getData((Supplier)PeakAttachmentTypes.MOVEMENT)).subtract(0.0, this.level().isRainingAt(this.blockPosition()) && movement.length() <= 0.05f ? 0.03 : 0.0, 0.0));
        } else {
            this.moveRelative(this.getFrictionInfluencedSpeed(p_21076_), p_21075_);
            this.setDeltaMovement(this.handleOnClimbable(this.getDeltaMovement()));
            this.move(MoverType.SELF, this.getDeltaMovement());
            Vec3 vec3 = this.getDeltaMovement();
            if ((this.horizontalCollision || this.jumping) && (this.onClimbable() || this.wasInPowderSnow && PowderSnowBlock.canEntityWalkOnPowderSnow((Entity)this))) {
                vec3 = new Vec3(vec3.x, 0.2, vec3.z);
            }
            cir.setReturnValue((Object)vec3);
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"updateWalkAnimation"}, cancellable=true)
    private void noAnims(float p_268283_, CallbackInfo ci) {
        Player player;
        LivingEntityMixin livingEntityMixin = this;
        if (livingEntityMixin instanceof Player && ((Boolean)(player = (Player)livingEntityMixin).getData(PeakAttachmentTypes.CLIMBING)).booleanValue() && (this.level().getBlockState(this.blockPosition().relative(this.peak$getNearestViewDirection())).isFaceSturdy((BlockGetter)this.level(), this.blockPosition().relative(this.peak$getNearestViewDirection()), this.peak$getNearestViewDirection().getOpposite()) || this.level().getBlockState(this.blockPosition().above().relative(this.peak$getNearestViewDirection())).isFaceSturdy((BlockGetter)this.level(), this.blockPosition().above().relative(this.peak$getNearestViewDirection()), this.peak$getNearestViewDirection().getOpposite())) && ((StaminaBar)player.getData(PeakAttachmentTypes.STAMINA_BAR)).hasStamina(this, true)) {
            this.walkAnimation.update(0.0f, 1.0f, this.isBaby() ? 3.0f : 1.0f);
            ci.cancel();
        }
    }

    @Unique
    private Vec3 peak$getViewVector(float p_20253_) {
        return this.calculateViewVector(0.0f, this.getViewYRot(p_20253_));
    }

    @Unique
    private Direction peak$getNearestViewDirection() {
        return Direction.getApproximateNearest((Vec3)this.peak$getViewVector(1.0f));
    }
}

