/*
 * Decompiled with CFR 0.152.
 */
package net.tintankgames.peak.mixin;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.client.renderer.entity.state.PlayerRenderState;
import net.minecraft.core.Direction;
import net.minecraft.util.ARGB;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.client.event.RenderLivingEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.tintankgames.peak.client.PeakClient;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LivingEntityRenderer.class})
public abstract class LivingEntityRendererMixin<T extends LivingEntity, S extends LivingEntityRenderState, M extends EntityModel<? super S>>
extends EntityRenderer<T, S>
implements RenderLayerParent<S, M> {
    @Shadow
    @Final
    protected List<RenderLayer<S, M>> layers;
    @Shadow
    protected M model;

    @Shadow
    protected abstract void setupRotations(S var1, PoseStack var2, float var3, float var4);

    @Shadow
    protected abstract void scale(S var1, PoseStack var2);

    @Shadow
    protected abstract boolean isBodyVisible(S var1);

    @Shadow
    @Nullable
    protected abstract RenderType getRenderType(S var1, boolean var2, boolean var3, boolean var4);

    @Shadow
    public static int getOverlayCoords(LivingEntityRenderState p_362833_, float p_115340_) {
        return 0;
    }

    @Shadow
    protected abstract float getWhiteOverlayProgress(S var1);

    @Shadow
    protected abstract int getModelTint(S var1);

    @Shadow
    protected abstract boolean shouldRenderLayers(S var1);

    protected LivingEntityRendererMixin(EntityRendererProvider.Context p_174008_) {
        super(p_174008_);
    }

    @Inject(at={@At(value="HEAD")}, method={"render(Lnet/minecraft/client/renderer/entity/state/LivingEntityRenderState;Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;I)V"}, cancellable=true)
    private void changeModel(S s, PoseStack p_115311_, MultiBufferSource p_115312_, int p_115313_, CallbackInfo ci) {
        PlayerRenderState renderState;
        if (s instanceof PlayerRenderState && !((Boolean)(renderState = (PlayerRenderState)s).getRenderDataOrDefault(PeakClient.IS_LOCAL_PLAYER, (Object)false)).booleanValue() && ((Boolean)renderState.getRenderDataOrDefault(PeakClient.IS_CHICKEN, (Object)false)).booleanValue()) {
            if (!((RenderLivingEvent.Pre)NeoForge.EVENT_BUS.post((Event)new RenderLivingEvent.Pre(s, (LivingEntityRenderer)this, renderState.partialTick, p_115311_, p_115312_, p_115313_))).isCanceled()) {
                Direction direction;
                p_115311_.pushPose();
                if (renderState.hasPose(Pose.SLEEPING) && (direction = renderState.bedOrientation) != null) {
                    float f = renderState.eyeHeight - 0.1f;
                    p_115311_.translate((float)(-direction.getStepX()) * f, 0.0f, (float)(-direction.getStepZ()) * f);
                }
                float f1 = renderState.scale;
                p_115311_.scale(f1, f1, f1);
                this.setupRotations(s, p_115311_, renderState.bodyRot, f1);
                p_115311_.scale(-1.0f, -1.0f, 1.0f);
                this.scale(s, p_115311_);
                p_115311_.translate(0.0f, -1.501f, 0.0f);
                this.model.setupAnim(s);
                PeakClient.chickenMan.get().setupAnim(renderState);
                boolean flag1 = this.isBodyVisible(s);
                boolean flag = !flag1 && !renderState.isInvisibleToPlayer;
                RenderType rendertype = this.getRenderType(s, flag1, flag, renderState.appearsGlowing);
                if (rendertype != null) {
                    VertexConsumer vertexconsumer = p_115312_.getBuffer(rendertype);
                    int i = LivingEntityRendererMixin.getOverlayCoords((LivingEntityRenderState)renderState, this.getWhiteOverlayProgress(s));
                    int j = flag ? 0x26FFFFFF : -1;
                    int k = ARGB.multiply((int)j, (int)this.getModelTint(s));
                    PeakClient.chickenMan.get().renderToBuffer(p_115311_, vertexconsumer, p_115313_, i, k);
                }
                if (this.shouldRenderLayers(s)) {
                    for (RenderLayer<S, M> renderlayer : this.layers) {
                        renderlayer.render(p_115311_, p_115312_, p_115313_, s, renderState.yRot, renderState.xRot);
                    }
                }
                p_115311_.popPose();
                super.render(s, p_115311_, p_115312_, p_115313_);
                NeoForge.EVENT_BUS.post((Event)new RenderLivingEvent.Post(s, (LivingEntityRenderer)this, renderState.partialTick, p_115311_, p_115312_, p_115313_));
            }
            ci.cancel();
        }
    }
}

