/*
 * Decompiled with CFR 0.152.
 */
package net.tintankgames.peak.mixin;

import com.mojang.authlib.GameProfile;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.player.ClientInput;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Input;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.client.network.ClientPacketDistributor;
import net.tintankgames.peak.attachments.PeakAttachmentTypes;
import net.tintankgames.peak.network.GrabPitonMessage;
import net.tintankgames.peak.network.LungeMessage;
import net.tintankgames.peak.network.PlacePitonMessage;
import net.tintankgames.peak.network.SyncDataMessage;
import net.tintankgames.peak.stamina.StaminaBar;
import net.tintankgames.peak.world.level.block.PeakBlocks;
import net.tintankgames.peak.world.level.block.PitonBlock;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LocalPlayer.class})
public abstract class LocalPlayerMixin
extends AbstractClientPlayer {
    @Shadow
    public ClientInput input;
    @Shadow
    @Final
    protected Minecraft minecraft;

    @Shadow
    protected abstract Vec2 modifyInput(Vec2 var1);

    public LocalPlayerMixin(ClientLevel p_250460_, GameProfile p_249912_) {
        super(p_250460_, p_249912_);
    }

    @Inject(at={@At(value="RETURN")}, method={"tick"})
    private void syncInput(CallbackInfo ci) {
        if (this.hasClientLoaded()) {
            BlockHitResult hit;
            boolean climbing;
            this.setData((Supplier)PeakAttachmentTypes.CLIMBING, Minecraft.getInstance().options.keyUse.isDown() && this.getMainHandItem().isEmpty() && this.getOffhandItem().isEmpty());
            this.setData((Supplier)PeakAttachmentTypes.SNEAKING, Minecraft.getInstance().options.keyShift.isDown());
            this.setData((Supplier)PeakAttachmentTypes.SPRINTING, Minecraft.getInstance().options.keySprint.isDown());
            this.setData((Supplier)PeakAttachmentTypes.INTERACTING, Minecraft.getInstance().options.keyUse.isDown());
            this.setData((Supplier)PeakAttachmentTypes.GIVING_UP, Minecraft.getInstance().options.keyInventory.isDown() && (Integer)this.getData((Supplier)PeakAttachmentTypes.DEATH_TIMER) >= 0);
            this.setData((Supplier)PeakAttachmentTypes.INPUT, this.modifyInput(this.input.getMoveVector()));
            ClientPacketDistributor.sendToServer((CustomPacketPayload)new SyncDataMessage(Minecraft.getInstance().options.keyUse.isDown() && this.getMainHandItem().isEmpty() && this.getOffhandItem().isEmpty(), Minecraft.getInstance().options.keyShift.isDown(), Minecraft.getInstance().options.keySprint.isDown(), Minecraft.getInstance().options.keyUse.isDown(), Minecraft.getInstance().options.keyInventory.isDown() && (Integer)this.getData((Supplier)PeakAttachmentTypes.DEATH_TIMER) >= 0, this.modifyInput(this.input.getMoveVector())), (CustomPacketPayload[])new CustomPacketPayload[0]);
            boolean bl = climbing = (Boolean)this.getData((Supplier)PeakAttachmentTypes.CLIMBING) != false && ((StaminaBar)this.getData((Supplier)PeakAttachmentTypes.STAMINA_BAR)).hasStamina((Entity)this, true) && (this.level().getBlockState(this.blockPosition().relative(this.peak$getNearestViewDirection())).isFaceSturdy((BlockGetter)this.level(), this.blockPosition().relative(this.peak$getNearestViewDirection()), this.peak$getNearestViewDirection().getOpposite()) || this.level().getBlockState(this.blockPosition().above().relative(this.peak$getNearestViewDirection())).isFaceSturdy((BlockGetter)this.level(), this.blockPosition().above().relative(this.peak$getNearestViewDirection()), this.peak$getNearestViewDirection().getOpposite()));
            if (Minecraft.getInstance().options.keyShift.consumeClick()) {
                ClientPacketDistributor.sendToServer((CustomPacketPayload)new LungeMessage(true), (CustomPacketPayload[])new CustomPacketPayload[0]);
                if (climbing && ((Vec3)this.getData((Supplier)PeakAttachmentTypes.MOVEMENT_LUNGE)).length() <= 0.05) {
                    Vec2 movement = (Vec2)this.getData((Supplier)PeakAttachmentTypes.INPUT);
                    double forward = Math.abs((double)movement.x * 0.2);
                    double side = (double)movement.x * 0.5;
                    this.setData((Supplier)PeakAttachmentTypes.MOVEMENT_LUNGE, new Vec3(this.peak$getNearestViewDirection().getAxis() == Direction.Axis.X ? (double)this.peak$getNearestViewDirection().getStepX() * forward : (double)this.peak$getNearestViewDirection().getStepZ() * side, (double)movement.y * 0.5, this.peak$getNearestViewDirection().getAxis() == Direction.Axis.Z ? (double)this.peak$getNearestViewDirection().getStepZ() * forward : (double)(-this.peak$getNearestViewDirection().getStepX()) * side));
                }
            }
            if (Minecraft.getInstance().options.keyInventory.isDown() && (Integer)this.getData((Supplier)PeakAttachmentTypes.PLACE_PITON_COOLDOWN) <= 0 && climbing && (hit = this.level().clip(new ClipContext(this.getEyePosition(), this.getEyePosition().add(this.getViewVector(1.0f).scale(this.getAttributeValue(Attributes.BLOCK_INTERACTION_RANGE))), ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)this))).getType() != HitResult.Type.MISS) {
                if (this.level().getBlockState(hit.getBlockPos()).is(PeakBlocks.PITON)) {
                    ClientPacketDistributor.sendToServer((CustomPacketPayload)new GrabPitonMessage(hit.getBlockPos()), (CustomPacketPayload[])new CustomPacketPayload[0]);
                } else if (hit.getDirection().getAxis() != Direction.Axis.Y && this.getInventory().contains(stack -> stack.is(PeakBlocks.PITON.asItem()))) {
                    BlockState state = (BlockState)((Block)PeakBlocks.PITON.get()).defaultBlockState().setValue((Property)PitonBlock.FACING, (Comparable)hit.getDirection());
                    BlockPos pos = hit.getBlockPos().relative(hit.getDirection());
                    ClientPacketDistributor.sendToServer((CustomPacketPayload)new PlacePitonMessage(state, pos), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
            }
            if (climbing) {
                this.setYBodyRot(this.peak$getNearestViewDirection().toYRot());
            }
            if (((Boolean)this.getData((Supplier)PeakAttachmentTypes.GRABBING_PITON)).booleanValue()) {
                this.setDeltaMovement(0.0, 0.0, 0.0);
                this.resetFallDistance();
            }
            if (((Boolean)this.getData((Supplier)PeakAttachmentTypes.SNEAKING)).booleanValue() && ((Boolean)this.getData((Supplier)PeakAttachmentTypes.GRABBING_PITON)).booleanValue()) {
                this.setData((Supplier)PeakAttachmentTypes.GRABBING_PITON, false);
                this.setData((Supplier)PeakAttachmentTypes.GRABBED_PITON, BlockPos.ZERO);
            }
        }
    }

    @Inject(at={@At(value="INVOKE", target="Lnet/minecraft/client/player/AbstractClientPlayer;tick()V", shift=At.Shift.AFTER)}, method={"tick"})
    private void noSneaking(CallbackInfo ci) {
        if (((Boolean)this.getData((Supplier)PeakAttachmentTypes.CLIMBING)).booleanValue() && ((StaminaBar)this.getData((Supplier)PeakAttachmentTypes.STAMINA_BAR)).hasStamina((Entity)this, true)) {
            this.input.keyPresses = new Input(this.minecraft.options.keyUp.isDown(), this.minecraft.options.keyDown.isDown(), this.minecraft.options.keyLeft.isDown(), this.minecraft.options.keyRight.isDown(), this.minecraft.options.keyJump.isDown(), false, this.minecraft.options.keySprint.isDown());
        }
    }

    @Unique
    private Vec3 peak$getViewVector(float p_20253_) {
        return this.calculateViewVector(0.0f, this.getViewYRot(p_20253_));
    }

    @Unique
    private Direction peak$getNearestViewDirection() {
        return Direction.getApproximateNearest((Vec3)this.peak$getViewVector(1.0f));
    }
}

