/*
 * Decompiled with CFR 0.152.
 */
package net.tintankgames.peak.mixin;

import net.minecraft.client.animation.KeyframeAnimation;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.entity.state.PlayerRenderState;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.AnimationState;
import net.tintankgames.peak.client.PeakClient;
import net.tintankgames.peak.client.animation.definitions.PlayerAnimation;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={PlayerModel.class})
public abstract class PlayerModelMixin {
    @Unique
    private KeyframeAnimation peak$climbingAnimation;
    @Unique
    private KeyframeAnimation peak$climbingIdleAnimation;
    @Unique
    private KeyframeAnimation peak$holdingPitonAnimation;

    @Inject(at={@At(value="RETURN")}, method={"<init>"})
    private void init(ModelPart root, boolean slim, CallbackInfo ci) {
        this.peak$climbingAnimation = PlayerAnimation.CLIMBING.bake(root);
        this.peak$climbingIdleAnimation = PlayerAnimation.CLIMBING_IDLE.bake(root);
        this.peak$holdingPitonAnimation = PlayerAnimation.HOLDING_PITON.bake(root);
    }

    @Inject(at={@At(value="RETURN")}, method={"setupAnim(Lnet/minecraft/client/renderer/entity/state/PlayerRenderState;)V"})
    private void animate(PlayerRenderState state, CallbackInfo ci) {
        AnimationState climbing = (AnimationState)state.getRenderData(PeakClient.CLIMBING);
        AnimationState climbingIdle = (AnimationState)state.getRenderData(PeakClient.CLIMBING_IDLE);
        AnimationState holdingPiton = (AnimationState)state.getRenderData(PeakClient.HOLDING_PITON);
        float staminaSpeedModifier = Mth.clamp((float)(((Float)state.getRenderDataOrDefault(PeakClient.STAMINA, (Object)Float.valueOf(1.0f))).floatValue() * 5.0f), (float)0.002f, (float)1.0f);
        if (climbing != null) {
            this.peak$climbingAnimation.apply(climbing, state.ageInTicks, staminaSpeedModifier);
        }
        if (climbingIdle != null) {
            this.peak$climbingIdleAnimation.apply(climbingIdle, state.ageInTicks);
        }
        if (holdingPiton != null) {
            this.peak$holdingPitonAnimation.apply(holdingPiton, state.ageInTicks);
        }
    }
}

