/*
 * Decompiled with CFR 0.152.
 */
package net.tintankgames.peak.network;

import net.minecraft.client.Minecraft;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.tintankgames.peak.attachments.PeakAttachmentTypes;
import net.tintankgames.peak.network.PeakNetworking;

public record AssistMessage(float xRot, float yRot, double scale) implements CustomPacketPayload
{
    public static final StreamCodec<RegistryFriendlyByteBuf, AssistMessage> CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.FLOAT, AssistMessage::xRot, (StreamCodec)ByteBufCodecs.FLOAT, AssistMessage::yRot, (StreamCodec)ByteBufCodecs.DOUBLE, AssistMessage::scale, AssistMessage::new);

    public static void handle(AssistMessage message, IPayloadContext context) {
        context.enqueueWork(() -> {
            if (context.flow().isClientbound()) {
                Minecraft.getInstance().player.setData(PeakAttachmentTypes.MOVEMENT_ASSIST, (Object)Vec3.directionFromRotation((float)message.xRot, (float)message.yRot).multiply(message.scale, message.scale, message.scale));
            }
        });
    }

    public CustomPacketPayload.Type<AssistMessage> type() {
        return PeakNetworking.ASSIST;
    }
}

