/*
 * Decompiled with CFR 0.152.
 */
package net.tintankgames.peak.network;

import net.minecraft.core.Direction;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.tintankgames.peak.attachments.PeakAttachmentTypes;
import net.tintankgames.peak.network.PeakNetworking;
import net.tintankgames.peak.stamina.StaminaBar;
import org.spongepowered.asm.mixin.Unique;

public record LungeMessage(boolean doingIt) implements CustomPacketPayload
{
    public static final StreamCodec<RegistryFriendlyByteBuf, LungeMessage> CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.BOOL, LungeMessage::doingIt, LungeMessage::new);

    public static void handle(LungeMessage message, IPayloadContext context) {
        context.enqueueWork(() -> {
            ServerPlayer player;
            Player patt0$temp;
            if (context.flow().isServerbound() && (patt0$temp = context.player()) instanceof ServerPlayer && ((Boolean)(player = (ServerPlayer)patt0$temp).getData(PeakAttachmentTypes.CLIMBING)).booleanValue() && ((StaminaBar)player.getData(PeakAttachmentTypes.STAMINA_BAR)).hasStamina((Entity)player, true) && ((Vec3)player.getData(PeakAttachmentTypes.MOVEMENT_LUNGE)).length() <= 0.05) {
                ((StaminaBar)player.getData(PeakAttachmentTypes.STAMINA_BAR)).useStamina((Entity)player, 0.15f, true);
                Vec2 movement = (Vec2)player.getData(PeakAttachmentTypes.INPUT);
                double forward = Math.abs((double)movement.x * 0.2);
                double side = (double)movement.x * 0.5;
                player.setData(PeakAttachmentTypes.MOVEMENT_LUNGE, (Object)new Vec3(LungeMessage.getNearestViewDirection((Player)player).getAxis() == Direction.Axis.X ? (double)LungeMessage.getNearestViewDirection((Player)player).getStepX() * forward : (double)LungeMessage.getNearestViewDirection((Player)player).getStepZ() * side, (double)movement.y * 0.5, LungeMessage.getNearestViewDirection((Player)player).getAxis() == Direction.Axis.Z ? (double)LungeMessage.getNearestViewDirection((Player)player).getStepZ() * forward : (double)(-LungeMessage.getNearestViewDirection((Player)player).getStepX()) * side));
            }
        });
    }

    @Unique
    private static Vec3 getViewVector(float p_20253_, Player player) {
        return player.calculateViewVector(0.0f, player.getViewYRot(p_20253_));
    }

    @Unique
    private static Direction getNearestViewDirection(Player player) {
        return Direction.getApproximateNearest((Vec3)LungeMessage.getViewVector(1.0f, player));
    }

    public CustomPacketPayload.Type<LungeMessage> type() {
        return PeakNetworking.LUNGE;
    }
}

