/*
 * Decompiled with CFR 0.152.
 */
package net.tintankgames.peak.network;

import com.mojang.serialization.Codec;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.tintankgames.peak.attachments.PeakAttachmentTypes;
import net.tintankgames.peak.network.PeakNetworking;
import net.tintankgames.peak.world.level.block.PeakBlocks;

public record PlacePitonMessage(BlockState state, BlockPos pos) implements CustomPacketPayload
{
    public static final StreamCodec<RegistryFriendlyByteBuf, PlacePitonMessage> CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.fromCodec((Codec)BlockState.CODEC), PlacePitonMessage::state, (StreamCodec)BlockPos.STREAM_CODEC, PlacePitonMessage::pos, PlacePitonMessage::new);

    public static void handle(PlacePitonMessage message, IPayloadContext context) {
        context.enqueueWork(() -> {
            Player patt0$temp;
            if (context.flow().isServerbound() && (patt0$temp = context.player()) instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)patt0$temp;
                player.level().setBlockAndUpdate(message.pos, message.state);
                SoundType soundType = message.state.getSoundType((LevelReader)player.level(), message.pos, (Entity)player);
                player.level().playSound(null, message.pos, soundType.getPlaceSound(), SoundSource.BLOCKS, soundType.getVolume(), soundType.getPitch());
                List<ItemStack> stacks = player.getInventory().getNonEquipmentItems().stream().filter(stack -> stack.is(PeakBlocks.PITON.asItem())).toList();
                if (!stacks.isEmpty()) {
                    stacks.getLast().consume(1, (LivingEntity)player);
                }
                player.setData(PeakAttachmentTypes.PLACE_PITON_COOLDOWN, (Object)10);
            }
        });
    }

    public CustomPacketPayload.Type<PlacePitonMessage> type() {
        return PeakNetworking.PLACE_PITON;
    }
}

