/*
 * Decompiled with CFR 0.152.
 */
package net.tintankgames.peak.network;

import com.mojang.serialization.Codec;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec2;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.tintankgames.peak.attachments.PeakAttachmentTypes;
import net.tintankgames.peak.network.PeakNetworking;

public record SyncDataMessage(boolean climbing, boolean sneaking, boolean sprinting, boolean interacting, boolean givingUp, Vec2 input) implements CustomPacketPayload
{
    public static final StreamCodec<RegistryFriendlyByteBuf, SyncDataMessage> CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.BOOL, SyncDataMessage::climbing, (StreamCodec)ByteBufCodecs.BOOL, SyncDataMessage::sneaking, (StreamCodec)ByteBufCodecs.BOOL, SyncDataMessage::sprinting, (StreamCodec)ByteBufCodecs.BOOL, SyncDataMessage::interacting, (StreamCodec)ByteBufCodecs.BOOL, SyncDataMessage::givingUp, (StreamCodec)ByteBufCodecs.fromCodec((Codec)Vec2.CODEC), SyncDataMessage::input, SyncDataMessage::new);

    public static void handle(SyncDataMessage message, IPayloadContext context) {
        context.enqueueWork(() -> {
            Player patt0$temp;
            if (context.flow().isServerbound() && (patt0$temp = context.player()) instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)patt0$temp;
                player.setData(PeakAttachmentTypes.CLIMBING, (Object)message.climbing);
                player.setData(PeakAttachmentTypes.SNEAKING, (Object)message.sneaking);
                player.setData(PeakAttachmentTypes.SPRINTING, (Object)message.sprinting);
                player.setData(PeakAttachmentTypes.INTERACTING, (Object)message.interacting);
                player.setData(PeakAttachmentTypes.GIVING_UP, (Object)(message.givingUp && (Integer)player.getData(PeakAttachmentTypes.DEATH_TIMER) >= 0 ? 1 : 0));
                player.setData(PeakAttachmentTypes.INPUT, (Object)message.input);
            }
        });
    }

    public CustomPacketPayload.Type<SyncDataMessage> type() {
        return PeakNetworking.SYNC_DATA;
    }
}

