/*
 * Decompiled with CFR 0.152.
 */
package net.tintankgames.peak.network;

import com.mojang.serialization.Codec;
import java.util.UUID;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.tintankgames.peak.attachments.PeakAttachmentTypes;
import net.tintankgames.peak.network.PeakNetworking;
import net.tintankgames.peak.stamina.StaminaBar;

public record SyncPlayersMessage(UUID entity, boolean climbing, boolean grabbingPiton, int deathTimer, Vec2 input, Vec3 movementLunge, Vec3 movementAssist, StaminaBar staminaBar) implements CustomPacketPayload
{
    public static final StreamCodec<RegistryFriendlyByteBuf, SyncPlayersMessage> CODEC = StreamCodec.composite((StreamCodec)UUIDUtil.STREAM_CODEC, SyncPlayersMessage::entity, (StreamCodec)ByteBufCodecs.BOOL, SyncPlayersMessage::climbing, (StreamCodec)ByteBufCodecs.BOOL, SyncPlayersMessage::grabbingPiton, (StreamCodec)ByteBufCodecs.VAR_INT, SyncPlayersMessage::deathTimer, (StreamCodec)ByteBufCodecs.fromCodec((Codec)Vec2.CODEC), SyncPlayersMessage::input, (StreamCodec)Vec3.STREAM_CODEC, SyncPlayersMessage::movementLunge, (StreamCodec)Vec3.STREAM_CODEC, SyncPlayersMessage::movementAssist, StaminaBar.STREAM_CODEC, SyncPlayersMessage::staminaBar, SyncPlayersMessage::new);

    public static void handle(SyncPlayersMessage message, IPayloadContext context) {
        context.enqueueWork(() -> {
            Entity entity;
            if (context.flow().isClientbound() && (entity = context.player().level().getEntity(message.entity)) != null) {
                entity.setData(PeakAttachmentTypes.MOVEMENT_LUNGE, (Object)message.movementLunge);
                entity.setData(PeakAttachmentTypes.MOVEMENT_ASSIST, (Object)message.movementAssist);
                entity.setData(PeakAttachmentTypes.CLIMBING, (Object)message.climbing);
                entity.setData(PeakAttachmentTypes.GRABBING_PITON, (Object)message.grabbingPiton);
                entity.setData(PeakAttachmentTypes.DEATH_TIMER, (Object)message.deathTimer);
                entity.setData(PeakAttachmentTypes.INPUT, (Object)message.input);
                entity.setData(PeakAttachmentTypes.STAMINA_BAR, (Object)message.staminaBar);
            }
        });
    }

    public CustomPacketPayload.Type<SyncPlayersMessage> type() {
        return PeakNetworking.SYNC_PLAYERS;
    }
}

