/*
 * Decompiled with CFR 0.152.
 */
package net.tintankgames.peak.server.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.tintankgames.peak.attachments.PeakAttachmentTypes;
import net.tintankgames.peak.stamina.StaminaBar;

@EventBusSubscriber
public class ReviveCommand {
    private static final DynamicCommandExceptionType ERROR_INVALID_AFFLICTION = new DynamicCommandExceptionType(o -> Component.literal((String)("There is no affliction with type \"" + String.valueOf(o) + "\"")));

    @SubscribeEvent
    public static void register(RegisterCommandsEvent event) {
        event.getDispatcher().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"revive").requires(source -> source.hasPermission(2))).then(Commands.argument((String)"target", (ArgumentType)EntityArgument.players()).executes(ReviveCommand::clearAfflictions)));
    }

    private static int clearAfflictions(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        int result = 0;
        for (ServerPlayer player : EntityArgument.getPlayers(context, (String)"target")) {
            ((StaminaBar)player.getData(PeakAttachmentTypes.STAMINA_BAR)).revive(player);
            ++result;
        }
        return result;
    }
}

