/*
 * Decompiled with CFR 0.152.
 */
package net.tintankgames.peak.server.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.ResourceKeyArgument;
import net.minecraft.commands.arguments.TimeArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.tintankgames.peak.Peak;
import net.tintankgames.peak.attachments.PeakAttachmentTypes;
import net.tintankgames.peak.core.registries.PeakRegistries;
import net.tintankgames.peak.stamina.AfflictionType;
import net.tintankgames.peak.stamina.AfflictionTypes;
import net.tintankgames.peak.stamina.StaminaBar;

@EventBusSubscriber
public class StaminaCommand {
    private static final DynamicCommandExceptionType ERROR_INVALID_AFFLICTION = new DynamicCommandExceptionType(o -> Component.literal((String)("There is no affliction with type \"" + String.valueOf(o) + "\"")));

    @SubscribeEvent
    public static void register(RegisterCommandsEvent event) {
        event.getDispatcher().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"stamina").requires(source -> source.hasPermission(2))).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument((String)"target", (ArgumentType)EntityArgument.players()).then(Commands.literal((String)"clear").executes(StaminaCommand::clearAfflictions))).then(((LiteralArgumentBuilder)Commands.literal((String)"add").then(Commands.argument((String)"affliction", (ArgumentType)ResourceKeyArgument.key(PeakRegistries.AFFLICTION_TYPE)).then(Commands.argument((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)1, (int)80)).executes(StaminaCommand::addStatus)))).then(Commands.literal((String)"peak:extra_stamina").then(Commands.argument((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)1, (int)40)).executes(StaminaCommand::addExtraStamina))))).then(((LiteralArgumentBuilder)Commands.literal((String)"remove").then(Commands.argument((String)"affliction", (ArgumentType)ResourceKeyArgument.key(PeakRegistries.AFFLICTION_TYPE)).then(Commands.argument((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)1, (int)80)).executes(StaminaCommand::removeStatus)))).then(Commands.literal((String)"peak:extra_stamina").then(Commands.argument((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)1, (int)40)).executes(StaminaCommand::removeExtraStamina))))).then(((LiteralArgumentBuilder)Commands.literal((String)"effect").then(((LiteralArgumentBuilder)Commands.literal((String)"sugar_rush").executes(StaminaCommand::applyDefaultSugarRush)).then(Commands.argument((String)"duration", (ArgumentType)TimeArgument.time()).executes(StaminaCommand::applySugarRush)))).then(((LiteralArgumentBuilder)Commands.literal((String)"energy_drink").executes(StaminaCommand::applyDefaultEnergyDrink)).then(Commands.argument((String)"duration", (ArgumentType)TimeArgument.time()).executes(StaminaCommand::applyEnergyDrink))))));
    }

    private static int clearAfflictions(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        int result = 0;
        for (ServerPlayer player : EntityArgument.getPlayers(context, (String)"target")) {
            StaminaBar bar = (StaminaBar)player.getData(PeakAttachmentTypes.STAMINA_BAR);
            if (bar.getTotalAffliction() > 0.0f) {
                if ((Integer)player.getData(PeakAttachmentTypes.DEATH_TIMER) >= 0) {
                    bar.revive(player);
                }
                bar.clearStatus((LivingEntity)player, true);
            }
            bar.setExtraStamina(0.0f);
        }
        return result;
    }

    private static int addStatus(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        int result = 0;
        for (ServerPlayer player : EntityArgument.getPlayers(context, (String)"target")) {
            StaminaBar bar = (StaminaBar)player.getData(PeakAttachmentTypes.STAMINA_BAR);
            ResourceKey type = ResourceKeyArgument.getRegistryKey(context, (String)"affliction", PeakRegistries.AFFLICTION_TYPE, (DynamicCommandExceptionType)ERROR_INVALID_AFFLICTION);
            int amount = IntegerArgumentType.getInteger(context, (String)"amount");
            bar.addStatus((LivingEntity)player, (ResourceKey<AfflictionType>)type, (float)amount * 0.025f);
        }
        return result;
    }

    private static int removeStatus(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        int result = 0;
        for (ServerPlayer player : EntityArgument.getPlayers(context, (String)"target")) {
            StaminaBar bar = (StaminaBar)player.getData(PeakAttachmentTypes.STAMINA_BAR);
            ResourceKey type = ResourceKeyArgument.getRegistryKey(context, (String)"affliction", PeakRegistries.AFFLICTION_TYPE, (DynamicCommandExceptionType)ERROR_INVALID_AFFLICTION);
            int amount = IntegerArgumentType.getInteger(context, (String)"amount");
            bar.removeStatus((ResourceKey<AfflictionType>)type, (float)amount * 0.025f);
        }
        return result;
    }

    private static int addExtraStamina(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        int result = 0;
        for (ServerPlayer player : EntityArgument.getPlayers(context, (String)"target")) {
            StaminaBar bar = (StaminaBar)player.getData(PeakAttachmentTypes.STAMINA_BAR);
            int amount = IntegerArgumentType.getInteger(context, (String)"amount");
            bar.addExtraStamina((float)amount * 0.025f);
        }
        return result;
    }

    private static int removeExtraStamina(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        int result = 0;
        for (ServerPlayer player : EntityArgument.getPlayers(context, (String)"target")) {
            StaminaBar bar = (StaminaBar)player.getData(PeakAttachmentTypes.STAMINA_BAR);
            int amount = IntegerArgumentType.getInteger(context, (String)"amount");
            bar.removeExtraStamina((float)amount * 0.025f);
        }
        return result;
    }

    private static int applyDefaultSugarRush(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        int result = 0;
        for (ServerPlayer player : EntityArgument.getPlayers(context, (String)"target")) {
            player.setData(PeakAttachmentTypes.INFINITE_TIMER, (Object)220);
        }
        return result;
    }

    private static int applySugarRush(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        int result = 0;
        for (ServerPlayer player : EntityArgument.getPlayers(context, (String)"target")) {
            player.setData(PeakAttachmentTypes.INFINITE_TIMER, (Object)IntegerArgumentType.getInteger(context, (String)"duration"));
        }
        return result;
    }

    private static int applyDefaultEnergyDrink(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        int result = 0;
        for (ServerPlayer player : EntityArgument.getPlayers(context, (String)"target")) {
            StaminaBar bar = (StaminaBar)player.getData(PeakAttachmentTypes.STAMINA_BAR);
            player.setData(PeakAttachmentTypes.STORED_DROWSY, (Object)Float.valueOf(bar.getStatus(AfflictionTypes.DROWSY)));
            bar.removeStatus(AfflictionTypes.DROWSY, 2.0f);
            player.setData(PeakAttachmentTypes.ENERGY_TIMER, (Object)220);
            player.getAttribute(Attributes.MOVEMENT_SPEED).addOrUpdateTransientModifier(Peak.SPEED_MODIFIER_ENERGY);
        }
        return result;
    }

    private static int applyEnergyDrink(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        int result = 0;
        for (ServerPlayer player : EntityArgument.getPlayers(context, (String)"target")) {
            StaminaBar bar = (StaminaBar)player.getData(PeakAttachmentTypes.STAMINA_BAR);
            player.setData(PeakAttachmentTypes.STORED_DROWSY, (Object)Float.valueOf(bar.getStatus(AfflictionTypes.DROWSY)));
            bar.removeStatus(AfflictionTypes.DROWSY, 2.0f);
            player.setData(PeakAttachmentTypes.ENERGY_TIMER, (Object)IntegerArgumentType.getInteger(context, (String)"duration"));
            player.getAttribute(Attributes.MOVEMENT_SPEED).addOrUpdateTransientModifier(Peak.SPEED_MODIFIER_ENERGY);
        }
        return result;
    }
}

