/*
 * Decompiled with CFR 0.152.
 */
package net.tintankgames.peak.stamina;

import com.google.common.collect.Streams;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.invoke.LambdaMetafactory;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameType;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import net.tintankgames.peak.attachments.PeakAttachmentTypes;
import net.tintankgames.peak.core.component.PeakDataComponents;
import net.tintankgames.peak.core.registries.PeakDataMaps;
import net.tintankgames.peak.core.registries.PeakRegistries;
import net.tintankgames.peak.stamina.AfflictionType;
import net.tintankgames.peak.stamina.AfflictionTypes;
import net.tintankgames.peak.world.entity.AbstractScoutEntity;
import net.tintankgames.peak.world.entity.PeakEntityTypes;
import net.tintankgames.peak.world.entity.UnconsciousScout;
import net.tintankgames.peak.world.item.PeakItems;

@EventBusSubscriber
public class StaminaBar {
    public static final MapCodec<StaminaBar> MAP_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.unboundedMap((Codec)ResourceKey.codec(PeakRegistries.AFFLICTION_TYPE), Affliction.CODEC).fieldOf("afflictions").forGetter(bar -> bar.afflictions), (App)Codec.FLOAT.fieldOf("stamina").forGetter(bar -> Float.valueOf(bar.stamina)), (App)Codec.INT.fieldOf("stamina_regen_cooldown").forGetter(bar -> bar.staminaRegenCooldown), (App)Codec.FLOAT.fieldOf("extra_stamina").forGetter(bar -> Float.valueOf(bar.extraStamina))).apply((Applicative)instance, StaminaBar::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, StaminaBar> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.map(HashMap::new, (StreamCodec)ResourceKey.streamCodec(PeakRegistries.AFFLICTION_TYPE), Affliction.STREAM_CODEC), bar -> bar.afflictions, (StreamCodec)ByteBufCodecs.FLOAT, bar -> Float.valueOf(bar.stamina), (StreamCodec)ByteBufCodecs.INT, bar -> bar.staminaRegenCooldown, (StreamCodec)ByteBufCodecs.FLOAT, bar -> Float.valueOf(bar.extraStamina), (StreamCodec)ByteBufCodecs.FLOAT, bar -> Float.valueOf(bar.maxExtraStamina), StaminaBar::new);
    private final HashMap<ResourceKey<AfflictionType>, Affliction> afflictions;
    private float stamina;
    private int staminaRegenCooldown;
    private float extraStamina;
    private float maxExtraStamina = 0.0f;

    public StaminaBar(Map<ResourceKey<AfflictionType>, Affliction> afflictions, float stamina, int staminaRegenCooldown, float extraStamina) {
        this.afflictions = new HashMap<ResourceKey<AfflictionType>, Affliction>(afflictions);
        this.stamina = stamina;
        this.staminaRegenCooldown = staminaRegenCooldown;
        this.extraStamina = extraStamina;
    }

    private StaminaBar(Map<ResourceKey<AfflictionType>, Affliction> afflictions, float stamina, int staminaRegenCooldown, float extraStamina, float maxExtraStamina) {
        this(afflictions, stamina, staminaRegenCooldown, extraStamina);
        this.maxExtraStamina = maxExtraStamina;
    }

    @SubscribeEvent
    public static void playerTick(PlayerTickEvent.Post event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            ((StaminaBar)serverPlayer.getData(PeakAttachmentTypes.STAMINA_BAR)).tick(serverPlayer);
            serverPlayer.syncData(PeakAttachmentTypes.STAMINA_BAR);
            serverPlayer.syncData(PeakAttachmentTypes.PASS_OUT_FADE);
            serverPlayer.syncData(PeakAttachmentTypes.PASS_OUT_FADE_O);
            serverPlayer.syncData(PeakAttachmentTypes.DEATH_TIMER);
            serverPlayer.syncData(PeakAttachmentTypes.DEATH_TIMER_O);
            serverPlayer.syncData(PeakAttachmentTypes.DEATH_TIMER_MAX);
            serverPlayer.syncData(PeakAttachmentTypes.INTERACT_TIMER);
            serverPlayer.syncData(PeakAttachmentTypes.INTERACT_TYPE);
            serverPlayer.syncData(PeakAttachmentTypes.INTERACT_ITEM);
            serverPlayer.syncData(PeakAttachmentTypes.INTERACT_TARGET);
            serverPlayer.syncData(PeakAttachmentTypes.INFINITE_TIMER);
            serverPlayer.syncData(PeakAttachmentTypes.ENERGY_TIMER);
            serverPlayer.syncData(PeakAttachmentTypes.EXPLOSION_TIMER);
            serverPlayer.syncData(PeakAttachmentTypes.ASSISTED);
            serverPlayer.syncData(PeakAttachmentTypes.MOVE_OFF_PITON_COOLDOWN);
            serverPlayer.syncData(PeakAttachmentTypes.PLACE_PITON_COOLDOWN);
            serverPlayer.syncData(PeakAttachmentTypes.GRABBED_PITON);
            serverPlayer.syncData(PeakAttachmentTypes.GRABBING_PITON);
        }
    }

    public void tick(ServerPlayer player) {
        player.setData(PeakAttachmentTypes.PASS_OUT_FADE_O, (Object)((Integer)player.getData(PeakAttachmentTypes.PASS_OUT_FADE)));
        player.setData(PeakAttachmentTypes.DEATH_TIMER_O, (Object)((Integer)player.getData(PeakAttachmentTypes.DEATH_TIMER)));
        player.getFoodData().setFoodLevel(this.hasStamina((Entity)player, false) ? 15 : 6);
        player.getFoodData().setSaturation(0.0f);
        player.setHealth(player.getMaxHealth());
        for (Map.Entry entry2 : this.afflictions.entrySet().stream().filter(entry -> ((Affliction)entry.getValue()).value <= 0.0f).toList()) {
            this.afflictions.remove(entry2.getKey());
        }
        for (Object key : player.registryAccess().lookupOrThrow(PeakRegistries.AFFLICTION_TYPE).registryKeySet()) {
            if (!this.afflictions.containsKey(key)) continue;
            AfflictionType type = (AfflictionType)player.registryAccess().getOrThrow((ResourceKey)key).value();
            if (type.recovery().isPresent() && (Integer)player.getData(PeakAttachmentTypes.DEATH_TIMER) != 0) {
                AfflictionType.Recovery recovery = type.recovery().get();
                if (this.afflictions.get((Object)key).cooldown > 0) {
                    --this.afflictions.get((Object)key).cooldown;
                } else {
                    this.removeStatus((ResourceKey<AfflictionType>)key, recovery.rate());
                }
            }
            if (!(this.afflictions.get((Object)key).value > type.cap())) continue;
            this.afflictions.get((Object)key).value = type.cap();
        }
        if (!player.isCreative()) {
            if ((Integer)player.getData(PeakAttachmentTypes.DEATH_TIMER) != 0) {
                this.addStatus((LivingEntity)player, AfflictionTypes.HUNGER, 2.5E-5f);
            }
            float weight = 0.0f;
            for (ItemStack stack : player.getInventory().getNonEquipmentItems()) {
                if (stack.has(PeakDataComponents.WEIGHT)) {
                    weight += ((Float)stack.getOrDefault(PeakDataComponents.WEIGHT, (Object)Float.valueOf(0.025f))).floatValue() * (float)stack.getCount();
                    continue;
                }
                Float value = (Float)BuiltInRegistries.ITEM.getData(PeakDataMaps.ITEM_WEIGHTS, stack.getItemHolder().getKey());
                if (value != null) {
                    weight += value.floatValue() * (float)stack.getCount();
                    continue;
                }
                weight += 0.025f * (float)stack.getCount();
            }
            for (EquipmentSlot slot : EquipmentSlot.values()) {
                if (slot == EquipmentSlot.MAINHAND) continue;
                ItemStack stack = player.getItemBySlot(slot);
                if (stack.has(PeakDataComponents.WEIGHT)) {
                    weight += ((Float)stack.getOrDefault(PeakDataComponents.WEIGHT, (Object)Float.valueOf(0.025f))).floatValue() * (float)stack.getCount();
                    continue;
                }
                Float value = (Float)BuiltInRegistries.ITEM.getData(PeakDataMaps.ITEM_WEIGHTS, stack.getItemHolder().getKey());
                if (value != null) {
                    weight += value.floatValue() * (float)stack.getCount();
                    continue;
                }
                weight += 0.025f * (float)stack.getCount();
            }
            this.setStatus((HolderLookup.Provider)player.registryAccess(), AfflictionTypes.WEIGHT, weight);
        } else {
            this.setStatus((HolderLookup.Provider)player.registryAccess(), AfflictionTypes.WEIGHT, 0.0f);
        }
        this.stamina = Mth.clamp((float)this.stamina, (float)0.0f, (float)Math.min(1.0f, 1.0f - this.getTotalAffliction()));
        if (this.staminaRegenCooldown > 0) {
            --this.staminaRegenCooldown;
        }
        if ((double)this.stamina <= 0.002 && this.extraStamina <= 0.0f && ((Boolean)player.getData(PeakAttachmentTypes.CLIMBING)).booleanValue()) {
            this.stamina = 0.0f;
        }
        if ((double)this.extraStamina <= 0.002 && ((Boolean)player.getData(PeakAttachmentTypes.CLIMBING)).booleanValue()) {
            this.extraStamina = 0.0f;
        }
        if (!((Boolean)player.getData(PeakAttachmentTypes.CLIMBING)).booleanValue()) {
            this.maxExtraStamina = this.extraStamina;
        }
        this.updateHotCold();
        if ((Integer)player.getData(PeakAttachmentTypes.PASS_OUT_TIMER) > 0) {
            player.setData(PeakAttachmentTypes.PASS_OUT_TIMER, (Object)((Integer)player.getData(PeakAttachmentTypes.PASS_OUT_TIMER) - 1));
            if ((Integer)player.getData(PeakAttachmentTypes.PASS_OUT_TIMER) <= 20) {
                player.setData(PeakAttachmentTypes.PASS_OUT_FADE, (Object)((Integer)player.getData(PeakAttachmentTypes.PASS_OUT_FADE) + 1));
            }
        }
        if (((Integer)player.getData(PeakAttachmentTypes.PASS_OUT_TIMER) <= 0 || (Integer)player.getData(PeakAttachmentTypes.PASS_OUT_TIMER) > 20) && (Integer)player.getData(PeakAttachmentTypes.PASS_OUT_FADE) > 0) {
            player.setData(PeakAttachmentTypes.PASS_OUT_FADE, (Object)((Integer)player.getData(PeakAttachmentTypes.PASS_OUT_FADE) - 1));
        }
        if ((Integer)player.getData(PeakAttachmentTypes.DEATH_TIMER) > 0) {
            player.setData(PeakAttachmentTypes.DEATH_TIMER, (Object)((Integer)player.getData(PeakAttachmentTypes.DEATH_TIMER) - 1));
        }
        if (!this.hasStamina()) {
            if ((Integer)player.getData(PeakAttachmentTypes.DEATH_TIMER) == -1 && (Integer)player.getData(PeakAttachmentTypes.PASS_OUT_TIMER) == -1) {
                player.setData(PeakAttachmentTypes.PASS_OUT_TIMER, (Object)100);
            } else if ((Integer)player.getData(PeakAttachmentTypes.DEATH_TIMER) == -1 && (Integer)player.getData(PeakAttachmentTypes.PASS_OUT_TIMER) == 0) {
                UnconsciousScout body = (UnconsciousScout)((EntityType)PeakEntityTypes.UNCONSCIOUS_SCOUT.get()).create(player.level(), null, player.blockPosition(), EntitySpawnReason.CONVERSION, false, false);
                if (body != null) {
                    body.teleportTo(player.level(), player.getX(), player.getY(), player.getZ(), Set.of(), player.getYRot(), player.getXRot(), true);
                    body.setOwner((LivingEntity)player);
                    body.setGameMode(player.gameMode());
                    body.setYRot(player.getYRot());
                    body.setYBodyRot(player.yBodyRot);
                    body.setYHeadRot(player.getYHeadRot());
                    body.setXRot(player.getXRot());
                    player.level().tryAddFreshEntityWithPassengers((Entity)body);
                }
                for (int i = 0; i < player.getInventory().getNonEquipmentItems().size(); ++i) {
                    ItemStack itemstack = (ItemStack)player.getInventory().getNonEquipmentItems().get(i);
                    if (itemstack.isEmpty()) continue;
                    player.drop(itemstack, true, false);
                    player.getInventory().getNonEquipmentItems().set(i, (Object)ItemStack.EMPTY);
                }
                if (!player.getOffhandItem().isEmpty()) {
                    player.drop(player.getOffhandItem(), true, false);
                    player.setItemInHand(InteractionHand.OFF_HAND, ItemStack.EMPTY);
                }
                player.setGameMode(GameType.SPECTATOR);
                boolean otherPlayersAlive = player.level().players().stream().filter(p -> p != player).anyMatch(p -> (Integer)p.getData(PeakAttachmentTypes.DEATH_TIMER) == -1);
                boolean onlyPlayer = player.level().players().stream().filter(p -> p != player).toList().isEmpty();
                player.setData(PeakAttachmentTypes.DEATH_TIMER, (Object)((!otherPlayersAlive || onlyPlayer) && !this.hasMeaningfulTempStatuses() ? 200 : 1200));
                player.setData(PeakAttachmentTypes.DEATH_TIMER_MAX, (Object)((!otherPlayersAlive || onlyPlayer) && !this.hasMeaningfulTempStatuses() ? 200 : 1200));
            }
        } else if ((Integer)player.getData(PeakAttachmentTypes.DEATH_TIMER) == -1 || (Integer)player.getData(PeakAttachmentTypes.DEATH_TIMER) > 0) {
            player.setData(PeakAttachmentTypes.PASS_OUT_TIMER, (Object)-1);
            player.setData(PeakAttachmentTypes.DEATH_TIMER, (Object)-1);
        }
        if ((Integer)player.getData(PeakAttachmentTypes.DEATH_TIMER) >= 0 && ((Boolean)player.getData(PeakAttachmentTypes.GIVING_UP)).booleanValue()) {
            player.setData(PeakAttachmentTypes.DEATH_TIMER, (Object)Mth.clamp((int)((Integer)player.getData(PeakAttachmentTypes.DEATH_TIMER) - (Integer)player.getData(PeakAttachmentTypes.DEATH_TIMER_MAX) / 60), (int)0, (int)1200));
        }
    }

    private void updateHotCold() {
        if (this.afflictions.containsKey(AfflictionTypes.HOT) && this.afflictions.containsKey(AfflictionTypes.COLD)) {
            float hotValue = this.afflictions.get(AfflictionTypes.HOT).value;
            float coldValue = this.afflictions.get(AfflictionTypes.COLD).value;
            if (hotValue > coldValue) {
                this.afflictions.remove(AfflictionTypes.COLD);
                this.afflictions.get(AfflictionTypes.HOT).value = hotValue - coldValue;
            } else if (hotValue < coldValue) {
                this.afflictions.remove(AfflictionTypes.HOT);
                this.afflictions.get(AfflictionTypes.COLD).value = coldValue - hotValue;
            } else {
                this.afflictions.remove(AfflictionTypes.HOT);
                this.afflictions.remove(AfflictionTypes.COLD);
            }
        }
    }

    public void setStatus(HolderLookup.Provider provider, ResourceKey<AfflictionType> afflictionType, float value) {
        this.afflictions.compute(afflictionType, (key, old) -> value <= 0.0f ? null : new Affliction(((AfflictionType)provider.getOrThrow(key).value()).recovery().orElse(new AfflictionType.Recovery(0, 0.0f)).cooldown(), Math.min(value, ((AfflictionType)provider.getOrThrow(key).value()).cap())));
        this.updateHotCold();
    }

    public void addStatus(LivingEntity living, ResourceKey<AfflictionType> afflictionType, float value) {
        if (!living.getMainHandItem().is(PeakItems.ANCIENT_IDOL) || value < 0.0f) {
            this.afflictions.compute(afflictionType, (key, old) -> old != null && old.value + value <= 0.0f ? null : new Affliction(((AfflictionType)living.registryAccess().getOrThrow(key).value()).recovery().orElse(new AfflictionType.Recovery(0, 0.0f)).cooldown(), Math.min(old != null ? old.value + value : value, ((AfflictionType)living.registryAccess().getOrThrow(key).value()).cap())));
        }
        this.updateHotCold();
    }

    public void removeStatus(ResourceKey<AfflictionType> afflictionType, float value) {
        this.afflictions.compute(afflictionType, (key, old) -> old == null ? null : new Affliction(old.cooldown, old.value - value));
        this.updateHotCold();
    }

    public void clearStatus(LivingEntity living, boolean clearCurse) {
        float curseValue = this.afflictions.containsKey(AfflictionTypes.CURSE) ? this.afflictions.get(AfflictionTypes.CURSE).value : 0.0f;
        this.afflictions.clear();
        if (!clearCurse) {
            this.addStatus(living, AfflictionTypes.CURSE, curseValue);
        }
    }

    public float getTotalAffliction() {
        try {
            return this.afflictions.values().stream().collect((Supplier<FloatValue>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, <init>(), ()Lnet/tintankgames/peak/stamina/StaminaBar$FloatValue;)(), (BiConsumer<FloatValue, Affliction>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)V, lambda$getTotalAffliction$17(net.tintankgames.peak.stamina.StaminaBar$FloatValue net.tintankgames.peak.stamina.StaminaBar$Affliction ), (Lnet/tintankgames/peak/stamina/StaminaBar$FloatValue;Lnet/tintankgames/peak/stamina/StaminaBar$Affliction;)V)(), (BiConsumer<FloatValue, FloatValue>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)V, lambda$getTotalAffliction$18(net.tintankgames.peak.stamina.StaminaBar$FloatValue net.tintankgames.peak.stamina.StaminaBar$FloatValue ), (Lnet/tintankgames/peak/stamina/StaminaBar$FloatValue;Lnet/tintankgames/peak/stamina/StaminaBar$FloatValue;)V)()).value;
        }
        catch (Exception e) {
            return 0.0f;
        }
    }

    private boolean hasMeaningfulTempStatuses() {
        float num = this.getStatus(AfflictionTypes.DROWSY) + this.getStatus(AfflictionTypes.HOT) + this.getStatus(AfflictionTypes.POISON) + this.getStatus(AfflictionTypes.COLD);
        return this.getTotalAffliction() - num < 1.0f;
    }

    public boolean hasStamina() {
        return this.getTotalAffliction() < 1.0f;
    }

    public float getStamina() {
        return this.getStamina(false);
    }

    public float getStamina(boolean extra) {
        return Mth.clamp((float)this.stamina, (float)0.0f, (float)1.0f) + (extra ? Mth.clamp((float)this.extraStamina, (float)0.0f, (float)1.0f) : 0.0f);
    }

    public void setStamina(float stamina) {
        this.stamina = Mth.clamp((float)stamina, (float)0.0f, (float)(1.0f - this.getTotalAffliction()));
    }

    public void setExtraStamina(float extraStamina) {
        this.extraStamina = Mth.clamp((float)extraStamina, (float)0.0f, (float)1.0f);
    }

    public void addStamina(float stamina) {
        this.stamina = Mth.clamp((float)(this.stamina + stamina), (float)0.0f, (float)(1.0f - this.getTotalAffliction()));
    }

    public void addExtraStamina(float extraStamina) {
        this.extraStamina = Mth.clamp((float)(this.extraStamina + extraStamina), (float)0.0f, (float)1.0f);
    }

    public void removeExtraStamina(float extraStamina) {
        this.extraStamina = Mth.clamp((float)(this.extraStamina - extraStamina), (float)0.0f, (float)1.0f);
    }

    public float getStatus(ResourceKey<AfflictionType> type) {
        return this.afflictions.getOrDefault(type, new Affliction(0, 0.0f)).getValue();
    }

    public boolean hasStatus(ResourceKey<AfflictionType> type) {
        return this.afflictions.containsKey(type) && this.afflictions.get(type).getValue() > 0.0f;
    }

    public int getStaminaRegenCooldown() {
        return this.staminaRegenCooldown;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean hasStamina(Entity player, boolean extra) {
        if (!(!extra ? this.stamina > 0.0f : this.stamina + this.extraStamina > 0.0f) && !(((Vec3)player.getData(PeakAttachmentTypes.MOVEMENT_LUNGE)).length() > 0.05)) {
            if (!(((Vec3)player.getData((AttachmentType)PeakAttachmentTypes.MOVEMENT_ASSIST.get())).length() > 0.05)) return false;
        }
        if ((Integer)player.getData(PeakAttachmentTypes.EXPLOSION_TIMER) > 0) return false;
        return true;
    }

    public void useStamina(Entity entity, float stamina, boolean extra) {
        if ((Integer)entity.getData(PeakAttachmentTypes.INFINITE_TIMER) <= 0) {
            if (this.stamina >= stamina) {
                this.stamina -= stamina;
            } else if (this.stamina <= 0.0f && this.extraStamina >= stamina && extra) {
                this.extraStamina -= (stamina -= this.stamina);
            } else if (this.stamina < stamina && this.extraStamina < stamina - this.stamina && extra) {
                this.stamina = 0.0f;
                this.extraStamina = 0.0f;
            } else if (this.stamina < stamina) {
                this.stamina = 0.0f;
            } else if (this.extraStamina < stamina && extra) {
                this.extraStamina = 0.0f;
            }
            this.staminaRegenCooldown = this.stamina <= 0.0f ? 40 : 20;
        }
    }

    public boolean hasExtraStamina() {
        return this.extraStamina > 0.0f;
    }

    public float getExtraStamina() {
        return this.extraStamina;
    }

    public float getMaxExtraStamina() {
        return this.maxExtraStamina;
    }

    public void revive(ServerPlayer player) {
        if ((Integer)player.getData(PeakAttachmentTypes.DEATH_TIMER) >= 0) {
            player.setData(PeakAttachmentTypes.PASS_OUT_TIMER, (Object)-1);
            player.setData(PeakAttachmentTypes.DEATH_TIMER, (Object)-1);
            this.clearStatus((LivingEntity)player, false);
            GameType gameType = player.gameMode.getPreviousGameModeForPlayer() != null ? player.gameMode.getPreviousGameModeForPlayer() : player.gameMode();
            for (AbstractScoutEntity entity2 : Streams.stream((Iterable)player.level().getAllEntities()).filter(entity -> {
                AbstractScoutEntity scout;
                return entity instanceof AbstractScoutEntity && (scout = (AbstractScoutEntity)((Object)entity)).getOwner() == player;
            }).map(entity -> (AbstractScoutEntity)((Object)entity)).toList()) {
                gameType = entity2.getGameMode();
                entity2.discard();
            }
            player.setGameMode(gameType);
            player.setData(PeakAttachmentTypes.ASSISTED, (Object)true);
            this.addStatus((LivingEntity)player, AfflictionTypes.CURSE, 0.05f);
            this.addStatus((LivingEntity)player, AfflictionTypes.HUNGER, 0.3f);
        }
    }

    private static /* synthetic */ void lambda$getTotalAffliction$18(FloatValue value1, FloatValue value2) {
        value1.value += value2.value;
    }

    private static /* synthetic */ void lambda$getTotalAffliction$17(FloatValue value, Affliction affliction) {
        value.value += affliction.getValue();
    }

    public static class Affliction {
        public static final Codec<Affliction> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.optionalFieldOf("cooldown", (Object)0).forGetter(Affliction::cooldown), (App)Codec.FLOAT.fieldOf("value").forGetter(Affliction::value)).apply((Applicative)instance, Affliction::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, Affliction> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT, Affliction::cooldown, (StreamCodec)ByteBufCodecs.FLOAT, Affliction::value, Affliction::new);
        private int cooldown;
        private float value;

        public Affliction(int cooldown, float value) {
            this.cooldown = cooldown;
            this.value = value;
        }

        public float getValue() {
            return (float)Mth.floor((float)(this.value * 40.0f)) / 40.0f;
        }

        private int cooldown() {
            return this.cooldown;
        }

        private float value() {
            return this.value;
        }
    }

    static class FloatValue {
        public float value;

        FloatValue() {
        }
    }
}

