/*
 * Decompiled with CFR 0.152.
 */
package net.tintankgames.peak.world.entity;

import com.mojang.serialization.Codec;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.tintankgames.peak.network.syncher.PeakEntityDataSerializers;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractScoutEntity
extends TamableAnimal {
    private static final EntityDataAccessor<GameType> GAME_MODE = SynchedEntityData.defineId(AbstractScoutEntity.class, (EntityDataSerializer)((EntityDataSerializer)PeakEntityDataSerializers.GAME_MODE.get()));

    protected AbstractScoutEntity(EntityType<? extends AbstractScoutEntity> type, Level level) {
        super(type, level);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(GAME_MODE, (Object)GameType.DEFAULT_MODE);
    }

    public GameType getGameMode() {
        return (GameType)this.entityData.get(GAME_MODE);
    }

    public void setGameMode(GameType gameMode) {
        this.entityData.set(GAME_MODE, (Object)gameMode);
    }

    protected void addAdditionalSaveData(ValueOutput output) {
        super.addAdditionalSaveData(output);
        output.store("game_mode", (Codec)GameType.CODEC, (Object)this.getGameMode());
    }

    protected void readAdditionalSaveData(ValueInput input) {
        super.readAdditionalSaveData(input);
        this.setGameMode(input.read("game_mode", (Codec)GameType.CODEC).orElse(GameType.DEFAULT_MODE));
    }

    public boolean isFood(ItemStack stack) {
        return false;
    }

    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel level, AgeableMob partner) {
        return null;
    }
}

