/*
 * Decompiled with CFR 0.152.
 */
package net.tintankgames.peak.world.entity;

import java.util.function.UnaryOperator;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.EntityAttributeCreationEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.tintankgames.peak.world.entity.FallenScout;
import net.tintankgames.peak.world.entity.UnconsciousScout;

@EventBusSubscriber(modid="peak")
public class PeakEntityTypes {
    public static final DeferredRegister.Entities REGISTER = DeferredRegister.createEntities((String)"peak");
    public static final DeferredHolder<EntityType<?>, EntityType<UnconsciousScout>> UNCONSCIOUS_SCOUT = PeakEntityTypes.register("unconscious_scout", UnconsciousScout::new, MobCategory.MISC, builder -> builder.sized(0.6f, 0.9f).clientTrackingRange(10).noLootTable().noSummon());
    public static final DeferredHolder<EntityType<?>, EntityType<FallenScout>> FALLEN_SCOUT = PeakEntityTypes.register("fallen_scout", FallenScout::new, MobCategory.MISC, builder -> builder.sized(0.6f, 0.9f).clientTrackingRange(10).noLootTable().noSummon());

    private static <T extends Entity> DeferredHolder<EntityType<?>, EntityType<T>> register(String id, EntityType.EntityFactory<T> factory, MobCategory category, UnaryOperator<EntityType.Builder<T>> builder) {
        return REGISTER.registerEntityType(id, factory, category, builder);
    }

    @SubscribeEvent
    public static void attributes(EntityAttributeCreationEvent event) {
        event.put((EntityType)UNCONSCIOUS_SCOUT.get(), UnconsciousScout.createAttributes().build());
        event.put((EntityType)FALLEN_SCOUT.get(), FallenScout.createAttributes().build());
    }

    public static void register(IEventBus bus) {
        REGISTER.register(bus);
    }
}

