/*
 * Decompiled with CFR 0.152.
 */
package net.tintankgames.peak.world.entity;

import java.util.Set;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.ConversionParams;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUseAnimation;
import net.minecraft.world.item.component.Consumable;
import net.minecraft.world.item.component.ConsumableListener;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.tintankgames.peak.attachments.PeakAttachmentTypes;
import net.tintankgames.peak.core.component.PeakDataComponents;
import net.tintankgames.peak.core.registries.PeakDataMaps;
import net.tintankgames.peak.stamina.AfflictionType;
import net.tintankgames.peak.stamina.StaminaBar;
import net.tintankgames.peak.world.entity.AbstractScoutEntity;
import net.tintankgames.peak.world.entity.FallenScout;
import net.tintankgames.peak.world.entity.PeakEntityTypes;
import net.tintankgames.peak.world.item.component.PeakConsumable;
import net.tintankgames.peak.world.item.component.Poisonous;

public class UnconsciousScout
extends AbstractScoutEntity {
    protected UnconsciousScout(EntityType<? extends UnconsciousScout> type, Level level) {
        super(type, level);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return UnconsciousScout.createAnimalAttributes().add(Attributes.MAX_HEALTH, 1.0);
    }

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        LivingEntity livingEntity;
        ItemStack stack = player.getItemInHand(hand);
        Consumable consumable = (Consumable)stack.get(DataComponents.CONSUMABLE);
        if (consumable != null && (livingEntity = this.getOwner()) instanceof Player) {
            PeakConsumable peakConsumable;
            Player owner = (Player)livingEntity;
            this.emitParticlesAndSounds(this.getRandom(), (LivingEntity)this, stack, 16, consumable);
            if (owner instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)owner;
                serverPlayer.awardStat(Stats.ITEM_USED.get((Object)stack.getItem()));
                CriteriaTriggers.CONSUME_ITEM.trigger(serverPlayer, stack);
            }
            if ((peakConsumable = (PeakConsumable)stack.get(PeakDataComponents.CONSUMABLE)) == null) {
                peakConsumable = (PeakConsumable)BuiltInRegistries.ITEM.getData(PeakDataMaps.CONSUMABLES, stack.getItemHolder().getKey());
            }
            if (peakConsumable != null) {
                if (!this.level().isClientSide) {
                    Poisonous poisonous;
                    StaminaBar bar = (StaminaBar)owner.getData(PeakAttachmentTypes.STAMINA_BAR);
                    peakConsumable.effects().forEach((key, value) -> bar.addStatus((LivingEntity)owner, (ResourceKey<AfflictionType>)key, value.floatValue()));
                    bar.addExtraStamina(peakConsumable.extraStamina());
                    if (((Float)stack.getOrDefault(PeakDataComponents.INFINITE_STAMINA, (Object)Float.valueOf(0.0f))).floatValue() > 0.0f) {
                        owner.setData(PeakAttachmentTypes.INFINITE_TIMER, (Object)((int)(((Float)stack.getOrDefault(PeakDataComponents.INFINITE_STAMINA, (Object)Float.valueOf(0.0f))).floatValue() * 20.0f)));
                    }
                    if ((poisonous = (Poisonous)stack.get(PeakDataComponents.POISONOUS)) == null) {
                        poisonous = (Poisonous)BuiltInRegistries.ITEM.getData(PeakDataMaps.POISONOUS, stack.getItemHolder().getKey());
                    }
                    if (poisonous != null) {
                        if ((Integer)owner.getData(PeakAttachmentTypes.POISON_TIMER) > 0 && (Integer)owner.getData(PeakAttachmentTypes.POISON_COOLDOWN) <= 0) {
                            owner.setData(PeakAttachmentTypes.POISON_TIMER, (Object)((int)(poisonous.time() * 20.0f) + (int)(poisonous.cooldown() * 20.0f) + (Integer)owner.getData(PeakAttachmentTypes.POISON_TIMER)));
                        } else {
                            owner.setData(PeakAttachmentTypes.POISON_COOLDOWN, (Object)((int)(poisonous.cooldown() * 20.0f)));
                            owner.setData(PeakAttachmentTypes.POISON_TIMER, (Object)((int)(poisonous.time() * 20.0f)));
                        }
                    }
                }
            } else {
                stack.getAllOfType(ConsumableListener.class).forEach(listener -> listener.onConsume(owner.level(), (LivingEntity)owner, stack, consumable));
                consumable.onConsumeEffects().forEach(effect -> effect.apply(owner.level(), stack, (LivingEntity)owner));
            }
            owner.gameEvent((Holder)(consumable.animation() == ItemUseAnimation.DRINK ? GameEvent.DRINK : GameEvent.EAT));
            if (stack.getMaxDamage() <= 0) {
                stack.consume(1, (LivingEntity)player);
            } else {
                stack.hurtAndBreak(1, (LivingEntity)player, hand);
            }
            return InteractionResult.SUCCESS_SERVER;
        }
        return InteractionResult.PASS;
    }

    protected void customServerAiStep(ServerLevel level) {
        super.customServerAiStep(level);
        LivingEntity livingEntity = this.getOwner();
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)livingEntity;
            this.setHealth(this.getMaxHealth());
            StaminaBar bar = (StaminaBar)player.getData(PeakAttachmentTypes.STAMINA_BAR);
            if ((Integer)player.getData(PeakAttachmentTypes.DEATH_TIMER) == 0) {
                FallenScout scout = (FallenScout)this.convertTo((EntityType)PeakEntityTypes.FALLEN_SCOUT.get(), ConversionParams.single((Mob)this, (boolean)true, (boolean)true), fallenScout -> {
                    fallenScout.setOwnerReference(this.getOwnerReference());
                    fallenScout.setGameMode(this.getGameMode());
                    fallenScout.setInvulnerable(true);
                });
                if (scout != null) {
                    scout.setYRot(this.getYRot());
                    scout.setYBodyRot(this.yBodyRot);
                    scout.setYHeadRot(this.getYHeadRot());
                    scout.setXRot(this.getXRot());
                }
            } else if (bar.hasStamina()) {
                player.teleportTo(level, this.getX(), this.getY(), this.getZ(), Set.of(), this.getYRot(), this.getXRot(), true);
                player.setGameMode(this.getGameMode());
                player.setData(PeakAttachmentTypes.DEATH_TIMER, (Object)-1);
                player.setData(PeakAttachmentTypes.PASS_OUT_TIMER, (Object)-1);
                player.setData(PeakAttachmentTypes.PASS_OUT_FADE, (Object)20);
                this.discard();
            }
        }
    }

    public void emitParticlesAndSounds(RandomSource randomSource, LivingEntity living, ItemStack stack, int count, Consumable consumable) {
        SoundEvent soundevent;
        float f5;
        float f = randomSource.nextBoolean() ? 0.5f : 1.0f;
        float f1 = randomSource.triangle(1.0f, 0.2f);
        float f3 = Mth.randomBetween((RandomSource)randomSource, (float)0.9f, (float)1.0f);
        float f4 = consumable.animation() == ItemUseAnimation.DRINK ? 0.5f : f;
        float f2 = f5 = consumable.animation() == ItemUseAnimation.DRINK ? f3 : f1;
        if (consumable.hasConsumeParticles()) {
            living.spawnItemParticles(stack, count);
        }
        if (living instanceof Consumable.OverrideConsumeSound) {
            Consumable.OverrideConsumeSound overrideConsumeSound = (Consumable.OverrideConsumeSound)living;
            soundevent = overrideConsumeSound.getConsumeSound(stack);
        } else {
            soundevent = (SoundEvent)consumable.sound().value();
        }
        living.level().playSound(null, living.getX(), living.getY(), living.getZ(), soundevent, SoundSource.PLAYERS, f4, f5);
    }
}

