/*
 * Decompiled with CFR 0.152.
 */
package net.tintankgames.peak.world.item;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUseAnimation;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.tintankgames.peak.attachments.PeakAttachmentTypes;
import net.tintankgames.peak.stamina.AfflictionTypes;
import net.tintankgames.peak.stamina.StaminaBar;
import net.tintankgames.peak.world.entity.UnconsciousScout;

public class BlowgunItem
extends Item {
    public BlowgunItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult use(Level level, Player player, InteractionHand hand) {
        player.startUsingItem(hand);
        return InteractionResult.CONSUME;
    }

    public ItemStack finishUsingItem(ItemStack stack, Level level, LivingEntity living) {
        EntityHitResult hit;
        HitResult hitResult = BlowgunItem.getHitResult((Entity)living, entity -> entity instanceof Player || entity instanceof UnconsciousScout, 128.0, 0.0f);
        if (hitResult instanceof EntityHitResult && ((hit = (EntityHitResult)hitResult).getEntity() instanceof ServerPlayer || hit.getEntity() instanceof UnconsciousScout)) {
            Entity entity2 = hit.getEntity();
            if (entity2 instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)entity2;
                bar = (StaminaBar)player.getData(PeakAttachmentTypes.STAMINA_BAR);
                ((StaminaBar)bar).clearStatus((LivingEntity)player, false);
                ((StaminaBar)bar).addStatus((LivingEntity)player, AfflictionTypes.DROWSY, 1.2f);
            } else {
                UnconsciousScout scout;
                bar = hit.getEntity();
                if (bar instanceof UnconsciousScout && (bar = (scout = (UnconsciousScout)((Object)bar)).getOwner()) instanceof Player) {
                    Player owner = (Player)bar;
                    if (!level.isClientSide) {
                        bar = (StaminaBar)owner.getData(PeakAttachmentTypes.STAMINA_BAR);
                        ((StaminaBar)bar).clearStatus((LivingEntity)owner, false);
                        ((StaminaBar)bar).addStatus((LivingEntity)owner, AfflictionTypes.DROWSY, 1.2f);
                    }
                }
            }
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                for (double d = 0.0; d < Math.abs(living.getEyePosition().distanceTo(hit.getLocation())); d += 0.1) {
                    Vec3 vec3 = living.getEyePosition().add(living.getViewVector(0.0f).scale(d));
                    serverLevel.sendParticles((ParticleOptions)new DustParticleOptions(15227814, 0.5f), vec3.x(), vec3.y(), vec3.z(), 1, 0.0, 0.0, 0.0, 0.0);
                }
            }
            return ItemStack.EMPTY;
        }
        if (living instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)living;
            player.sendSystemMessage((Component)Component.literal((String)"No target").withStyle(ChatFormatting.RED), true);
        }
        return super.finishUsingItem(stack, level, living);
    }

    private static HitResult getHitResult(Entity entity, Predicate<Entity> predicate, double d, float rotation) {
        EntityHitResult hitResult2;
        Vec3 vec33 = entity.getEyePosition().add(entity.getViewVector(0.0f).yRot(rotation).scale(d));
        BlockHitResult hitResult = entity.level().clip(new ClipContext(entity.getEyePosition(), vec33, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, entity));
        if (hitResult.getType() != HitResult.Type.MISS) {
            vec33 = hitResult.getLocation();
        }
        if ((hitResult2 = ProjectileUtil.getEntityHitResult((Level)entity.level(), (Entity)entity, (Vec3)entity.getEyePosition(), (Vec3)vec33, (AABB)entity.getBoundingBox().expandTowards(entity.getViewVector(0.0f).scale(d)).inflate(1.0), predicate, (float)1.0f)) != null) {
            hitResult = hitResult2;
        }
        return hitResult;
    }

    private static List<LivingEntity> getEntitiesInSight(Entity entity, double d, float rotation) {
        Vec3 vec33 = entity.getEyePosition().add(entity.getViewVector(0.0f).yRot(rotation).scale(d));
        BlockHitResult hitResult = entity.level().clip(new ClipContext(entity.getEyePosition(), vec33, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, entity));
        if (hitResult.getType() != HitResult.Type.MISS) {
            vec33 = hitResult.getLocation();
        }
        return BlowgunItem.getEntities(entity.level(), entity, entity.getEyePosition(), vec33, entity.getBoundingBox().expandTowards(entity.getViewVector(0.0f).scale(d)).inflate(1.0), entity1 -> entity1 instanceof LivingEntity).stream().map(entity1 -> (LivingEntity)entity1).toList();
    }

    public static List<Entity> getEntities(Level p_150176_, Entity p_150177_, Vec3 p_150178_, Vec3 p_150179_, AABB p_150180_, Predicate<Entity> p_150181_) {
        double d0 = Double.MAX_VALUE;
        ArrayList<Entity> entities = new ArrayList<Entity>();
        for (Entity entity : p_150176_.getEntities(p_150177_, p_150180_, p_150181_)) {
            double d1;
            AABB aabb = entity.getBoundingBox().inflate(0.3);
            Optional optional = aabb.clip(p_150178_, p_150179_);
            if (!optional.isPresent() || !((d1 = p_150178_.distanceToSqr((Vec3)optional.get())) < d0)) continue;
            entities.add(entity);
            d0 = d1;
        }
        return entities;
    }

    public ItemUseAnimation getUseAnimation(ItemStack stack) {
        return ItemUseAnimation.BOW;
    }

    public int getUseDuration(ItemStack stack, LivingEntity living) {
        return 20;
    }
}

