/*
 * Decompiled with CFR 0.152.
 */
package net.tintankgames.peak.world.item;

import java.util.Map;
import java.util.function.Function;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemUseAnimation;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.component.Consumable;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredItem;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.tintankgames.peak.core.component.PeakDataComponents;
import net.tintankgames.peak.stamina.AfflictionTypes;
import net.tintankgames.peak.world.item.BlowgunItem;
import net.tintankgames.peak.world.item.ScoutEffigyItem;
import net.tintankgames.peak.world.item.component.PeakConsumable;

public class PeakItems {
    public static final DeferredRegister.Items REGISTER = DeferredRegister.createItems((String)"peak");
    public static final DeferredItem<Item> MARSHMALLOW = PeakItems.register("marshmallow", props -> new Item(props.component(DataComponents.CONSUMABLE, (Object)Consumable.builder().build()).component(PeakDataComponents.CONSUMABLE, (Object)new PeakConsumable(Map.of(AfflictionTypes.HUNGER, Float.valueOf(-0.2f)), 0.0f)).rarity(Rarity.UNCOMMON)));
    public static final DeferredItem<Item> COOKED_MARSHMALLOW = PeakItems.register("cooked_marshmallow", props -> new Item(props.component(DataComponents.CONSUMABLE, (Object)Consumable.builder().build()).component(PeakDataComponents.CONSUMABLE, (Object)new PeakConsumable(Map.of(AfflictionTypes.HUNGER, Float.valueOf(-0.4f)), 0.1f)).rarity(Rarity.UNCOMMON)));
    public static final DeferredItem<Item> BANDAGES = PeakItems.register("bandages", props -> new Item(props.component(DataComponents.CONSUMABLE, (Object)Consumable.builder().animation(ItemUseAnimation.BLOCK).sound(BuiltInRegistries.SOUND_EVENT.wrapAsHolder((Object)SoundEvents.EMPTY)).hasConsumeParticles(false).build()).component(PeakDataComponents.CONSUMABLE, (Object)new PeakConsumable(Map.of(AfflictionTypes.INJURY, Float.valueOf(-0.3f)), 0.0f))));
    public static final DeferredItem<Item> COOKED_BANDAGES = PeakItems.register("cooked_bandages", props -> new Item(props.component(DataComponents.CONSUMABLE, (Object)Consumable.builder().animation(ItemUseAnimation.BLOCK).sound(BuiltInRegistries.SOUND_EVENT.wrapAsHolder((Object)SoundEvents.EMPTY)).hasConsumeParticles(false).build()).component(PeakDataComponents.CONSUMABLE, (Object)new PeakConsumable(Map.of(AfflictionTypes.INJURY, Float.valueOf(-0.3f)), 0.1f))));
    public static final DeferredItem<Item> FIRST_AID_KIT = PeakItems.register("first_aid_kit", props -> new Item(props.component(DataComponents.CONSUMABLE, (Object)Consumable.builder().animation(ItemUseAnimation.BLOCK).sound(BuiltInRegistries.SOUND_EVENT.wrapAsHolder((Object)SoundEvents.EMPTY)).hasConsumeParticles(false).build()).component(PeakDataComponents.CONSUMABLE, (Object)new PeakConsumable(Map.of(AfflictionTypes.INJURY, Float.valueOf(-1.0f), AfflictionTypes.POISON, Float.valueOf(-1.0f)), 0.0f))));
    public static final DeferredItem<Item> COOKED_FIRST_AID_KIT = PeakItems.register("cooked_first_aid_kit", props -> new Item(props.component(DataComponents.CONSUMABLE, (Object)Consumable.builder().animation(ItemUseAnimation.BLOCK).sound(BuiltInRegistries.SOUND_EVENT.wrapAsHolder((Object)SoundEvents.EMPTY)).hasConsumeParticles(false).build()).component(PeakDataComponents.CONSUMABLE, (Object)new PeakConsumable(Map.of(AfflictionTypes.INJURY, Float.valueOf(-1.0f), AfflictionTypes.POISON, Float.valueOf(-1.0f)), 0.1f))));
    public static final DeferredItem<Item> ANTIDOTE = PeakItems.register("antidote", props -> new Item(props.durability(3).component(DataComponents.CONSUMABLE, (Object)Consumable.builder().animation(ItemUseAnimation.DRINK).sound((Holder)SoundEvents.GENERIC_DRINK).hasConsumeParticles(false).build()).component(PeakDataComponents.CONSUMABLE, (Object)new PeakConsumable(Map.of(AfflictionTypes.POISON, Float.valueOf(-0.35f), AfflictionTypes.HOT, Float.valueOf(-0.1f)), 0.0f)).rarity(Rarity.UNCOMMON)));
    public static final DeferredItem<Item> COOKED_ANTIDOTE = PeakItems.register("cooked_antidote", props -> new Item(props.durability(3).component(DataComponents.CONSUMABLE, (Object)Consumable.builder().animation(ItemUseAnimation.DRINK).sound((Holder)SoundEvents.GENERIC_DRINK).hasConsumeParticles(false).build()).component(PeakDataComponents.CONSUMABLE, (Object)new PeakConsumable(Map.of(AfflictionTypes.POISON, Float.valueOf(-0.35f), AfflictionTypes.HOT, Float.valueOf(-0.1f)), 0.0f)).rarity(Rarity.UNCOMMON)));
    public static final DeferredItem<Item> BIG_LOLLIPOP = PeakItems.register("big_lollipop", props -> new Item(props.component(DataComponents.CONSUMABLE, (Object)Consumable.builder().build()).component(PeakDataComponents.CONSUMABLE, (Object)new PeakConsumable(Map.of(AfflictionTypes.HUNGER, Float.valueOf(-0.05f)), 0.0f)).component(PeakDataComponents.INFINITE_STAMINA, (Object)Float.valueOf(11.0f)).rarity(Rarity.UNCOMMON)));
    public static final DeferredItem<Item> COOKED_BIG_LOLLIPOP = PeakItems.register("cooked_big_lollipop", props -> new Item(props.component(DataComponents.CONSUMABLE, (Object)Consumable.builder().build()).component(PeakDataComponents.CONSUMABLE, (Object)new PeakConsumable(Map.of(AfflictionTypes.HUNGER, Float.valueOf(-0.1f)), 0.1f)).component(PeakDataComponents.INFINITE_STAMINA, (Object)Float.valueOf(11.0f)).rarity(Rarity.UNCOMMON)));
    public static final DeferredItem<Item> BLOWGUN = PeakItems.register("blowgun", props -> new BlowgunItem(props.stacksTo(1).rarity(Rarity.UNCOMMON)));
    public static final DeferredItem<Item> SCOUT_EFFIGY = PeakItems.register("scout_effigy", props -> new ScoutEffigyItem(props.stacksTo(1).rarity(Rarity.RARE)));
    public static final DeferredItem<Item> BING_BONG = PeakItems.register("bing_bong", props -> new Item(props.stacksTo(1).rarity(Rarity.UNCOMMON)));
    public static final DeferredItem<Item> ANCIENT_IDOL = PeakItems.register("ancient_idol", props -> new Item(props.stacksTo(1).rarity(Rarity.EPIC)));

    private static <T extends Item> DeferredItem<T> register(String id, Function<Item.Properties, T> function) {
        return REGISTER.registerItem(id, function);
    }

    public static void register(IEventBus bus) {
        REGISTER.register(bus);
    }
}

