/*
 * Decompiled with CFR 0.152.
 */
package net.tintankgames.peak.world.item;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.tintankgames.peak.attachments.PeakAttachmentTypes;
import net.tintankgames.peak.stamina.StaminaBar;

public class ScoutEffigyItem
extends Item {
    public ScoutEffigyItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult useOn(UseOnContext context) {
        if (context.getLevel().players().stream().anyMatch(player -> (Integer)player.getData(PeakAttachmentTypes.DEATH_TIMER) >= 0)) {
            Level level = context.getLevel();
            if (level instanceof ServerLevel) {
                ServerLevel level2 = (ServerLevel)level;
                List<ServerPlayer> deadPlayers = level2.players().stream().filter(player -> (Integer)player.getData(PeakAttachmentTypes.DEATH_TIMER) >= 0).toList();
                ServerPlayer toRevive = deadPlayers.get(level2.getRandom().nextInt(deadPlayers.size()));
                ((StaminaBar)toRevive.getData(PeakAttachmentTypes.STAMINA_BAR)).revive(toRevive);
                toRevive.teleportTo(context.getClickLocation().x, context.getClickLocation().y, context.getClickLocation().z);
                context.getItemInHand().consume(1, (LivingEntity)context.getPlayer());
                level2.playSound(null, context.getClickLocation().x, context.getClickLocation().y, context.getClickLocation().z, SoundEvents.TOTEM_USE, SoundSource.PLAYERS);
            }
            return InteractionResult.SUCCESS_SERVER;
        }
        Player player2 = context.getPlayer();
        if (player2 instanceof ServerPlayer) {
            ServerPlayer player3 = (ServerPlayer)player2;
            player3.sendSystemMessage((Component)Component.literal((String)"No Scouts are dead").withStyle(ChatFormatting.RED), true);
        }
        return super.useOn(context);
    }
}

