/*
 * Decompiled with CFR 0.152.
 */
package net.tintankgames.peak.world.level.block;

import com.mojang.serialization.MapCodec;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetTitleTextPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.tintankgames.peak.Config;
import net.tintankgames.peak.attachments.PeakAttachmentTypes;
import net.tintankgames.peak.core.particles.PeakParticleTypes;
import net.tintankgames.peak.stamina.AfflictionTypes;
import net.tintankgames.peak.stamina.StaminaBar;
import net.tintankgames.peak.world.level.block.PeakBlocks;

public class AncientStatueBlock
extends HorizontalDirectionalBlock
implements SimpleWaterloggedBlock {
    public static final MapCodec<AncientStatueBlock> CODEC = AncientStatueBlock.simpleCodec(AncientStatueBlock::new);
    public static final EnumProperty<DoubleBlockHalf> HALF = BlockStateProperties.DOUBLE_BLOCK_HALF;
    public static final BooleanProperty BROKEN = BooleanProperty.create((String)"broken");
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    private static final VoxelShape X_SHAPE = Shapes.or((VoxelShape)Shapes.box((double)0.125, (double)0.0, (double)0.125, (double)0.875, (double)0.25, (double)0.875), (VoxelShape)Shapes.box((double)0.375, (double)0.25, (double)0.25, (double)0.625, (double)1.0, (double)0.75));
    private static final VoxelShape Z_SHAPE = Shapes.or((VoxelShape)Shapes.box((double)0.125, (double)0.0, (double)0.125, (double)0.875, (double)0.25, (double)0.875), (VoxelShape)Shapes.box((double)0.25, (double)0.25, (double)0.375, (double)0.75, (double)1.0, (double)0.625));
    private static final VoxelShape NORTH_SHAPE = Shapes.or((VoxelShape)Shapes.box((double)0.25, (double)0.75, (double)0.25, (double)0.75, (double)1.0, (double)0.75), (VoxelShape[])new VoxelShape[]{Shapes.box((double)0.25, (double)1.0, (double)0.25, (double)0.75, (double)1.375, (double)0.75), Shapes.box((double)0.4375, (double)0.6875, (double)0.125, (double)0.5625, (double)0.9375, (double)0.25), Shapes.box((double)0.25, (double)0.0, (double)0.375, (double)0.75, (double)0.75, (double)0.625), Shapes.box((double)0.125, (double)0.5, (double)-0.1875, (double)0.4375, (double)0.75, (double)0.0), Shapes.box((double)0.0625, (double)0.5, (double)0.0, (double)0.375, (double)0.75, (double)0.1875), Shapes.box((double)0.0, (double)0.5, (double)0.1875, (double)0.3125, (double)0.75, (double)0.375), Shapes.box((double)-0.0625, (double)0.5, (double)0.375, (double)0.25, (double)0.75, (double)0.5625), Shapes.box((double)0.75, (double)0.5, (double)0.375, (double)1.0625, (double)0.75, (double)0.5625), Shapes.box((double)0.5625, (double)0.5, (double)-0.1875, (double)0.875, (double)0.75, (double)0.0), Shapes.box((double)0.625, (double)0.5, (double)0.0, (double)0.9375, (double)0.75, (double)0.1875), Shapes.box((double)0.6875, (double)0.5, (double)0.1875, (double)1.0, (double)0.75, (double)0.375)});
    private static final VoxelShape NORTH_BROKEN_SHAPE = Shapes.or((VoxelShape)Shapes.box((double)0.25, (double)0.0, (double)0.375, (double)0.75, (double)0.75, (double)0.625), (VoxelShape[])new VoxelShape[]{Shapes.box((double)0.125, (double)0.5, (double)-0.1875, (double)0.4375, (double)0.75, (double)0.0), Shapes.box((double)0.0625, (double)0.5, (double)0.0, (double)0.375, (double)0.75, (double)0.1875), Shapes.box((double)0.0, (double)0.5, (double)0.1875, (double)0.3125, (double)0.75, (double)0.375), Shapes.box((double)-0.0625, (double)0.5, (double)0.375, (double)0.25, (double)0.75, (double)0.5625), Shapes.box((double)0.75, (double)0.5, (double)0.375, (double)1.0625, (double)0.75, (double)0.5625), Shapes.box((double)0.5625, (double)0.5, (double)-0.1875, (double)0.875, (double)0.75, (double)0.0), Shapes.box((double)0.625, (double)0.5, (double)0.0, (double)0.9375, (double)0.75, (double)0.1875), Shapes.box((double)0.6875, (double)0.5, (double)0.1875, (double)1.0, (double)0.75, (double)0.375)});
    private static final VoxelShape SOUTH_SHAPE = Shapes.or((VoxelShape)Shapes.box((double)0.25, (double)0.75, (double)0.25, (double)0.75, (double)1.0, (double)0.75), (VoxelShape[])new VoxelShape[]{Shapes.box((double)0.25, (double)1.0, (double)0.25, (double)0.75, (double)1.375, (double)0.75), Shapes.box((double)0.4375, (double)0.6875, (double)0.75, (double)0.5625, (double)0.9375, (double)0.875), Shapes.box((double)0.25, (double)0.0, (double)0.375, (double)0.75, (double)0.75, (double)0.625), Shapes.box((double)0.5625, (double)0.5, (double)1.0, (double)0.875, (double)0.75, (double)1.1875), Shapes.box((double)0.625, (double)0.5, (double)0.8125, (double)0.9375, (double)0.75, (double)1.0), Shapes.box((double)0.6875, (double)0.5, (double)0.625, (double)1.0, (double)0.75, (double)0.8125), Shapes.box((double)0.75, (double)0.5, (double)0.4375, (double)1.0625, (double)0.75, (double)0.625), Shapes.box((double)-0.0625, (double)0.5, (double)0.4375, (double)0.25, (double)0.75, (double)0.625), Shapes.box((double)0.125, (double)0.5, (double)1.0, (double)0.4375, (double)0.75, (double)1.1875), Shapes.box((double)0.0625, (double)0.5, (double)0.8125, (double)0.375, (double)0.75, (double)1.0), Shapes.box((double)0.0, (double)0.5, (double)0.625, (double)0.3125, (double)0.75, (double)0.8125)});
    private static final VoxelShape SOUTH_BROKEN_SHAPE = Shapes.or((VoxelShape)Shapes.box((double)0.25, (double)0.0, (double)0.375, (double)0.75, (double)0.75, (double)0.625), (VoxelShape[])new VoxelShape[]{Shapes.box((double)0.5625, (double)0.5, (double)1.0, (double)0.875, (double)0.75, (double)1.1875), Shapes.box((double)0.625, (double)0.5, (double)0.8125, (double)0.9375, (double)0.75, (double)1.0), Shapes.box((double)0.6875, (double)0.5, (double)0.625, (double)1.0, (double)0.75, (double)0.8125), Shapes.box((double)0.75, (double)0.5, (double)0.4375, (double)1.0625, (double)0.75, (double)0.625), Shapes.box((double)-0.0625, (double)0.5, (double)0.4375, (double)0.25, (double)0.75, (double)0.625), Shapes.box((double)0.125, (double)0.5, (double)1.0, (double)0.4375, (double)0.75, (double)1.1875), Shapes.box((double)0.0625, (double)0.5, (double)0.8125, (double)0.375, (double)0.75, (double)1.0), Shapes.box((double)0.0, (double)0.5, (double)0.625, (double)0.3125, (double)0.75, (double)0.8125)});
    private static final VoxelShape EAST_SHAPE = Shapes.or((VoxelShape)Shapes.box((double)0.25, (double)0.75, (double)0.25, (double)0.75, (double)1.0, (double)0.75), (VoxelShape[])new VoxelShape[]{Shapes.box((double)0.25, (double)1.0, (double)0.25, (double)0.75, (double)1.375, (double)0.75), Shapes.box((double)0.75, (double)0.6875, (double)0.4375, (double)0.875, (double)0.9375, (double)0.5625), Shapes.box((double)0.375, (double)0.0, (double)0.25, (double)0.625, (double)0.75, (double)0.75), Shapes.box((double)1.0, (double)0.5, (double)0.125, (double)1.1875, (double)0.75, (double)0.4375), Shapes.box((double)0.8125, (double)0.5, (double)0.0625, (double)1.0, (double)0.75, (double)0.375), Shapes.box((double)0.625, (double)0.5, (double)0.0, (double)0.8125, (double)0.75, (double)0.3125), Shapes.box((double)0.4375, (double)0.5, (double)-0.0625, (double)0.625, (double)0.75, (double)0.25), Shapes.box((double)0.4375, (double)0.5, (double)0.75, (double)0.625, (double)0.75, (double)1.0625), Shapes.box((double)1.0, (double)0.5, (double)0.5625, (double)1.1875, (double)0.75, (double)0.875), Shapes.box((double)0.8125, (double)0.5, (double)0.625, (double)1.0, (double)0.75, (double)0.9375), Shapes.box((double)0.625, (double)0.5, (double)0.6875, (double)0.8125, (double)0.75, (double)1.0)});
    private static final VoxelShape EAST_BROKEN_SHAPE = Shapes.or((VoxelShape)Shapes.box((double)0.375, (double)0.0, (double)0.25, (double)0.625, (double)0.75, (double)0.75), (VoxelShape[])new VoxelShape[]{Shapes.box((double)1.0, (double)0.5, (double)0.125, (double)1.1875, (double)0.75, (double)0.4375), Shapes.box((double)0.8125, (double)0.5, (double)0.0625, (double)1.0, (double)0.75, (double)0.375), Shapes.box((double)0.625, (double)0.5, (double)0.0, (double)0.8125, (double)0.75, (double)0.3125), Shapes.box((double)0.4375, (double)0.5, (double)-0.0625, (double)0.625, (double)0.75, (double)0.25), Shapes.box((double)0.4375, (double)0.5, (double)0.75, (double)0.625, (double)0.75, (double)1.0625), Shapes.box((double)1.0, (double)0.5, (double)0.5625, (double)1.1875, (double)0.75, (double)0.875), Shapes.box((double)0.8125, (double)0.5, (double)0.625, (double)1.0, (double)0.75, (double)0.9375), Shapes.box((double)0.625, (double)0.5, (double)0.6875, (double)0.8125, (double)0.75, (double)1.0)});
    private static final VoxelShape WEST_SHAPE = Shapes.or((VoxelShape)Shapes.box((double)0.25, (double)0.75, (double)0.25, (double)0.75, (double)1.0, (double)0.75), (VoxelShape[])new VoxelShape[]{Shapes.box((double)0.25, (double)1.0, (double)0.25, (double)0.75, (double)1.375, (double)0.75), Shapes.box((double)0.125, (double)0.6875, (double)0.4375, (double)0.25, (double)0.9375, (double)0.5625), Shapes.box((double)0.375, (double)0.0, (double)0.25, (double)0.625, (double)0.75, (double)0.75), Shapes.box((double)-0.1875, (double)0.5, (double)0.5625, (double)0.0, (double)0.75, (double)0.875), Shapes.box((double)0.0, (double)0.5, (double)0.625, (double)0.1875, (double)0.75, (double)0.9375), Shapes.box((double)0.1875, (double)0.5, (double)0.6875, (double)0.375, (double)0.75, (double)1.0), Shapes.box((double)0.375, (double)0.5, (double)0.75, (double)0.5625, (double)0.75, (double)1.0625), Shapes.box((double)0.375, (double)0.5, (double)-0.0625, (double)0.5625, (double)0.75, (double)0.25), Shapes.box((double)-0.1875, (double)0.5, (double)0.125, (double)0.0, (double)0.75, (double)0.4375), Shapes.box((double)0.0, (double)0.5, (double)0.0625, (double)0.1875, (double)0.75, (double)0.375), Shapes.box((double)0.1875, (double)0.5, (double)0.0, (double)0.375, (double)0.75, (double)0.3125)});
    private static final VoxelShape WEST_BROKEN_SHAPE = Shapes.or((VoxelShape)Shapes.box((double)0.375, (double)0.0, (double)0.25, (double)0.625, (double)0.75, (double)0.75), (VoxelShape[])new VoxelShape[]{Shapes.box((double)-0.1875, (double)0.5, (double)0.5625, (double)0.0, (double)0.75, (double)0.875), Shapes.box((double)0.0, (double)0.5, (double)0.625, (double)0.1875, (double)0.75, (double)0.9375), Shapes.box((double)0.1875, (double)0.5, (double)0.6875, (double)0.375, (double)0.75, (double)1.0), Shapes.box((double)0.375, (double)0.5, (double)0.75, (double)0.5625, (double)0.75, (double)1.0625), Shapes.box((double)0.375, (double)0.5, (double)-0.0625, (double)0.5625, (double)0.75, (double)0.25), Shapes.box((double)-0.1875, (double)0.5, (double)0.125, (double)0.0, (double)0.75, (double)0.4375), Shapes.box((double)0.0, (double)0.5, (double)0.0625, (double)0.1875, (double)0.75, (double)0.375), Shapes.box((double)0.1875, (double)0.5, (double)0.0, (double)0.375, (double)0.75, (double)0.3125)});

    public AncientStatueBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue(HALF, (Comparable)DoubleBlockHalf.LOWER)).setValue((Property)BROKEN, (Comparable)Boolean.valueOf(false))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected MapCodec<AncientStatueBlock> codec() {
        return CODEC;
    }

    protected VoxelShape getShape(BlockState state, BlockGetter blockGetter, BlockPos pos, CollisionContext context) {
        return switch ((DoubleBlockHalf)state.getValue(HALF)) {
            case DoubleBlockHalf.UPPER -> {
                switch ((Direction)state.getValue((Property)FACING)) {
                    case SOUTH: {
                        if (((Boolean)state.getValue((Property)BROKEN)).booleanValue()) {
                            yield SOUTH_BROKEN_SHAPE;
                        }
                        yield SOUTH_SHAPE;
                    }
                    case EAST: {
                        if (((Boolean)state.getValue((Property)BROKEN)).booleanValue()) {
                            yield EAST_BROKEN_SHAPE;
                        }
                        yield EAST_SHAPE;
                    }
                    case WEST: {
                        if (((Boolean)state.getValue((Property)BROKEN)).booleanValue()) {
                            yield WEST_BROKEN_SHAPE;
                        }
                        yield WEST_SHAPE;
                    }
                }
                if (((Boolean)state.getValue((Property)BROKEN)).booleanValue()) {
                    yield NORTH_BROKEN_SHAPE;
                }
                yield NORTH_SHAPE;
            }
            default -> {
                switch ((Direction)state.getValue((Property)FACING)) {
                    case EAST: 
                    case WEST: {
                        yield X_SHAPE;
                    }
                }
                yield Z_SHAPE;
            }
        };
    }

    protected boolean canSurvive(BlockState state, LevelReader levelReader, BlockPos pos) {
        if (state.getValue(HALF) != DoubleBlockHalf.UPPER) {
            return super.canSurvive(state, levelReader, pos);
        }
        BlockState blockstate = levelReader.getBlockState(pos.below());
        if (state.getBlock() != this) {
            return super.canSurvive(state, levelReader, pos);
        }
        return blockstate.is((Block)this) && blockstate.getValue(HALF) == DoubleBlockHalf.LOWER;
    }

    protected BlockState updateShape(BlockState state, LevelReader levelReader, ScheduledTickAccess tickAccess, BlockPos pos, Direction direction, BlockPos otherPos, BlockState otherState, RandomSource randomSource) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            tickAccess.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay(levelReader));
        }
        DoubleBlockHalf doubleblockhalf = (DoubleBlockHalf)state.getValue(HALF);
        if (direction.getAxis() == Direction.Axis.Y && doubleblockhalf == DoubleBlockHalf.LOWER == (direction == Direction.UP)) {
            return otherState.getBlock() instanceof AncientStatueBlock && otherState.getValue(HALF) != doubleblockhalf ? (BlockState)otherState.setValue(HALF, (Comparable)doubleblockhalf) : Blocks.AIR.defaultBlockState();
        }
        return doubleblockhalf == DoubleBlockHalf.LOWER && direction == Direction.DOWN && !state.canSurvive(levelReader, pos) ? Blocks.AIR.defaultBlockState() : super.updateShape(state, levelReader, tickAccess, pos, direction, otherPos, otherState, randomSource);
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            Vec3 tpTo = pos.above(state.getValue(HALF) == DoubleBlockHalf.UPPER ? 1 : 2).getBottomCenter();
            if (level.players().stream().anyMatch(player1 -> (Integer)player1.getData(PeakAttachmentTypes.DEATH_TIMER) >= 0) && !((Boolean)level.getBlockState(pos.above(state.getValue(HALF) == DoubleBlockHalf.UPPER ? 0 : 1)).getValue((Property)BROKEN)).booleanValue()) {
                for (ServerPlayer deadPlayer : serverLevel.players().stream().filter(player1 -> (Integer)player1.getData(PeakAttachmentTypes.DEATH_TIMER) >= 0).toList()) {
                    deadPlayer.teleportTo(tpTo.x(), tpTo.y(), tpTo.z());
                    ((StaminaBar)deadPlayer.getData(PeakAttachmentTypes.STAMINA_BAR)).revive(deadPlayer);
                }
                serverLevel.playSound(null, tpTo.x(), tpTo.y(), tpTo.z(), SoundEvents.TOTEM_USE, SoundSource.BLOCKS);
                serverLevel.sendParticles((ParticleOptions)((SimpleParticleType)PeakParticleTypes.REVIVE.get()), tpTo.x(), tpTo.y(), tpTo.z(), 1, 0.0, 0.0, 0.0, 0.0);
            }
            for (ServerPlayer inRange : serverLevel.players().stream().filter(player1 -> player1.distanceToSqr(pos.below(state.getValue(HALF) == DoubleBlockHalf.UPPER ? 1 : 0).getBottomCenter()) <= 144.0).toList()) {
                StaminaBar bar = (StaminaBar)inRange.getData(PeakAttachmentTypes.STAMINA_BAR);
                bar.addExtraStamina(0.25f);
                bar.removeStatus(AfflictionTypes.INJURY, 0.2f);
                inRange.connection.send((Packet)new ClientboundSetTitleTextPacket(this.getTextByType(state.getBlock())));
            }
            level.setBlock(pos.above(state.getValue(HALF) == DoubleBlockHalf.UPPER ? 0 : 1), (BlockState)level.getBlockState(pos.above(state.getValue(HALF) == DoubleBlockHalf.UPPER ? 0 : 1)).setValue((Property)BROKEN, (Comparable)Boolean.valueOf(true)), 2);
        }
        return InteractionResult.SUCCESS_SERVER;
    }

    private Component getTextByType(Block block) {
        if (block == PeakBlocks.SANDY_ANCIENT_STATUE.get()) {
            return Component.translatable((String)"peakBiome.tropics").withColor(6208054);
        }
        if (block == PeakBlocks.MOSSY_ANCIENT_STATUE.get()) {
            return Config.isMesa() ? Component.translatable((String)"peakBiome.mesa").withColor(13931300) : Component.translatable((String)"peakBiome.alpine").withColor(7918563);
        }
        if (block == PeakBlocks.SNOWY_ANCIENT_STATUE.get() || block == PeakBlocks.DESERT_ANCIENT_STATUE.get()) {
            return Component.translatable((String)"peakBiome.caldera").withColor(6182995);
        }
        if (block == PeakBlocks.CHARRED_ANCIENT_STATUE.get()) {
            return Component.translatable((String)"peakBiome.kiln").withColor(14693654);
        }
        return Component.empty();
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, HALF, BROKEN, WATERLOGGED});
    }

    protected FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public BlockState playerWillDestroy(Level level, BlockPos pos, BlockState state, Player player) {
        if (!level.isClientSide) {
            if (player.preventsBlockDrops()) {
                AncientStatueBlock.preventDropFromBottomPart(level, pos, state, player);
            } else {
                AncientStatueBlock.dropResources((BlockState)state, (Level)level, (BlockPos)pos, null, (Entity)player, (ItemStack)player.getMainHandItem());
            }
        }
        return super.playerWillDestroy(level, pos, state, player);
    }

    public void playerDestroy(Level level, Player player, BlockPos pos, BlockState state, @Nullable BlockEntity blockEntity, ItemStack stack) {
        super.playerDestroy(level, player, pos, Blocks.AIR.defaultBlockState(), blockEntity, stack);
    }

    protected static void preventDropFromBottomPart(Level level, BlockPos pos, BlockState state, Player player) {
        BlockPos blockpos;
        BlockState blockstate;
        if (state.getValue(HALF) == DoubleBlockHalf.UPPER && (blockstate = level.getBlockState(blockpos = pos.below())).is(state.getBlock()) && blockstate.getValue(HALF) == DoubleBlockHalf.LOWER) {
            level.setBlock(blockpos, blockstate.getFluidState().is((Fluid)Fluids.WATER) ? Blocks.WATER.defaultBlockState() : Blocks.AIR.defaultBlockState(), 35);
            level.levelEvent((Entity)player, 2001, blockpos, Block.getId((BlockState)blockstate));
        }
    }

    protected long getSeed(BlockState state, BlockPos pos) {
        return Mth.getSeed((int)pos.getX(), (int)pos.below(state.getValue(HALF) == DoubleBlockHalf.LOWER ? 0 : 1).getY(), (int)pos.getZ());
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockPos blockpos = context.getClickedPos();
        Level level = context.getLevel();
        FluidState fluidstate = level.getFluidState(blockpos);
        boolean flag = fluidstate.getType() == Fluids.WATER;
        return blockpos.getY() < level.getMaxY() && level.getBlockState(blockpos.above()).canBeReplaced(context) ? (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite())).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag)) : null;
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, LivingEntity living, ItemStack stack) {
        BlockPos blockpos = pos.above();
        level.setBlock(blockpos, AncientStatueBlock.copyWaterloggedFrom((LevelReader)level, blockpos, (BlockState)this.defaultBlockState().setValue(HALF, (Comparable)DoubleBlockHalf.UPPER)), 3);
    }

    public static BlockState copyWaterloggedFrom(LevelReader levelReader, BlockPos pos, BlockState state) {
        return state.hasProperty((Property)BlockStateProperties.WATERLOGGED) ? (BlockState)state.setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(levelReader.isWaterAt(pos))) : state;
    }
}

