/*
 * Decompiled with CFR 0.152.
 */
package net.tintankgames.peak.world.level.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.tintankgames.peak.attachments.PeakAttachmentTypes;
import net.tintankgames.peak.world.level.DynamiteDamageCalculator;
import net.tintankgames.peak.world.level.block.entity.DynamiteBlockEntity;
import net.tintankgames.peak.world.level.block.entity.PeakBlockEntityTypes;
import org.jetbrains.annotations.Nullable;

public class DynamiteBlock
extends BaseEntityBlock {
    public static final MapCodec<DynamiteBlock> CODEC = DynamiteBlock.simpleCodec(DynamiteBlock::new);
    public static final BooleanProperty LIT = BlockStateProperties.LIT;
    private static final VoxelShape SHAPE = Shapes.box((double)0.3125, (double)0.0, (double)0.3125, (double)0.6875, (double)0.9375, (double)0.6875);

    public DynamiteBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)LIT, (Comparable)Boolean.valueOf(false)));
    }

    protected MapCodec<DynamiteBlock> codec() {
        return CODEC;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{LIT});
    }

    protected VoxelShape getShape(BlockState state, BlockGetter blockGetter, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public void playerDestroy(Level level, Player player, BlockPos pos, BlockState state, @Nullable BlockEntity blockEntity, ItemStack stack) {
        super.playerDestroy(level, player, pos, state, blockEntity, stack);
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (!player.isSpectator()) {
                for (ServerPlayer inRange : serverPlayer.level().players().stream().filter(player1 -> player1.distanceToSqr(pos.getCenter()) <= 16.0 && !player1.isSpectator()).toList()) {
                    inRange.setData(PeakAttachmentTypes.EXPLOSION_TIMER, (Object)20);
                }
                serverPlayer.level().explode(null, null, (ExplosionDamageCalculator)new DynamiteDamageCalculator(), pos.getCenter(), 4.0f, false, Level.ExplosionInteraction.BLOCK);
                level.removeBlock(pos, false);
            }
        }
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new DynamiteBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return level.isClientSide ? null : DynamiteBlock.createTickerHelper(type, (BlockEntityType)((BlockEntityType)PeakBlockEntityTypes.DYNAMITE.get()), DynamiteBlockEntity::serverTick);
    }
}

