/*
 * Decompiled with CFR 0.152.
 */
package net.tintankgames.peak.world.level.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.InsideBlockEffectApplier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.tintankgames.peak.attachments.PeakAttachmentTypes;
import net.tintankgames.peak.world.level.ExplosiveBulbDamageCalculator;
import org.jetbrains.annotations.Nullable;

public class ExplosiveBulbBlock
extends Block {
    public static final MapCodec<ExplosiveBulbBlock> CODEC = ExplosiveBulbBlock.simpleCodec(ExplosiveBulbBlock::new);

    public ExplosiveBulbBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected MapCodec<ExplosiveBulbBlock> codec() {
        return CODEC;
    }

    protected void entityInside(BlockState state, Level level, BlockPos pos, Entity entity, InsideBlockEffectApplier effectApplier) {
        ServerPlayer player;
        if (entity instanceof ServerPlayer && !(player = (ServerPlayer)entity).isSpectator()) {
            for (ServerPlayer inRange : player.level().players().stream().filter(player1 -> player1.distanceToSqr(pos.getCenter()) <= 16.0 && !player1.isSpectator()).toList()) {
                inRange.setData(PeakAttachmentTypes.EXPLOSION_TIMER, (Object)20);
            }
            player.level().explode(null, null, (ExplosionDamageCalculator)new ExplosiveBulbDamageCalculator(), pos.getCenter(), 4.0f, false, Level.ExplosionInteraction.NONE);
            level.removeBlock(pos, false);
        }
    }

    public void playerDestroy(Level level, Player player, BlockPos pos, BlockState state, @Nullable BlockEntity blockEntity, ItemStack stack) {
        super.playerDestroy(level, player, pos, state, blockEntity, stack);
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            for (ServerPlayer inRange : serverPlayer.level().players().stream().filter(player1 -> player1.distanceToSqr(pos.getCenter()) <= 16.0).toList()) {
                inRange.setData(PeakAttachmentTypes.EXPLOSION_TIMER, (Object)20);
            }
            serverPlayer.level().explode(null, null, (ExplosionDamageCalculator)new ExplosiveBulbDamageCalculator(), pos.getCenter(), 4.0f, false, Level.ExplosionInteraction.NONE);
            level.removeBlock(pos, false);
        }
    }
}

