/*
 * Decompiled with CFR 0.152.
 */
package net.tintankgames.peak.world.level.block;

import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DoubleHighBlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.PushReaction;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.tintankgames.peak.world.level.block.AncientStatueBlock;
import net.tintankgames.peak.world.level.block.DynamiteBlock;
import net.tintankgames.peak.world.level.block.ExplosiveBulbBlock;
import net.tintankgames.peak.world.level.block.PitonBlock;

public class PeakBlocks {
    public static final DeferredRegister.Blocks REGISTER = DeferredRegister.createBlocks((String)"peak");
    public static final DeferredRegister.Items REGISTER_ITEMS = DeferredRegister.createItems((String)"peak");
    public static final DeferredBlock<Block> PITON = PeakBlocks.register("piton", props -> new PitonBlock(props.strength(1.0f, 1.0f).requiresCorrectToolForDrops().forceSolidOn().sound(SoundType.METAL).noCollission()), Rarity.UNCOMMON);
    public static final DeferredBlock<Block> ANCIENT_STATUE = PeakBlocks.registerDoubleHigh("ancient_statue", props -> new AncientStatueBlock(props.strength(-1.0f, 360000.0f).requiresCorrectToolForDrops().forceSolidOn().sound(SoundType.STONE)), Rarity.EPIC);
    public static final DeferredBlock<Block> SANDY_ANCIENT_STATUE = PeakBlocks.registerDoubleHigh("sandy_ancient_statue", props -> new AncientStatueBlock(props.strength(-1.0f, 360000.0f).requiresCorrectToolForDrops().forceSolidOn().sound(SoundType.STONE)), Rarity.EPIC);
    public static final DeferredBlock<Block> MOSSY_ANCIENT_STATUE = PeakBlocks.registerDoubleHigh("mossy_ancient_statue", props -> new AncientStatueBlock(props.strength(-1.0f, 360000.0f).requiresCorrectToolForDrops().forceSolidOn().sound(SoundType.STONE)), Rarity.EPIC);
    public static final DeferredBlock<Block> SNOWY_ANCIENT_STATUE = PeakBlocks.registerDoubleHigh("snowy_ancient_statue", props -> new AncientStatueBlock(props.strength(-1.0f, 360000.0f).requiresCorrectToolForDrops().forceSolidOn().sound(SoundType.STONE)), Rarity.EPIC);
    public static final DeferredBlock<Block> DESERT_ANCIENT_STATUE = PeakBlocks.registerDoubleHigh("desert_ancient_statue", props -> new AncientStatueBlock(props.strength(-1.0f, 360000.0f).requiresCorrectToolForDrops().forceSolidOn().sound(SoundType.STONE)), Rarity.EPIC);
    public static final DeferredBlock<Block> CHARRED_ANCIENT_STATUE = PeakBlocks.registerDoubleHigh("charred_ancient_statue", props -> new AncientStatueBlock(props.strength(-1.0f, 360000.0f).requiresCorrectToolForDrops().forceSolidOn().sound(SoundType.STONE)), Rarity.EPIC);
    public static final DeferredBlock<Block> GRASSY_ANCIENT_STATUE = PeakBlocks.registerDoubleHigh("grassy_ancient_statue", props -> new AncientStatueBlock(props.strength(-1.0f, 360000.0f).requiresCorrectToolForDrops().forceSolidOn().sound(SoundType.STONE)), Rarity.EPIC);
    public static final DeferredBlock<Block> EXPLOSIVE_BULB = PeakBlocks.register("explosive_bulb", props -> new ExplosiveBulbBlock(props.instabreak().noLootTable().noCollission().noOcclusion().isSuffocating(PeakBlocks::never).isValidSpawn(PeakBlocks::never).isViewBlocking(PeakBlocks::never).pushReaction(PushReaction.DESTROY).sound(SoundType.GRASS)), Rarity.COMMON);
    public static final DeferredBlock<Block> DYNAMITE = PeakBlocks.register("dynamite", props -> new DynamiteBlock(props.strength(1.0f, 1.0f).noLootTable().pushReaction(PushReaction.DESTROY).sound(SoundType.GRASS)), Rarity.UNCOMMON);

    private static <T extends Block> DeferredBlock<T> register(String id, Function<BlockBehaviour.Properties, T> function, Rarity rarity) {
        DeferredBlock block = REGISTER.registerBlock(id, function);
        REGISTER_ITEMS.register(id, key -> new BlockItem((Block)block.get(), new Item.Properties().setId(ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)key)).useBlockDescriptionPrefix().rarity(rarity)));
        return block;
    }

    private static <T extends Block> DeferredBlock<T> registerDoubleHigh(String id, Function<BlockBehaviour.Properties, T> function, Rarity rarity) {
        DeferredBlock block = REGISTER.registerBlock(id, function);
        REGISTER_ITEMS.register(id, key -> new DoubleHighBlockItem((Block)block.get(), new Item.Properties().setId(ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)key)).useBlockDescriptionPrefix().rarity(rarity)));
        return block;
    }

    public static boolean never(BlockState state, BlockGetter getter, BlockPos pos) {
        return false;
    }

    public static boolean never(BlockState state, BlockGetter getter, BlockPos pos, EntityType<?> type) {
        return false;
    }

    public static void register(IEventBus bus) {
        REGISTER.register(bus);
        REGISTER_ITEMS.register(bus);
    }
}

