/*
 * Decompiled with CFR 0.152.
 */
package net.tintankgames.peak.world.level.block;

import com.mojang.serialization.MapCodec;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.tintankgames.peak.attachments.PeakAttachmentTypes;

public class PitonBlock
extends HorizontalDirectionalBlock {
    public static final MapCodec<PitonBlock> CODEC = PitonBlock.simpleCodec(PitonBlock::new);
    private static final VoxelShape NORTH_SHAPE = Shapes.box((double)0.125, (double)0.0, (double)0.75, (double)0.875, (double)0.875, (double)1.0);
    private static final VoxelShape SOUTH_SHAPE = Shapes.box((double)0.125, (double)0.0, (double)0.0, (double)0.875, (double)0.875, (double)0.25);
    private static final VoxelShape EAST_SHAPE = Shapes.box((double)0.0, (double)0.0, (double)0.125, (double)0.25, (double)0.875, (double)0.875);
    private static final VoxelShape WEST_SHAPE = Shapes.box((double)0.75, (double)0.0, (double)0.125, (double)1.0, (double)0.875, (double)0.875);

    public PitonBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    protected MapCodec<PitonBlock> codec() {
        return CODEC;
    }

    protected VoxelShape getShape(BlockState state, BlockGetter blockGetter, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.getValue((Property)FACING)) {
            case Direction.SOUTH -> SOUTH_SHAPE;
            case Direction.EAST -> EAST_SHAPE;
            case Direction.WEST -> WEST_SHAPE;
            default -> NORTH_SHAPE;
        };
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING});
    }

    protected boolean canSurvive(BlockState state, LevelReader levelReader, BlockPos pos) {
        return PitonBlock.canSurvive(levelReader, pos, (Direction)state.getValue((Property)FACING));
    }

    public static boolean canSurvive(LevelReader levelReader, BlockPos pos, Direction direction) {
        BlockPos blockpos = pos.relative(direction.getOpposite());
        BlockState blockstate = levelReader.getBlockState(blockpos);
        return blockstate.isFaceSturdy((BlockGetter)levelReader, blockpos, direction);
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        if (!level.isClientSide && level.getBlockState(pos.below()).getCollisionShape((BlockGetter)level, pos.below()).isEmpty()) {
            player.setData(PeakAttachmentTypes.GRABBED_PITON, (Object)pos);
            player.setData(PeakAttachmentTypes.GRABBING_PITON, (Object)true);
            player.setData(PeakAttachmentTypes.MOVE_OFF_PITON_COOLDOWN, (Object)10);
            player.setData(PeakAttachmentTypes.PLACE_PITON_COOLDOWN, (Object)10);
        }
        return InteractionResult.SUCCESS_SERVER;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        for (Direction direction : context.getNearestLookingDirections()) {
            BlockState blockstate;
            if (!direction.getAxis().isHorizontal() || !(blockstate = (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)direction.getOpposite())).canSurvive((LevelReader)context.getLevel(), context.getClickedPos())) continue;
            return blockstate;
        }
        return null;
    }
}

