/*
 * Decompiled with CFR 0.152.
 */
package net.tintankgames.peak.world.level.block.entity;

import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.tintankgames.peak.attachments.PeakAttachmentTypes;
import net.tintankgames.peak.world.level.DynamiteDamageCalculator;
import net.tintankgames.peak.world.level.block.DynamiteBlock;
import net.tintankgames.peak.world.level.block.entity.PeakBlockEntityTypes;

public class DynamiteBlockEntity
extends BlockEntity {
    private int fuse = 80;

    public DynamiteBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)PeakBlockEntityTypes.DYNAMITE.get(), pos, state);
    }

    protected void saveAdditional(ValueOutput output) {
        super.saveAdditional(output);
        output.putInt("fuse", this.fuse);
    }

    protected void loadAdditional(ValueInput input) {
        super.loadAdditional(input);
        this.fuse = input.getIntOr("fuse", 80);
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, DynamiteBlockEntity blockEntity) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (!((Boolean)state.getValue((Property)DynamiteBlock.LIT)).booleanValue()) {
                if (serverLevel.players().stream().anyMatch(player -> player.distanceToSqr(pos.getCenter()) <= 16.0 && !player.isCreative() && !player.isSpectator())) {
                    serverLevel.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)DynamiteBlock.LIT, (Comparable)Boolean.valueOf(true)));
                    serverLevel.playSound(null, pos, SoundEvents.TNT_PRIMED, SoundSource.BLOCKS);
                }
            } else if (blockEntity.fuse > 0) {
                --blockEntity.fuse;
            } else {
                for (ServerPlayer inRange : serverLevel.players().stream().filter(player -> player.distanceToSqr(pos.getCenter()) <= 16.0 && !player.isSpectator()).toList()) {
                    inRange.setData(PeakAttachmentTypes.EXPLOSION_TIMER, (Object)20);
                }
                serverLevel.explode(null, null, (ExplosionDamageCalculator)new DynamiteDamageCalculator(), pos.getCenter(), 4.0f, false, Level.ExplosionInteraction.BLOCK);
                level.removeBlock(pos, false);
            }
        }
    }
}

