package com.chyzman.proximity.mixin;

import com.chyzman.proximity.api.ChatContext;
import com.chyzman.proximity.api.ProximityHandler;
import com.chyzman.proximity.api.ProximityLocation;
import com.chyzman.proximity.registry.ProximityGameRules;
import net.minecraft.class_2168;
import net.minecraft.class_2556;
import net.minecraft.class_3222;
import net.minecraft.class_3324;
import net.minecraft.class_7471;
import net.minecraft.server.MinecraftServer;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import static com.chyzman.proximity.registry.ProximityEntityAttributes.SPEECH_DISTANCE;

@Mixin(class_3324.class)
public abstract class PlayerManagerMixin {

    @Shadow
    public abstract MinecraftServer getServer();

    @Inject(
        method = "broadcast(Lnet/minecraft/network/message/SignedMessage;Lnet/minecraft/server/network/ServerPlayerEntity;Lnet/minecraft/network/message/MessageType$Parameters;)V",
        at = @At("HEAD"),
        cancellable = true
    )
    private void proximitify$chat(
        class_7471 message,
        class_3222 sender,
        class_2556.class_7602 params,
        CallbackInfo ci
    ) {
        var gamerules = getServer().method_30002().method_64395();
        if (!gamerules.method_20746(ProximityGameRules.PROXIMITY_ENABLED).method_20753()) return;
        var distance = gamerules.method_20746(ProximityGameRules.CHAT_DISTANCE).get();
        if (distance < 0) return;
        if (ProximityHandler.broadcastProximityChat(
            new ChatContext(
                ((class_3324) (Object) this),
                sender,
                message,
                params
            ),
            ProximityLocation.fromEntity(sender, 1),
            ProximityHandler.getProximityAttributeValue(
                sender,
                SPEECH_DISTANCE,
                distance
            )
        )) ci.cancel();
    }

    @Inject(
        method = "broadcast(Lnet/minecraft/network/message/SignedMessage;Lnet/minecraft/server/command/ServerCommandSource;Lnet/minecraft/network/message/MessageType$Parameters;)V",
        at = @At("HEAD"),
        cancellable = true
    )
    private void proximitify$commands(
        class_7471 message,
        class_2168 source,
        class_2556.class_7602 params,
        CallbackInfo ci
    ) {
        if (!getServer().method_3767().method_20746(ProximityGameRules.PROXIMITY_ENABLED).method_20753()) return;
        var distance = getServer().method_3767().method_20746(ProximityGameRules.COMMAND_DISTANCE).get();
        if (distance < 0) return;
        var sender = source.method_9228();
        if (sender == null) return;
        if (ProximityHandler.broadcastProximityChat(
            new ChatContext(
                ((class_3324) (Object) this),
                sender,
                message,
                params
            ),
            ProximityLocation.fromEntity(sender, 1),
            ProximityHandler.getProximityAttributeValue(
                sender,
                SPEECH_DISTANCE,
                distance
            )
        )) ci.cancel();
    }


}
