package com.chyzman.proximity.api;

import com.chyzman.proximity.Proximity;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_6880;
import net.minecraft.class_7604;

import static com.chyzman.proximity.registry.ProximityEntityAttributes.HEARING_DISTANCE;
import static com.chyzman.proximity.registry.ProximityEntityAttributes.SPEECH_DISTANCE;

public class ProximityHandler {
    public static boolean broadcastProximityChat(
        ChatContext context,
        ProximityLocation origin,
        double distance
    ) {
        var message = class_7604.method_44857(context.message());

        if (context.speaker() instanceof class_3222 player) player.method_43505(
            message,
            false,
            context.senderParameters() != null ? context.senderParameters() : context.parameters()
        );

        var speakerDistance = getProximityAttributeValue(context.speaker(), SPEECH_DISTANCE, distance);

        for (class_3222 listener : context.playerManager().method_14571()) {
            if (listener == context.speaker()) continue;
            var forced = ProximityEvents.FORCE_ABLE_TO_HEAR.invoker().forceHearing(context.speaker(), listener);
            switch (forced) {
                case DEFAULT:
                    var listenerLocation = ProximityEvents.MODIFY_PROXIMITY_LOCATION
                        .invoker()
                        .modifySpeechLocation(message.comp_1081(), listener, ProximityLocation.fromEntity(listener, 1));
                    if (listenerLocation.world() != origin.world()) continue;
                    var listenerDistance = getProximityAttributeValue(listener, HEARING_DISTANCE, distance);
                    var distanceBetween = origin.pos().method_1022(listenerLocation.pos());
                    if (distanceBetween > speakerDistance || distanceBetween > listenerDistance) continue;
                case TRUE:
                    listener.method_43505(message, false, context.parameters());
            }
        }

        return true;
    }

    public static boolean broadcastGlobalChat(
        ChatContext context
    ) {
        var message = class_7604.method_44857(context.message());

        if (context.speaker() instanceof class_3222 player) player.method_43505(
            message,
            false,
            context.senderParameters() != null ? context.senderParameters() : context.parameters()
        );

        for (class_3222 listener : context.playerManager().method_14571()) {
            if (listener == context.speaker()) continue;
            var forced = ProximityEvents.FORCE_ABLE_TO_HEAR.invoker().forceHearing(context.speaker(), listener);
            if (forced.orElse(true)) listener.method_43505(message, false, context.parameters());
        }

        return true;
    }

    private static final class_2960 TEMP_MODIFIER = Proximity.id("temp");

    public static double getProximityAttributeValue(
        class_1297 entity,
        class_6880<class_1320> attribute,
        double base
    ) {
        if (!(entity instanceof class_1309 living)) return base;
        var instance = living.method_5996(attribute);
        if (instance == null) return base;
        instance.method_26835(new class_1322(
            TEMP_MODIFIER,
            base,
            class_1322.class_1323.field_6328
        ));
        var returned = instance.method_6194();
        instance.method_6200(TEMP_MODIFIER);
        return returned;
    }
}
