package com.chyzman.proximity.command;

import com.chyzman.proximity.api.ChatContext;
import com.chyzman.proximity.api.ProximityHandler;
import com.chyzman.proximity.api.ProximityLocation;
import com.chyzman.proximity.registry.ProximityGameRules;
import com.chyzman.proximity.registry.ProximityMessageTypes;
import com.mojang.brigadier.tree.LiteralCommandNode;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2196;
import net.minecraft.class_2556;

import static com.chyzman.proximity.registry.ProximityEntityAttributes.SPEECH_DISTANCE;
import static com.chyzman.proximity.registry.ProximityGameRules.*;
import static com.chyzman.proximity.registry.ProximityMessageTypes.*;
import static net.minecraft.class_2170.method_9247;

public class MumbleCommand {
    public static void register() {
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> {
            LiteralCommandNode<class_2168> literalCommandNode = dispatcher.register(
                method_9247("mumble")
                    .then(class_2170.method_9244("message", class_2196.method_9340()).executes(context -> {
                        var source = context.getSource();
                        var sender = source.method_9228();
                        if (sender == null) return 0;
                        class_2196.method_45562(
                            context,
                            "message",
                            message -> ProximityHandler.broadcastProximityChat(
                                new ChatContext(
                                    source.method_9211().method_3760(),
                                    sender,
                                    message,
                                    class_2556.method_44833(MUMBLE_COMMAND_INCOMING, source),
                                    class_2556.method_44833(MUMBLE_COMMAND_OUTGOING, source)
                                ),
                                ProximityLocation.fromEntity(sender, 1),
                                ProximityHandler.getProximityAttributeValue(
                                    sender,
                                    SPEECH_DISTANCE,
                                    source.method_9225().method_64395().method_20746(MUMBLE_DISTANCE).get()
                                )
                            )
                        );
                        return 1;
                    })));
            dispatcher.register(class_2170.method_9247("m").redirect(literalCommandNode));
        });
    }
}
