package com.chyzman.proximity.mixin;

import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import static com.chyzman.proximity.registry.ProximityEntityAttributes.HEARING_DISTANCE;
import static com.chyzman.proximity.registry.ProximityEntityAttributes.SPEECH_DISTANCE;

import net.minecraft.class_1309;
import net.minecraft.class_5132;

@Mixin(class_1309.class)
public class LivingEntityMixin {

    @Inject(method = "createLivingAttributes", at = @At("RETURN"))
    private static void injectProximityAttributes(CallbackInfoReturnable<class_5132.class_5133> cir) {
        cir.getReturnValue()
            .method_26868(SPEECH_DISTANCE, 0)
            .method_26868(HEARING_DISTANCE, 0);
    }
}
