package com.chyzman.proximity.registry;

import net.fabricmc.fabric.api.gamerule.v1.CustomGameRuleCategory;
import net.fabricmc.fabric.api.gamerule.v1.GameRuleFactory;
import net.fabricmc.fabric.api.gamerule.v1.GameRuleRegistry;
import net.fabricmc.fabric.api.gamerule.v1.rule.DoubleRule;
import net.minecraft.class_124;
import net.minecraft.class_1928;
import net.minecraft.class_2561;

import static com.chyzman.proximity.Proximity.MODID;
import static com.chyzman.proximity.Proximity.id;

public class ProximityGameRules {
    public static final CustomGameRuleCategory PROXIMITY_GAMERULE_CATEGORY = new CustomGameRuleCategory(
        id("proximity"),
        class_2561.method_43471("gamerule.proximity.category.proximity").method_27695(class_124.field_1067, class_124.field_1054)
    );

    public static final class_1928.class_4313<class_1928.class_4310> PROXIMITY_ENABLED = register(
        "enableProximity", GameRuleFactory.createBooleanRule(true)
    );

    public static final class_1928.class_4313<DoubleRule> CHAT_DISTANCE = register(
        "chatDistance", GameRuleFactory.createDoubleRule(128, -1)
    );

    public static final class_1928.class_4313<DoubleRule> COMMAND_DISTANCE = register(
        "commandDistance", GameRuleFactory.createDoubleRule(128, -1)
    );

    public static final class_1928.class_4313<DoubleRule> MUMBLE_DISTANCE = register(
        "mumbleDistance", GameRuleFactory.createDoubleRule(1, -1)
    );

    public static void init() {
    }

    public static <T extends class_1928.class_4315<T>> class_1928.class_4313<T> register(String name, class_1928.class_4314<T> type) {
        return GameRuleRegistry.register(MODID + "." + name, PROXIMITY_GAMERULE_CATEGORY, type);
    }
}
