/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.beachparty.client.model;

import com.google.common.collect.ImmutableList;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1690;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4595;
import net.minecraft.class_5601;
import net.minecraft.class_5603;
import net.minecraft.class_5605;
import net.minecraft.class_5606;
import net.minecraft.class_5607;
import net.minecraft.class_5609;
import net.minecraft.class_5610;
import net.minecraft.class_630;
import net.minecraft.class_7755;
import net.satisfy.beachparty.core.util.BeachpartyIdentifier;
import org.jetbrains.annotations.NotNull;

@Environment(value=EnvType.CLIENT)
public class FloatyBoatModel
extends class_4595<class_1690>
implements class_7755 {
    public static final class_5601 LAYER_LOCATION = new class_5601(BeachpartyIdentifier.identifier("floaty_boat"), "main");
    private static final String LEFT_PADDLE = "left_paddle";
    private static final String RIGHT_PADDLE = "right_paddle";
    private static final String WATER_PATCH = "water_patch";
    private static final String BOTTOM = "bottom";
    private static final String BACK = "back";
    private static final String FRONT = "front";
    private static final String RIGHT = "right";
    private static final String LEFT = "left";
    private final class_630 leftPaddle;
    private final class_630 rightPaddle;
    private final class_630 waterPatch;
    private final ImmutableList<class_630> parts;

    public FloatyBoatModel(class_630 modelPart) {
        this.leftPaddle = modelPart.method_32086(LEFT_PADDLE);
        this.rightPaddle = modelPart.method_32086(RIGHT_PADDLE);
        this.waterPatch = modelPart.method_32086(WATER_PATCH);
        this.parts = this.createPartsBuilder(modelPart).build();
    }

    protected ImmutableList.Builder<class_630> createPartsBuilder(class_630 modelPart) {
        ImmutableList.Builder builder = new ImmutableList.Builder();
        builder.add((Object[])new class_630[]{modelPart.method_32086(BOTTOM), modelPart.method_32086(BACK), modelPart.method_32086(FRONT), modelPart.method_32086(RIGHT), modelPart.method_32086(LEFT), this.leftPaddle, this.rightPaddle});
        return builder;
    }

    public static void createChildren(class_5610 partDefinition) {
        partDefinition.method_32117(BOTTOM, class_5606.method_32108().method_32101(0, 0).method_32096().method_32098(-14.0f, -7.0f, -17.0f, 28.0f, 16.0f, 3.0f, new class_5605(0.0f)).method_32106(false), class_5603.method_32091((float)0.0f, (float)6.0f, (float)0.0f, (float)1.5708f, (float)0.0f, (float)0.0f));
        partDefinition.method_32117(FRONT, class_5606.method_32108().method_32101(0, 29).method_32096().method_32098(-8.0f, 14.0f, -3.0f, 14.0f, 6.0f, 4.0f, new class_5605(0.0f)).method_32106(false), class_5603.method_32091((float)15.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)1.5708f, (float)0.0f));
        partDefinition.method_32117(BACK, class_5606.method_32108().method_32101(0, 19).method_32096().method_32098(-6.0f, 14.0f, -3.0f, 14.0f, 6.0f, 4.0f, new class_5605(0.0f)).method_32106(false), class_5603.method_32091((float)-15.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-1.5708f, (float)0.0f));
        partDefinition.method_32117(RIGHT, class_5606.method_32108().method_32101(0, 39).method_32096().method_32098(-14.0f, 14.0f, -3.0f, 28.0f, 6.0f, 4.0f, new class_5605(0.0f)).method_32106(false), class_5603.method_32091((float)0.0f, (float)0.0f, (float)-9.0f, (float)0.0f, (float)-3.1416f, (float)0.0f));
        partDefinition.method_32117(LEFT, class_5606.method_32108().method_32101(0, 49).method_32096().method_32098(-14.0f, 14.0f, -1.0f, 28.0f, 6.0f, 4.0f, new class_5605(0.0f)).method_32106(false), class_5603.method_32090((float)0.0f, (float)0.0f, (float)9.0f));
        partDefinition.method_32117(LEFT_PADDLE, class_5606.method_32108().method_32101(62, 0).method_32097(-1.0f, 0.0f, -5.0f, 2.0f, 2.0f, 18.0f).method_32097(-1.001f, -3.0f, 8.0f, 1.0f, 6.0f, 7.0f), class_5603.method_32091((float)3.0f, (float)-5.0f, (float)9.0f, (float)0.0f, (float)0.0f, (float)0.19634955f));
        partDefinition.method_32117(RIGHT_PADDLE, class_5606.method_32108().method_32101(62, 0).method_32097(-1.0f, 0.0f, -5.0f, 2.0f, 2.0f, 18.0f).method_32097(0.001f, -3.0f, 8.0f, 1.0f, 6.0f, 7.0f), class_5603.method_32091((float)3.0f, (float)-5.0f, (float)-9.0f, (float)0.0f, (float)((float)Math.PI), (float)0.19634955f));
        partDefinition.method_32117(WATER_PATCH, class_5606.method_32108().method_32101(0, 0).method_32097(-14.0f, -9.0f, -3.0f, 28.0f, 16.0f, 3.0f), class_5603.method_32091((float)0.0f, (float)-3.0f, (float)1.0f, (float)1.5707964f, (float)0.0f, (float)0.0f));
    }

    public static class_5607 createBodyModel() {
        class_5609 meshDefinition = new class_5609();
        class_5610 partDefinition = meshDefinition.method_32111();
        FloatyBoatModel.createChildren(partDefinition);
        return class_5607.method_32110((class_5609)meshDefinition, (int)128, (int)64);
    }

    public void setupAnim(class_1690 boat, float f, float g, float h, float i, float j) {
        FloatyBoatModel.animatePaddle(boat, 0, this.leftPaddle, f);
        FloatyBoatModel.animatePaddle(boat, 1, this.rightPaddle, f);
    }

    @NotNull
    public ImmutableList<class_630> parts() {
        return this.parts;
    }

    @NotNull
    public class_630 method_22954() {
        return this.waterPatch;
    }

    public void method_2828(class_4587 poseStack, class_4588 vertexConsumer, int packedLight, int packedOverlay, int color) {
        poseStack.method_22903();
        poseStack.method_46416(0.0f, -1.1f, 0.0f);
        for (class_630 part : this.parts) {
            if (part == this.leftPaddle || part == this.rightPaddle) continue;
            part.method_22699(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        }
        poseStack.method_22909();
        this.leftPaddle.method_22699(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.rightPaddle.method_22699(poseStack, vertexConsumer, packedLight, packedOverlay, color);
    }

    private static void animatePaddle(class_1690 boat, int i, class_630 modelPart, float f) {
        float g = boat.method_7551(i, f);
        modelPart.field_3654 = class_3532.method_37166((float)-1.0471976f, (float)-0.2617994f, (float)((class_3532.method_15374((float)g) + 1.0f) / 2.0f));
        modelPart.field_3675 = class_3532.method_37166((float)-0.7853982f, (float)0.7853982f, (float)((class_3532.method_15374((float)(g + 1.0f)) + 1.0f) / 2.0f));
        if (i == 1) {
            modelPart.field_3675 = (float)Math.PI - modelPart.field_3675;
        }
    }
}

