/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.beachparty.core.block;

import com.mojang.serialization.MapCodec;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2415;
import net.minecraft.class_2464;
import net.minecraft.class_247;
import net.minecraft.class_2470;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2753;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3542;
import net.minecraft.class_3726;
import net.minecraft.class_4970;
import net.minecraft.class_5251;
import net.minecraft.class_5558;
import net.minecraft.class_7225;
import net.minecraft.class_9279;
import net.minecraft.class_9334;
import net.satisfy.beachparty.core.block.entity.BeachGoalBlockEntity;
import net.satisfy.beachparty.core.registry.EntityTypeRegistry;
import net.satisfy.beachparty.core.registry.ObjectRegistry;
import net.satisfy.beachparty.core.util.BeachpartyUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BeachGoalBlock
extends class_2237 {
    public static final class_2754<Part> PART = class_2754.method_11850((String)"part", Part.class);
    public static final class_2753 FACING = class_2741.field_12481;
    private static final class_265 SHAPE_BOTTOM_LEFT = BeachGoalBlock.makeBottomLeftShape();
    private static final class_265 SHAPE_BOTTOM_RIGHT = BeachGoalBlock.makeBottomRightShape();
    private static final class_265 SHAPE_TOP_LEFT = BeachGoalBlock.makeTopLeftShape();
    private static final class_265 SHAPE_TOP_RIGHT = BeachGoalBlock.makeTopRightShape();
    public static final Map<class_2350, Map<Part, class_265>> SHAPE = (Map)class_156.method_654(new HashMap(), map -> {
        for (class_2350 direction : class_2350.class_2353.field_11062.method_29716().toList()) {
            HashMap<Part, class_265> partShapeMap = new HashMap<Part, class_265>();
            partShapeMap.put(Part.BOTTOM_LEFT, BeachpartyUtil.rotateShape(class_2350.field_11043, direction, SHAPE_BOTTOM_LEFT));
            partShapeMap.put(Part.BOTTOM_RIGHT, BeachpartyUtil.rotateShape(class_2350.field_11043, direction, SHAPE_BOTTOM_RIGHT));
            partShapeMap.put(Part.TOP_LEFT, BeachpartyUtil.rotateShape(class_2350.field_11043, direction, SHAPE_TOP_LEFT));
            partShapeMap.put(Part.TOP_RIGHT, BeachpartyUtil.rotateShape(class_2350.field_11043, direction, SHAPE_TOP_RIGHT));
            map.put(direction, partShapeMap);
        }
    });
    private static final Supplier<class_265> detectionShapeSupplier = () -> class_259.method_1081((double)0.125, (double)0.0, (double)0.1875, (double)0.875, (double)0.6875, (double)0.75);
    public static final Map<class_2350, class_265> DETECTION_SHAPE = (Map)class_156.method_654(new HashMap(), map -> {
        for (class_2350 direction : class_2350.class_2353.field_11062.method_29716().toList()) {
            map.put(direction, BeachpartyUtil.rotateShape(class_2350.field_11043, direction, detectionShapeSupplier.get()));
        }
    });
    public static final MapCodec<BeachGoalBlock> CODEC = BeachGoalBlock.method_54094(BeachGoalBlock::new);

    private static class_265 makeBottomLeftShape() {
        class_265 shape = class_259.method_1073();
        shape = class_259.method_1072((class_265)shape, (class_265)class_259.method_1081((double)0.125, (double)0.0, (double)0.1875, (double)0.25, (double)1.0, (double)0.3125), (class_247)class_247.field_1366);
        shape = class_259.method_1072((class_265)shape, (class_265)class_259.method_1081((double)0.125, (double)0.0, (double)0.6875, (double)1.0, (double)0.125, (double)0.8125), (class_247)class_247.field_1366);
        shape = class_259.method_1072((class_265)shape, (class_265)class_259.method_1081((double)0.125, (double)0.0, (double)0.3125, (double)0.25, (double)0.125, (double)0.6875), (class_247)class_247.field_1366);
        shape = class_259.method_1072((class_265)shape, (class_265)class_259.method_1081((double)0.1875, (double)0.125, (double)0.3125, (double)0.25, (double)1.0, (double)0.75), (class_247)class_247.field_1366);
        shape = class_259.method_1072((class_265)shape, (class_265)class_259.method_1081((double)0.1875, (double)0.125, (double)0.6875, (double)1.0, (double)1.0, (double)0.75), (class_247)class_247.field_1366);
        return shape;
    }

    private static class_265 makeBottomRightShape() {
        class_265 shape = class_259.method_1073();
        shape = class_259.method_1072((class_265)shape, (class_265)class_259.method_1081((double)0.75, (double)0.0, (double)0.1875, (double)0.875, (double)1.0, (double)0.3125), (class_247)class_247.field_1366);
        shape = class_259.method_1072((class_265)shape, (class_265)class_259.method_1081((double)0.0, (double)0.0, (double)0.6875, (double)0.875, (double)0.125, (double)0.8125), (class_247)class_247.field_1366);
        shape = class_259.method_1072((class_265)shape, (class_265)class_259.method_1081((double)0.75, (double)0.0, (double)0.3125, (double)0.875, (double)0.125, (double)0.6875), (class_247)class_247.field_1366);
        shape = class_259.method_1072((class_265)shape, (class_265)class_259.method_1081((double)0.75, (double)0.125, (double)0.3125, (double)0.8125, (double)1.0, (double)0.75), (class_247)class_247.field_1366);
        shape = class_259.method_1072((class_265)shape, (class_265)class_259.method_1081((double)0.0, (double)0.125, (double)0.6875, (double)0.8125, (double)1.0, (double)0.75), (class_247)class_247.field_1366);
        return shape;
    }

    private static class_265 makeTopLeftShape() {
        class_265 shape = class_259.method_1073();
        shape = class_259.method_1072((class_265)shape, (class_265)class_259.method_1081((double)0.125, (double)0.0, (double)0.1875, (double)0.25, (double)0.625, (double)0.3125), (class_247)class_247.field_1366);
        shape = class_259.method_1072((class_265)shape, (class_265)class_259.method_1081((double)0.125, (double)0.625, (double)0.1875, (double)1.0, (double)0.75, (double)0.3125), (class_247)class_247.field_1366);
        shape = class_259.method_1072((class_265)shape, (class_265)class_259.method_1081((double)0.1875, (double)0.0, (double)0.3125, (double)0.25, (double)0.625, (double)0.75), (class_247)class_247.field_1366);
        shape = class_259.method_1072((class_265)shape, (class_265)class_259.method_1081((double)0.25, (double)0.0, (double)0.6875, (double)1.0, (double)0.625, (double)0.75), (class_247)class_247.field_1366);
        return shape;
    }

    private static class_265 makeTopRightShape() {
        class_265 shape = class_259.method_1073();
        shape = class_259.method_1072((class_265)shape, (class_265)class_259.method_1081((double)0.75, (double)0.0, (double)0.1875, (double)0.875, (double)0.625, (double)0.3125), (class_247)class_247.field_1366);
        shape = class_259.method_1072((class_265)shape, (class_265)class_259.method_1081((double)0.0, (double)0.625, (double)0.1875, (double)0.875, (double)0.75, (double)0.3125), (class_247)class_247.field_1366);
        shape = class_259.method_1072((class_265)shape, (class_265)class_259.method_1081((double)0.75, (double)0.0, (double)0.3125, (double)0.8125, (double)0.625, (double)0.75), (class_247)class_247.field_1366);
        shape = class_259.method_1072((class_265)shape, (class_265)class_259.method_1081((double)0.0, (double)0.0, (double)0.6875, (double)0.75, (double)0.625, (double)0.75), (class_247)class_247.field_1366);
        return shape;
    }

    public BeachGoalBlock(class_4970.class_2251 properties) {
        super(properties);
        this.method_9590((class_2680)((class_2680)((class_2680)this.field_10647.method_11664()).method_11657(PART, (Comparable)((Object)Part.BOTTOM_LEFT))).method_11657((class_2769)FACING, (Comparable)class_2350.field_11043));
    }

    @NotNull
    protected MapCodec<? extends class_2237> method_53969() {
        return CODEC;
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{PART, FACING});
    }

    public class_2680 method_9605(class_1750 context) {
        class_2350 direction;
        class_2338 pos = context.method_8037();
        class_1937 world = context.method_8045();
        if (!this.canPlaceAt(world, pos, direction = context.method_8042().method_10153())) {
            return null;
        }
        return (class_2680)((class_2680)this.method_9564().method_11657(PART, (Comparable)((Object)Part.BOTTOM_LEFT))).method_11657((class_2769)FACING, (Comparable)direction);
    }

    @NotNull
    public class_2680 method_9598(class_2680 state, class_2470 rot) {
        return (class_2680)state.method_11657((class_2769)FACING, (Comparable)rot.method_10503((class_2350)state.method_11654((class_2769)FACING)));
    }

    @NotNull
    public class_2680 method_9569(class_2680 state, class_2415 mirrorIn) {
        return state.method_26186(mirrorIn.method_10345((class_2350)state.method_11654((class_2769)FACING)));
    }

    public class_265 getDetectionShape(class_2680 state) {
        return DETECTION_SHAPE.get(state.method_11654((class_2769)FACING));
    }

    @NotNull
    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        class_2350 direction = (class_2350)state.method_11654((class_2769)FACING);
        Part part = (Part)((Object)state.method_11654(PART));
        return SHAPE.get(direction).get((Object)part);
    }

    private boolean canPlaceAt(class_1937 world, class_2338 pos, class_2350 direction) {
        return world.method_8320(pos).method_45474() && world.method_8320(pos.method_10084()).method_45474() && world.method_8320(pos.method_10093(direction.method_10170())).method_45474() && world.method_8320(pos.method_10093(direction.method_10170()).method_10084()).method_45474();
    }

    public void method_9567(class_1937 world, class_2338 pos, class_2680 state, @Nullable class_1309 placer, class_1799 stack) {
        class_2350 direction = (class_2350)state.method_11654((class_2769)FACING);
        world.method_8652(pos.method_10084(), (class_2680)((class_2680)this.method_9564().method_11657(PART, (Comparable)((Object)Part.TOP_LEFT))).method_11657((class_2769)FACING, (Comparable)direction), 3);
        world.method_8652(pos.method_10093(direction.method_10170()), (class_2680)((class_2680)this.method_9564().method_11657(PART, (Comparable)((Object)Part.BOTTOM_RIGHT))).method_11657((class_2769)FACING, (Comparable)direction), 3);
        world.method_8652(pos.method_10093(direction.method_10170()).method_10084(), (class_2680)((class_2680)this.method_9564().method_11657(PART, (Comparable)((Object)Part.TOP_RIGHT))).method_11657((class_2769)FACING, (Comparable)direction), 3);
        world.method_8396(null, pos, class_3417.field_14718, class_3419.field_15245, 1.0f, 1.0f);
        world.method_8396(null, pos, class_3417.field_42549, class_3419.field_15245, 1.0f, 1.0f);
    }

    public void method_9536(class_2680 state, class_1937 world, class_2338 pos, class_2680 newState, boolean isMoving) {
        state.method_26204();
        newState.method_26204();
        super.method_9536(state, world, pos, newState, isMoving);
    }

    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new BeachGoalBlockEntity(pos, state);
    }

    @NotNull
    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11458;
    }

    public boolean method_9506(class_2680 state) {
        return true;
    }

    public int method_9524(class_2680 state, class_1922 world, class_2338 pos, class_2350 direction) {
        class_2586 blockEntity = world.method_8321(pos);
        if (blockEntity instanceof BeachGoalBlockEntity) {
            BeachGoalBlockEntity goalBlockEntity = (BeachGoalBlockEntity)blockEntity;
            return goalBlockEntity.hasBeachBall() ? 15 : 0;
        }
        return 0;
    }

    @Nullable
    public <T extends class_2586> class_5558<T> method_31645(class_1937 level, class_2680 state, class_2591<T> type) {
        return level.field_9236 ? null : class_2237.method_31618(type, (class_2591)((class_2591)EntityTypeRegistry.BEACH_GOAL_BLOCK_ENTITY.get()), BeachGoalBlockEntity::tick);
    }

    public void method_9568(class_1799 itemStack, class_1792.class_9635 tooltipContext, List<class_2561> tooltip, class_1836 tooltipFlag) {
        tooltip.add((class_2561)class_2561.method_43471((String)"tooltip.beachparty.canbeplaced").method_27694(style -> style.method_27703(class_5251.method_27717((int)13939843))));
    }

    @NotNull
    public class_2680 method_9576(class_1937 world, class_2338 pos, class_2680 state, class_1657 player) {
        class_2338 basePos = this.getBasePos(world.method_8320(pos), pos);
        class_2586 entity = world.method_8321(basePos);
        if (!(entity instanceof BeachGoalBlockEntity)) {
            super.method_9576(world, pos, state, player);
            return state;
        }
        BeachGoalBlockEntity beachGoalBlockEntity = (BeachGoalBlockEntity)entity;
        if (world.method_8608()) {
            return state;
        }
        class_2487 blockEntityTag = new class_2487();
        beachGoalBlockEntity.method_11007(blockEntityTag, (class_7225.class_7874)world.method_30349());
        class_2487 tag = new class_2487();
        tag.method_10566("BlockEntityTag", (class_2520)blockEntityTag);
        class_1799 stack = new class_1799((class_1935)ObjectRegistry.BEACH_GOAL.get());
        stack.method_57379(class_9334.field_49628, (Object)class_9279.method_57456((class_2487)tag));
        world.method_8649((class_1297)new class_1542(world, (double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), stack));
        this.destroyAdjacentBlocks(world, basePos);
        super.method_9576(world, pos, state, player);
        return state;
    }

    private class_2338 getBasePos(class_2680 state, class_2338 pos) {
        Part part = (Part)((Object)state.method_11654(PART));
        class_2350 direction = (class_2350)state.method_11654((class_2769)FACING);
        return switch (part.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> pos;
            case 2 -> pos.method_10074();
            case 1 -> pos.method_10079(direction.method_10160(), 1);
            case 3 -> pos.method_10079(direction.method_10160(), 1).method_10074();
        };
    }

    private void destroyAdjacentBlocks(class_1937 world, class_2338 basePos) {
        class_2680 blockstate = world.method_8320(basePos);
        class_2350 facing = (class_2350)blockstate.method_11654((class_2769)FACING);
        world.method_8650(basePos, false);
        world.method_8650(basePos.method_10084(), false);
        world.method_8650(basePos.method_10079(facing.method_10170(), 1), false);
        world.method_8650(basePos.method_10079(facing.method_10170(), 1).method_10084(), false);
    }

    public static enum Part implements class_3542
    {
        BOTTOM_LEFT("bottom_left"),
        BOTTOM_RIGHT("bottom_right"),
        TOP_LEFT("top_left"),
        TOP_RIGHT("top_right");

        private final String name;

        private Part(String name) {
            this.name = name;
        }

        @NotNull
        public String method_15434() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }
    }
}

