/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.beachparty.core.block;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.class_1268;
import net.minecraft.class_1309;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2415;
import net.minecraft.class_247;
import net.minecraft.class_2470;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2753;
import net.minecraft.class_2754;
import net.minecraft.class_2756;
import net.minecraft.class_2769;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_9062;
import net.satisfy.beachparty.core.block.LineConnectingBlock;
import net.satisfy.beachparty.core.util.BeachpartyUtil;
import org.jetbrains.annotations.NotNull;

public class HoodedBeachChair
extends LineConnectingBlock {
    public static final class_2754<class_2756> HALF = class_2754.method_11850((String)"half", class_2756.class);
    public static final class_2753 FACING = class_2741.field_12481;
    private static final Supplier<class_265> topRightShapeSupplier = () -> {
        class_265 shape = class_259.method_1073();
        shape = class_259.method_1072((class_265)shape, (class_265)class_259.method_1081((double)0.0, (double)0.8125, (double)0.0, (double)0.9375, (double)1.0, (double)0.75), (class_247)class_247.field_1366);
        shape = class_259.method_1072((class_265)shape, (class_265)class_259.method_1081((double)0.0, (double)0.75, (double)0.75, (double)0.9375, (double)0.9375, (double)0.9375), (class_247)class_247.field_1366);
        shape = class_259.method_1072((class_265)shape, (class_265)class_259.method_1081((double)0.0, (double)0.0, (double)0.0, (double)0.875, (double)0.8125, (double)0.0625), (class_247)class_247.field_1366);
        shape = class_259.method_1072((class_265)shape, (class_265)class_259.method_1081((double)0.874375, (double)0.0, (double)0.0, (double)0.936875, (double)0.8125, (double)0.75), (class_247)class_247.field_1366);
        return shape;
    };
    private static final Supplier<class_265> topLeftShapeSupplier = () -> {
        class_265 shape = class_259.method_1073();
        shape = class_259.method_1072((class_265)shape, (class_265)class_259.method_1081((double)0.0625, (double)0.8125, (double)0.0, (double)1.0, (double)1.0, (double)0.75), (class_247)class_247.field_1366);
        shape = class_259.method_1072((class_265)shape, (class_265)class_259.method_1081((double)0.0625, (double)0.75, (double)0.75, (double)1.0, (double)0.9375, (double)0.9375), (class_247)class_247.field_1366);
        shape = class_259.method_1072((class_265)shape, (class_265)class_259.method_1081((double)0.125, (double)0.0, (double)0.0, (double)1.0, (double)0.8125, (double)0.0625), (class_247)class_247.field_1366);
        shape = class_259.method_1072((class_265)shape, (class_265)class_259.method_1081((double)0.063125, (double)0.0, (double)0.0, (double)0.125625, (double)0.8125, (double)0.75), (class_247)class_247.field_1366);
        return shape;
    };
    public static final Map<class_2350, class_265> TOP_RIGHT_SHAPE = (Map)class_156.method_654(new HashMap(), map -> {
        for (class_2350 direction : class_2350.class_2353.field_11062) {
            class_265 shape = direction == class_2350.field_11043 || direction == class_2350.field_11035 ? topLeftShapeSupplier.get() : topRightShapeSupplier.get();
            map.put(direction, BeachpartyUtil.rotateShape(class_2350.field_11035, direction, shape));
        }
    });
    public static final Map<class_2350, class_265> TOP_LEFT_SHAPE = (Map)class_156.method_654(new HashMap(), map -> {
        for (class_2350 direction : class_2350.class_2353.field_11062) {
            class_265 shape = direction == class_2350.field_11043 || direction == class_2350.field_11035 ? topRightShapeSupplier.get() : topLeftShapeSupplier.get();
            map.put(direction, BeachpartyUtil.rotateShape(class_2350.field_11035, direction, shape));
        }
    });
    private static final Supplier<class_265> topMiddleShapeSupplier = () -> {
        class_265 shape = class_259.method_1073();
        shape = class_259.method_1072((class_265)shape, (class_265)class_259.method_1081((double)0.0, (double)0.8125, (double)0.0, (double)1.0, (double)1.0, (double)0.75), (class_247)class_247.field_1366);
        shape = class_259.method_1072((class_265)shape, (class_265)class_259.method_1081((double)0.0, (double)0.75, (double)0.75, (double)1.0, (double)0.9375, (double)0.9375), (class_247)class_247.field_1366);
        shape = class_259.method_1072((class_265)shape, (class_265)class_259.method_1081((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.8125, (double)0.0625), (class_247)class_247.field_1366);
        return shape;
    };
    public static final Map<class_2350, class_265> TOP_MIDDLE_SHAPE = (Map)class_156.method_654(new HashMap(), map -> {
        for (class_2350 direction : class_2350.class_2353.field_11062) {
            map.put(direction, BeachpartyUtil.rotateShape(class_2350.field_11035, direction, topMiddleShapeSupplier.get()));
        }
    });
    private static final Supplier<class_265> bottomRightShapeSupplier = () -> {
        class_265 shape = class_259.method_1073();
        shape = class_259.method_1072((class_265)shape, (class_265)class_259.method_1081((double)0.875, (double)0.0, (double)0.1875, (double)1.0, (double)1.0, (double)1.0), (class_247)class_247.field_1366);
        shape = class_259.method_1072((class_265)shape, (class_265)class_259.method_1081((double)0.0, (double)0.0, (double)0.25, (double)0.875, (double)0.375, (double)0.8125), (class_247)class_247.field_1366);
        shape = class_259.method_1072((class_265)shape, (class_265)class_259.method_1081((double)0.0, (double)0.375, (double)0.25, (double)0.875, (double)0.5, (double)0.875), (class_247)class_247.field_1366);
        return shape;
    };
    private static final Supplier<class_265> bottomLeftShapeSupplier = () -> {
        class_265 shape = class_259.method_1073();
        shape = class_259.method_1072((class_265)shape, (class_265)class_259.method_1081((double)0.0, (double)0.0, (double)0.1875, (double)0.125, (double)1.0, (double)1.0), (class_247)class_247.field_1366);
        shape = class_259.method_1072((class_265)shape, (class_265)class_259.method_1081((double)0.125, (double)0.0, (double)0.25, (double)1.0, (double)0.375, (double)0.8125), (class_247)class_247.field_1366);
        shape = class_259.method_1072((class_265)shape, (class_265)class_259.method_1081((double)0.125, (double)0.375, (double)0.25, (double)1.0, (double)0.5, (double)0.875), (class_247)class_247.field_1366);
        return shape;
    };
    public static final Map<class_2350, class_265> BOTTOM_RIGHT_SHAPE = (Map)class_156.method_654(new HashMap(), map -> {
        for (class_2350 direction : class_2350.class_2353.field_11062) {
            class_265 shape = direction == class_2350.field_11043 || direction == class_2350.field_11035 ? bottomLeftShapeSupplier.get() : bottomRightShapeSupplier.get();
            map.put(direction, BeachpartyUtil.rotateShape(class_2350.field_11035, direction, shape));
        }
    });
    public static final Map<class_2350, class_265> BOTTOM_LEFT_SHAPE = (Map)class_156.method_654(new HashMap(), map -> {
        for (class_2350 direction : class_2350.class_2353.field_11062) {
            class_265 shape = direction == class_2350.field_11043 || direction == class_2350.field_11035 ? bottomRightShapeSupplier.get() : bottomLeftShapeSupplier.get();
            map.put(direction, BeachpartyUtil.rotateShape(class_2350.field_11035, direction, shape));
        }
    });
    private static final Supplier<class_265> bottomMiddleShapeSupplier = () -> {
        class_265 shape = class_259.method_1073();
        shape = class_259.method_1072((class_265)shape, (class_265)class_259.method_1081((double)0.0, (double)0.0, (double)0.25, (double)1.0, (double)0.375, (double)0.8125), (class_247)class_247.field_1366);
        shape = class_259.method_1072((class_265)shape, (class_265)class_259.method_1081((double)0.0, (double)0.375, (double)0.25, (double)1.0, (double)0.5, (double)0.875), (class_247)class_247.field_1366);
        return shape;
    };
    public static final Map<class_2350, class_265> BOTTOM_MIDDLE_SHAPE = (Map)class_156.method_654(new HashMap(), map -> {
        for (class_2350 direction : class_2350.class_2353.field_11062) {
            map.put(direction, BeachpartyUtil.rotateShape(class_2350.field_11035, direction, bottomMiddleShapeSupplier.get()));
        }
    });
    private static final Supplier<class_265> topShapeSupplier = () -> {
        class_265 shape = class_259.method_1073();
        shape = class_259.method_1072((class_265)shape, (class_265)class_259.method_1081((double)0.0625, (double)0.8125, (double)0.0, (double)0.9375, (double)1.0, (double)0.75), (class_247)class_247.field_1366);
        shape = class_259.method_1072((class_265)shape, (class_265)class_259.method_1081((double)0.0625, (double)0.75, (double)0.75, (double)0.9375, (double)0.9375, (double)0.9375), (class_247)class_247.field_1366);
        shape = class_259.method_1072((class_265)shape, (class_265)class_259.method_1081((double)0.875625, (double)0.0, (double)0.0, (double)0.938125, (double)0.8125, (double)0.75), (class_247)class_247.field_1366);
        shape = class_259.method_1072((class_265)shape, (class_265)class_259.method_1081((double)0.125, (double)0.0, (double)0.0, (double)0.875, (double)0.8125, (double)0.0625), (class_247)class_247.field_1366);
        shape = class_259.method_1072((class_265)shape, (class_265)class_259.method_1081((double)0.063125, (double)0.0, (double)0.0, (double)0.125625, (double)0.8125, (double)0.75), (class_247)class_247.field_1366);
        return shape;
    };
    public static final Map<class_2350, class_265> TOP_SHAPE = (Map)class_156.method_654(new HashMap(), map -> {
        for (class_2350 direction : class_2350.class_2353.field_11062) {
            map.put(direction, BeachpartyUtil.rotateShape(class_2350.field_11035, direction, topShapeSupplier.get()));
        }
    });
    private static final Supplier<class_265> bottomShapeSupplier = () -> {
        class_265 shape = class_259.method_1073();
        shape = class_259.method_1072((class_265)shape, (class_265)class_259.method_1081((double)0.875, (double)0.0, (double)0.1875, (double)1.0, (double)1.0, (double)1.0), (class_247)class_247.field_1366);
        shape = class_259.method_1072((class_265)shape, (class_265)class_259.method_1081((double)0.0, (double)0.0, (double)0.1875, (double)0.125, (double)1.0, (double)1.0), (class_247)class_247.field_1366);
        shape = class_259.method_1072((class_265)shape, (class_265)class_259.method_1081((double)0.125, (double)0.0, (double)0.25, (double)0.875, (double)0.375, (double)0.8125), (class_247)class_247.field_1366);
        shape = class_259.method_1072((class_265)shape, (class_265)class_259.method_1081((double)0.125, (double)0.375, (double)0.25, (double)0.875, (double)0.5, (double)0.875), (class_247)class_247.field_1366);
        shape = class_259.method_1072((class_265)shape, (class_265)class_259.method_1081((double)0.125, (double)0.4375, (double)0.125, (double)0.875, (double)1.0, (double)0.1875), (class_247)class_247.field_1366);
        return shape;
    };
    public static final Map<class_2350, class_265> BOTTOM_SHAPE = (Map)class_156.method_654(new HashMap(), map -> {
        for (class_2350 direction : class_2350.class_2353.field_11062) {
            map.put(direction, BeachpartyUtil.rotateShape(class_2350.field_11035, direction, bottomShapeSupplier.get()));
        }
    });

    public HoodedBeachChair(class_4970.class_2251 settings) {
        super(settings);
        this.method_9590((class_2680)((class_2680)((class_2680)((class_2680)this.field_10647.method_11664()).method_11657(HALF, (Comparable)class_2756.field_12607)).method_11657((class_2769)FACING, (Comparable)class_2350.field_11043)).method_11657((class_2769)TYPE, (Comparable)((Object)BeachpartyUtil.LineConnectingType.NONE)));
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(new class_2769[]{HALF});
    }

    @Override
    @NotNull
    public class_2680 method_9605(class_1750 context) {
        return (class_2680)((class_2680)this.method_9564().method_11657(HALF, (Comparable)class_2756.field_12607)).method_11657((class_2769)FACING, (Comparable)context.method_8042().method_10153());
    }

    public void method_9567(class_1937 world, class_2338 pos, class_2680 state, class_1309 placer, class_1799 itemStack) {
        class_2338 upperPos = pos.method_10084();
        class_2680 upperState = (class_2680)state.method_11657(HALF, (Comparable)class_2756.field_12609);
        world.method_8652(upperPos, upperState, 3);
        this.updateTypeProperty(world, pos, state);
        this.updateTypeProperty(world, upperPos, upperState);
    }

    public void method_9536(class_2680 state, class_1937 world, class_2338 pos, class_2680 newState, boolean moved) {
        class_2756 half;
        class_2338 otherPos;
        class_2680 otherState;
        if (!moved && state.method_26204() != newState.method_26204() && (otherState = world.method_8320(otherPos = (half = (class_2756)state.method_11654(HALF)) == class_2756.field_12607 ? pos.method_10084() : pos.method_10074())).method_26204() == this && otherState.method_11654(HALF) != half) {
            world.method_8652(otherPos, class_2246.field_10124.method_9564(), 35);
        }
        super.method_9536(state, world, pos, newState, moved);
    }

    @NotNull
    protected class_9062 method_55765(class_1799 itemStack, class_2680 blockState, class_1937 level, class_2338 blockPos, class_1657 player, class_1268 interactionHand, class_3965 blockHitResult) {
        class_2756 half = (class_2756)blockState.method_11654(HALF);
        class_2338 basePos = half == class_2756.field_12607 ? blockPos : blockPos.method_10074();
        return BeachpartyUtil.onUse(level, player, interactionHand, new class_3965(blockHitResult.method_17784(), blockHitResult.method_17780(), basePos, blockHitResult.method_17781()), 0.2);
    }

    public long method_9535(class_2680 state, class_2338 pos) {
        class_2338 basePos = state.method_11654(HALF) == class_2756.field_12607 ? pos : pos.method_10074();
        return basePos.method_10063();
    }

    @Override
    @NotNull
    public class_2680 method_9598(class_2680 state, class_2470 rotation) {
        return (class_2680)state.method_11657((class_2769)FACING, (Comparable)rotation.method_10503((class_2350)state.method_11654((class_2769)FACING)));
    }

    @Override
    @NotNull
    public class_2680 method_9569(class_2680 state, class_2415 mirror) {
        return state.method_26186(mirror.method_10345((class_2350)state.method_11654((class_2769)FACING)));
    }

    @Override
    public void method_9612(class_2680 state, class_1937 world, class_2338 pos, class_2248 sourceBlock, class_2338 sourcePos, boolean notify) {
        if (world.field_9236) {
            return;
        }
        class_2756 half = (class_2756)state.method_11654(HALF);
        class_2338 basePos = half == class_2756.field_12607 ? pos : pos.method_10074();
        class_2680 baseState = world.method_8320(basePos);
        this.updateTypeProperty(world, basePos, baseState);
        class_2338 otherPos = basePos.method_10084();
        class_2680 otherState = world.method_8320(otherPos);
        if (otherState.method_26204() == this) {
            world.method_8652(otherPos, (class_2680)otherState.method_11657((class_2769)TYPE, (Comparable)((Object)((BeachpartyUtil.LineConnectingType)((Object)baseState.method_11654((class_2769)TYPE))))), 3);
        }
    }

    private void updateTypeProperty(class_1937 world, class_2338 pos, class_2680 state) {
        class_2350 facing = (class_2350)state.method_11654((class_2769)FACING);
        BeachpartyUtil.LineConnectingType type = this.getType(state, world, pos, facing);
        if (state.method_11654((class_2769)TYPE) != type) {
            world.method_8652(pos, (class_2680)state.method_11657((class_2769)TYPE, (Comparable)((Object)type)), 3);
        }
    }

    private BeachpartyUtil.LineConnectingType getType(class_2680 state, class_1937 world, class_2338 pos, class_2350 facing) {
        class_2338 leftPos;
        class_2756 half = (class_2756)state.method_11654(HALF);
        class_2338 rightPos = switch (facing) {
            case class_2350.field_11034 -> {
                leftPos = pos.method_10093(class_2350.field_11035);
                yield pos.method_10093(class_2350.field_11043);
            }
            case class_2350.field_11035 -> {
                leftPos = pos.method_10093(class_2350.field_11034);
                yield pos.method_10093(class_2350.field_11039);
            }
            case class_2350.field_11039 -> {
                leftPos = pos.method_10093(class_2350.field_11043);
                yield pos.method_10093(class_2350.field_11035);
            }
            default -> {
                leftPos = pos.method_10093(class_2350.field_11039);
                yield pos.method_10093(class_2350.field_11034);
            }
        };
        if (half == class_2756.field_12609) {
            leftPos = leftPos.method_10084();
            rightPos = rightPos.method_10084();
        }
        class_2680 leftState = world.method_8320(leftPos);
        class_2680 rightState = world.method_8320(rightPos);
        return this.determineType(state, leftState, rightState);
    }

    private BeachpartyUtil.LineConnectingType determineType(class_2680 state, class_2680 leftState, class_2680 rightState) {
        boolean connectLeft = this.isConnectable(state, leftState);
        boolean connectRight = this.isConnectable(state, rightState);
        if (connectLeft && connectRight) {
            return BeachpartyUtil.LineConnectingType.MIDDLE;
        }
        if (connectLeft) {
            return BeachpartyUtil.LineConnectingType.RIGHT;
        }
        if (connectRight) {
            return BeachpartyUtil.LineConnectingType.LEFT;
        }
        return BeachpartyUtil.LineConnectingType.NONE;
    }

    @Override
    protected boolean isConnectable(class_2680 selfState, class_2680 otherState) {
        if (otherState.method_26204() != this) {
            return false;
        }
        return selfState.method_11654((class_2769)FACING) == otherState.method_11654((class_2769)FACING) && selfState.method_11654(HALF) == otherState.method_11654(HALF);
    }

    public void method_9585(class_1936 world, class_2338 pos, class_2680 state) {
        class_2756 half = (class_2756)state.method_11654(HALF);
        class_2338 otherPos = half == class_2756.field_12607 ? pos.method_10084() : pos.method_10074();
        class_2680 otherState = world.method_8320(otherPos);
        if (otherState.method_26204() == this && otherState.method_11654(HALF) != half) {
            world.method_22352(otherPos, false);
        }
        if (half == class_2756.field_12609 && world instanceof class_1937) {
            class_1937 level = (class_1937)world;
            class_2248.method_9577((class_1937)level, (class_2338)pos, (class_1799)new class_1799((class_1935)this.method_8389()));
        }
        super.method_9585(world, pos, state);
    }

    @NotNull
    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        class_2350 direction = (class_2350)state.method_11654((class_2769)FACING);
        class_2756 half = (class_2756)state.method_11654(HALF);
        BeachpartyUtil.LineConnectingType type = (BeachpartyUtil.LineConnectingType)((Object)state.method_11654((class_2769)TYPE));
        if (half == class_2756.field_12609) {
            return switch (type) {
                case BeachpartyUtil.LineConnectingType.RIGHT -> TOP_RIGHT_SHAPE.get(direction);
                case BeachpartyUtil.LineConnectingType.LEFT -> TOP_LEFT_SHAPE.get(direction);
                case BeachpartyUtil.LineConnectingType.MIDDLE -> TOP_MIDDLE_SHAPE.get(direction);
                default -> TOP_SHAPE.get(direction);
            };
        }
        return switch (type) {
            case BeachpartyUtil.LineConnectingType.RIGHT -> BOTTOM_RIGHT_SHAPE.get(direction);
            case BeachpartyUtil.LineConnectingType.LEFT -> BOTTOM_LEFT_SHAPE.get(direction);
            case BeachpartyUtil.LineConnectingType.MIDDLE -> BOTTOM_MIDDLE_SHAPE.get(direction);
            default -> BOTTOM_SHAPE.get(direction);
        };
    }
}

