/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.beachparty.core.block;

import com.mojang.serialization.MapCodec;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1844;
import net.minecraft.class_1847;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2383;
import net.minecraft.class_2388;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2746;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5819;
import net.minecraft.class_8805;
import net.minecraft.class_8812;
import net.minecraft.class_9062;
import net.minecraft.class_9334;
import net.satisfy.beachparty.core.registry.ObjectRegistry;
import net.satisfy.beachparty.core.util.BeachpartyUtil;
import net.satisfy.beachparty.core.util.SandCastleManager;
import org.jetbrains.annotations.NotNull;

public class SandBucketBlock
extends class_2383 {
    private static final Supplier<class_265> voxelShapeSupplier = () -> SandBucketBlock.method_9541((double)4.0, (double)0.0, (double)6.0, (double)10.0, (double)8.0, (double)12.0);
    public static final Map<class_2350, class_265> SHAPE = (Map)class_156.method_654(new HashMap(), map -> {
        for (class_2350 direction : class_2350.class_2353.field_11062.method_29716().toList()) {
            map.put(direction, BeachpartyUtil.rotateShape(class_2350.field_11043, direction, voxelShapeSupplier.get()));
        }
    });
    public static final MapCodec<SandBucketBlock> CODEC = SandBucketBlock.method_54094(SandBucketBlock::new);

    public SandBucketBlock(class_4970.class_2251 settings) {
        super(settings);
    }

    @NotNull
    protected MapCodec<? extends class_2383> method_53969() {
        return CODEC;
    }

    @NotNull
    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return SHAPE.get(state.method_11654((class_2769)field_11177));
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{field_11177});
    }

    @NotNull
    protected class_9062 method_55765(class_1799 itemStack, class_2680 blockState, class_1937 level, class_2338 blockPos, class_1657 player, class_1268 interactionHand, class_3965 blockHitResult) {
        class_2248 emptySandBucketBlock = (class_2248)ObjectRegistry.SAND_BUCKET_BLOCK_EMPTY.get();
        class_2248 sandBucketBlock = (class_2248)ObjectRegistry.SAND_BUCKET_BLOCK_FILLED.get();
        if (blockState.method_26204() == emptySandBucketBlock && itemStack.method_7909() == class_1802.field_8858) {
            itemStack.method_7934(1);
            level.method_8501(blockPos, (class_2680)sandBucketBlock.method_9564().method_11657((class_2769)field_11177, (Comparable)((class_2350)blockState.method_11654((class_2769)field_11177))));
            return class_9062.field_47728;
        }
        return super.method_55765(itemStack, blockState, level, blockPos, player, interactionHand, blockHitResult);
    }

    public void method_9567(class_1937 world, class_2338 pos, class_2680 state, class_1309 placer, class_1799 itemStack) {
        SandCastleManager.registerSandCastle(pos);
        super.method_9567(world, pos, state, placer, itemStack);
    }

    public void method_9536(class_2680 state, class_1937 world, class_2338 pos, class_2680 newState, boolean isMoving) {
        SandCastleManager.unregisterSandCastle(pos);
        super.method_9536(state, world, pos, newState, isMoving);
    }

    public static class SandPileBlock
    extends class_8812 {
        private static final class_265 SHAPE = class_2248.method_9541((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)3.0, (double)14.0);

        public SandPileBlock(class_8805 colorRGBA, class_4970.class_2251 settings) {
            super(colorRGBA, settings);
        }

        @NotNull
        public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
            return SHAPE;
        }

        public void method_9548(class_2680 state, class_1937 world, class_2338 pos, class_1297 entity) {
            if (entity instanceof class_1309 && entity.method_5864() != class_1299.field_6113) {
                entity.method_5844(state, new class_243(0.8, 0.75, 0.8));
            }
        }
    }

    public static class SandCastleBlock
    extends class_2248 {
        public static final class_2746 TALL_TOWER;
        public static final class_265 TALL_TOWER_SHAPE;
        public static final class_2746 RIGHT_TOWER;
        public static final class_265 RIGHT_TOWER_SHAPE;
        public static final class_2746 TOP_TOWER;
        public static final class_265 TOP_TOWER_SHAPE;
        public static final class_2746 LEFT_TOWER;
        public static final class_265 LEFT_TOWER_SHAPE;
        public static final class_2746 PETRIFIED;
        private static final class_265 BASE_SHAPE;

        public SandCastleBlock(class_4970.class_2251 settings) {
            super(settings.method_9640());
            this.method_9590((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)this.field_10647.method_11664()).method_11657((class_2769)TALL_TOWER, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)RIGHT_TOWER, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)TOP_TOWER, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)LEFT_TOWER, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)PETRIFIED, (Comparable)Boolean.valueOf(false)));
        }

        @NotNull
        public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
            class_265 shape = class_259.method_17786((class_265)BASE_SHAPE, (class_265[])new class_265[0]);
            if (((Boolean)state.method_11654((class_2769)TALL_TOWER)).booleanValue()) {
                shape = class_259.method_1084((class_265)shape, (class_265)TALL_TOWER_SHAPE);
            }
            if (((Boolean)state.method_11654((class_2769)RIGHT_TOWER)).booleanValue()) {
                shape = class_259.method_1084((class_265)shape, (class_265)RIGHT_TOWER_SHAPE);
            }
            if (((Boolean)state.method_11654((class_2769)LEFT_TOWER)).booleanValue()) {
                shape = class_259.method_1084((class_265)shape, (class_265)LEFT_TOWER_SHAPE);
            }
            if (((Boolean)state.method_11654((class_2769)TOP_TOWER)).booleanValue()) {
                shape = class_259.method_1084((class_265)shape, (class_265)TOP_TOWER_SHAPE);
            }
            return shape;
        }

        @NotNull
        protected class_9062 method_55765(class_1799 handStack, class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
            if (((class_1844)handStack.method_57825(class_9334.field_49651, (Object)class_1844.field_49274)).method_57401(class_1847.field_8991) && !((Boolean)state.method_11654((class_2769)PETRIFIED)).booleanValue()) {
                if (!player.method_31549().field_7477) {
                    handStack.method_7934(1);
                }
                world.method_8501(pos, (class_2680)state.method_11657((class_2769)PETRIFIED, (Comparable)Boolean.valueOf(true)));
                if (world.field_9236) {
                    int i;
                    class_2680 smoothSandState = class_2246.field_10467.method_9564();
                    for (i = 0; i < 8; ++i) {
                        world.method_8406((class_2394)new class_2388(class_2398.field_11217, smoothSandState), (double)pos.method_10263() + 0.5 + (world.field_9229.method_43058() - 0.5) * 0.5, (double)pos.method_10264() + 1.0, (double)pos.method_10260() + 0.5 + (world.field_9229.method_43058() - 0.5) * 0.5, 0.0, 0.1, 0.0);
                    }
                    for (i = 0; i < 6; ++i) {
                        world.method_8406((class_2394)class_2398.field_11202, (double)pos.method_10263() + 0.5 + (world.field_9229.method_43058() - 0.5) * 0.5, (double)pos.method_10264() + 1.0, (double)pos.method_10260() + 0.5 + (world.field_9229.method_43058() - 0.5) * 0.5, 0.0, 0.1, 0.0);
                    }
                }
                return class_9062.method_55644((boolean)world.field_9236);
            }
            if (handStack.method_7909() == ObjectRegistry.SAND_BUCKET_FILLED.get() && !this.hasAllTowers(state)) {
                class_2746 tower = this.getTowerHitPos(hit);
                if (!((Boolean)state.method_11654((class_2769)tower)).booleanValue()) {
                    world.method_8501(pos, (class_2680)state.method_11657((class_2769)tower, (Comparable)Boolean.valueOf(true)));
                    this.exchangeStack(handStack, player, new class_1799((class_1935)ObjectRegistry.SAND_BUCKET_EMPTY.get()));
                    if (world.field_9236) {
                        for (int i = 0; i < 8; ++i) {
                            world.method_8406((class_2394)new class_2388(class_2398.field_11217, class_2246.field_10102.method_9564()), (double)pos.method_10263() + 0.5 + (world.field_9229.method_43058() - 0.5) * 0.5, (double)pos.method_10264() + 1.0, (double)pos.method_10260() + 0.5 + (world.field_9229.method_43058() - 0.5) * 0.5, 0.0, 0.1, 0.0);
                        }
                        world.method_8486((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), class_3417.field_15144, class_3419.field_15245, 1.0f, 1.0f, false);
                    }
                    return class_9062.method_55644((boolean)world.field_9236);
                }
            } else if (handStack.method_7909() == ObjectRegistry.SAND_BUCKET_EMPTY.get()) {
                if (this.hasNoTowers(state)) {
                    world.method_22352(pos, false);
                    this.exchangeStack(handStack, player, new class_1799((class_1935)ObjectRegistry.SAND_BUCKET_FILLED.get()));
                    if (world.field_9236) {
                        for (int i = 0; i < 6; ++i) {
                            world.method_8406((class_2394)new class_2388(class_2398.field_11217, class_2246.field_10102.method_9564()), (double)pos.method_10263() + 0.5 + (world.field_9229.method_43058() - 0.5) * 0.5, (double)pos.method_10264() + 1.0, (double)pos.method_10260() + 0.5 + (world.field_9229.method_43058() - 0.5) * 0.5, 0.0, 0.1, 0.0);
                        }
                        world.method_8486((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), class_3417.field_15074, class_3419.field_15245, 1.0f, 1.0f, false);
                    }
                    return class_9062.method_55644((boolean)world.field_9236);
                }
                class_2746 tower = this.getTowerHitPos(hit);
                if (((Boolean)state.method_11654((class_2769)tower)).booleanValue()) {
                    world.method_8501(pos, (class_2680)state.method_11657((class_2769)tower, (Comparable)Boolean.valueOf(false)));
                    this.exchangeStack(handStack, player, new class_1799((class_1935)ObjectRegistry.SAND_BUCKET_FILLED.get()));
                    if (world.field_9236) {
                        for (int i = 0; i < 6; ++i) {
                            world.method_8406((class_2394)new class_2388(class_2398.field_11217, class_2246.field_10102.method_9564()), (double)pos.method_10263() + 0.5 + (world.field_9229.method_43058() - 0.5) * 0.5, (double)pos.method_10264() + 1.0, (double)pos.method_10260() + 0.5 + (world.field_9229.method_43058() - 0.5) * 0.5, 0.0, 0.1, 0.0);
                        }
                        world.method_8486((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), class_3417.field_15074, class_3419.field_15245, 1.0f, 1.0f, false);
                    }
                    return class_9062.method_55644((boolean)world.field_9236);
                }
            }
            return class_9062.field_47731;
        }

        public void method_9591(class_1937 world, class_2338 pos, class_2680 state, class_1297 entity) {
            if (!((Boolean)state.method_11654((class_2769)PETRIFIED)).booleanValue()) {
                world.method_8501(pos, ((class_2248)ObjectRegistry.SAND_PILE.get()).method_9564());
            } else if (entity.method_5864() == class_1299.field_6051) {
                world.method_22352(pos, true);
            }
        }

        public void method_9588(class_2680 state, class_3218 world, class_2338 pos, class_5819 random) {
            if (!((Boolean)state.method_11654((class_2769)PETRIFIED)).booleanValue() && (world.method_8520(pos) || world.method_8520(pos.method_10084()))) {
                world.method_8501(pos, ((class_2248)ObjectRegistry.SAND_PILE.get()).method_9564());
                return;
            }
            if (!state.method_26184((class_4538)world, pos)) {
                world.method_22352(pos, true);
            }
        }

        private void exchangeStack(class_1799 handStack, class_1657 player, class_1799 possibleReturnStack) {
            class_1799 returnStack;
            class_1799 class_17992 = returnStack = !player.method_31549().field_7477 ? possibleReturnStack : handStack;
            if (player.method_7337()) {
                if (!player.method_31548().method_7379(returnStack)) {
                    player.method_31548().method_7394(returnStack);
                }
                return;
            }
            class_1661 inventory = player.method_31548();
            int slot = inventory.method_7395(handStack);
            handStack.method_7934(1);
            if (player.method_31548().method_5438(slot).method_7960()) {
                if (!inventory.method_7367(slot, returnStack)) {
                    player.method_7328(returnStack, false);
                }
            } else if (!inventory.method_7394(returnStack)) {
                player.method_7328(returnStack, false);
            }
        }

        private class_2746 getTowerHitPos(class_3965 hitResult) {
            double x = hitResult.method_17784().method_10216();
            double z = hitResult.method_17784().method_10215();
            double relX = x - (double)hitResult.method_17777().method_10263();
            double relZ = z - (double)hitResult.method_17777().method_10260();
            if (relX >= 0.5 && relZ >= 0.5) {
                return TALL_TOWER;
            }
            if (relX < 0.5 && relZ >= 0.5) {
                return RIGHT_TOWER;
            }
            if (relX >= 0.5 && relZ < 0.5) {
                return LEFT_TOWER;
            }
            return TOP_TOWER;
        }

        private boolean hasAllTowers(class_2680 state) {
            return (Boolean)state.method_11654((class_2769)TALL_TOWER) != false && (Boolean)state.method_11654((class_2769)RIGHT_TOWER) != false && (Boolean)state.method_11654((class_2769)TOP_TOWER) != false && (Boolean)state.method_11654((class_2769)LEFT_TOWER) != false;
        }

        private boolean hasNoTowers(class_2680 state) {
            return (Boolean)state.method_11654((class_2769)TALL_TOWER) == false && (Boolean)state.method_11654((class_2769)RIGHT_TOWER) == false && (Boolean)state.method_11654((class_2769)TOP_TOWER) == false && (Boolean)state.method_11654((class_2769)LEFT_TOWER) == false;
        }

        @NotNull
        public class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 neighborState, class_1936 world, class_2338 pos, class_2338 neighborPos) {
            if (!state.method_26184((class_4538)world, pos)) {
                world.method_39279(pos, (class_2248)this, 1);
            }
            return super.method_9559(state, direction, neighborState, world, pos, neighborPos);
        }

        public boolean method_9558(class_2680 state, class_4538 world, class_2338 pos) {
            class_2338 blockPos = pos.method_10074();
            return world.method_8320(blockPos).method_26206((class_1922)world, blockPos, class_2350.field_11036);
        }

        @NotNull
        public class_1799 method_9574(class_4538 levelReader, class_2338 blockPos, class_2680 blockState) {
            return new class_1799((class_1935)ObjectRegistry.SAND_BUCKET_FILLED.get());
        }

        protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
            builder.method_11667(new class_2769[]{TALL_TOWER, RIGHT_TOWER, TOP_TOWER, LEFT_TOWER, PETRIFIED});
        }

        static {
            TALL_TOWER_SHAPE = class_2248.method_9541((double)11.0, (double)0.0, (double)11.0, (double)15.0, (double)15.0, (double)15.0);
            RIGHT_TOWER_SHAPE = class_2248.method_9541((double)1.0, (double)1.0, (double)11.0, (double)5.0, (double)12.0, (double)15.0);
            TOP_TOWER_SHAPE = class_2248.method_9541((double)5.0, (double)6.0, (double)5.0, (double)11.0, (double)9.0, (double)11.0);
            LEFT_TOWER_SHAPE = class_2248.method_9541((double)11.0, (double)1.0, (double)1.0, (double)15.0, (double)12.0, (double)5.0);
            BASE_SHAPE = class_259.method_1084((class_265)class_2248.method_9541((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)1.0, (double)15.0), (class_265)class_2248.method_9541((double)2.0, (double)1.0, (double)2.0, (double)14.0, (double)6.0, (double)14.0));
            TALL_TOWER = class_2746.method_11825((String)"tall");
            RIGHT_TOWER = class_2746.method_11825((String)"right");
            TOP_TOWER = class_2746.method_11825((String)"top");
            LEFT_TOWER = class_2746.method_11825((String)"left");
            PETRIFIED = class_2746.method_11825((String)"petrified");
        }
    }
}

