/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.beachparty.core.block.entity;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1671;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_247;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_5819;
import net.minecraft.class_7225;
import net.minecraft.class_9283;
import net.minecraft.class_9284;
import net.minecraft.class_9334;
import net.satisfy.beachparty.core.block.BeachGoalBlock;
import net.satisfy.beachparty.core.entity.BeachBallEntity;
import net.satisfy.beachparty.core.registry.EntityTypeRegistry;

public class BeachGoalBlockEntity
extends class_2586 {
    private static final int PRESENCE_THRESHOLD = 10;
    private boolean hasBeachBall = false;
    private int ballPresenceCounter = 0;
    private static final int[] FW_PALETTE = new int[]{0xFF0000, 16753920, 0xFFFF00, 65280, 65535, 255, 9055202, 0xFF00FF, 0xFFFFFF, 11393254, 16032864, 16744272, 0x7FFF00, 16766720};

    public BeachGoalBlockEntity(class_2338 pos, class_2680 state) {
        super((class_2591)EntityTypeRegistry.BEACH_GOAL_BLOCK_ENTITY.get(), pos, state);
    }

    public static void tick(class_1937 level, class_2338 pos, class_2680 state, BeachGoalBlockEntity blockEntity) {
        if (!(level instanceof class_3218)) {
            return;
        }
        class_3218 serverLevel = (class_3218)level;
        BeachGoalBlock block = (BeachGoalBlock)state.method_26204();
        class_265 detectionShape = block.getDetectionShape(state);
        class_265 worldShape = detectionShape.method_1096((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260());
        class_238 detectionAABB = worldShape.method_1107();
        List balls = serverLevel.method_8390(BeachBallEntity.class, detectionAABB.method_1014(0.1), class_1297::method_5805);
        boolean detected = false;
        for (BeachBallEntity ball : balls) {
            class_265 ballShape = class_259.method_1078((class_238)ball.method_5829());
            if (!class_259.method_1074((class_265)worldShape, (class_265)ballShape, (class_247)class_247.field_16896)) continue;
            detected = true;
            break;
        }
        blockEntity.ballPresenceCounter = detected ? Math.min(blockEntity.ballPresenceCounter + 1, 10) : Math.max(blockEntity.ballPresenceCounter - 1, 0);
        boolean previouslyHadBall = blockEntity.hasBeachBall;
        boolean bl = blockEntity.hasBeachBall = blockEntity.ballPresenceCounter >= 10;
        if (blockEntity.hasBeachBall && !previouslyHadBall) {
            blockEntity.fireRockets(serverLevel, pos);
            level.method_8452(pos, state.method_26204());
        } else if (!blockEntity.hasBeachBall && previouslyHadBall) {
            level.method_8452(pos, state.method_26204());
        }
    }

    public boolean hasBeachBall() {
        return this.hasBeachBall;
    }

    private void fireRockets(class_3218 world, class_2338 pos) {
        int rocketCount = 3 + world.field_9229.method_43048(3);
        for (int i = 0; i < rocketCount; ++i) {
            double dx = (world.field_9229.method_43058() - 0.5) * 0.18;
            double dz = (world.field_9229.method_43058() - 0.5) * 0.18;
            double dy = 1.15 + world.field_9229.method_43058() * 0.25;
            double x = (double)pos.method_10263() + 0.5;
            double y = (double)pos.method_10264() + 2.0;
            double z = (double)pos.method_10260() + 0.5;
            int flight = 1 + world.field_9229.method_43048(3);
            int explosions = 1 + world.field_9229.method_43048(3);
            class_1799 fireworkItem = new class_1799((class_1935)class_1802.field_8639);
            ArrayList<class_9283> list = new ArrayList<class_9283>(explosions);
            for (int e = 0; e < explosions; ++e) {
                list.add(this.randomExplosion(world.field_9229));
            }
            fireworkItem.method_57379(class_9334.field_49616, (Object)new class_9284(flight, list));
            class_1671 rocket = new class_1671((class_1937)world, fireworkItem, x, y, z, false);
            rocket.method_18800(dx, dy, dz);
            world.method_8649((class_1297)rocket);
        }
    }

    private class_9283 randomExplosion(class_5819 random) {
        class_9283.class_1782[] shapes = class_9283.class_1782.values();
        class_9283.class_1782 shape = shapes[random.method_43048(shapes.length)];
        IntList colors = this.randomPaletteColors(random, 1, 4);
        IntList fade = this.randomPaletteColors(random, 0, 3);
        boolean trail = random.method_43056();
        boolean twinkle = random.method_43056();
        return new class_9283(shape, colors, fade, trail, twinkle);
    }

    private IntList randomPaletteColors(class_5819 random, int min, int maxInclusive) {
        int n = min + random.method_43048(maxInclusive - min + 1);
        IntArrayList out = new IntArrayList(n);
        for (int i = 0; i < n; ++i) {
            out.add(FW_PALETTE[random.method_43048(FW_PALETTE.length)]);
        }
        return out;
    }

    public void method_11007(class_2487 compoundTag, class_7225.class_7874 provider) {
        super.method_11007(compoundTag, provider);
        compoundTag.method_10556("HasBeachBall", this.hasBeachBall);
        compoundTag.method_10569("BallPresenceCounter", this.ballPresenceCounter);
    }

    protected void method_11014(class_2487 compoundTag, class_7225.class_7874 provider) {
        super.method_11014(compoundTag, provider);
        this.hasBeachBall = compoundTag.method_10577("HasBeachBall");
        this.ballPresenceCounter = compoundTag.method_10550("BallPresenceCounter");
    }
}

