/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.beachparty.core.block.entity;

import java.util.List;
import java.util.Optional;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3908;
import net.minecraft.class_3913;
import net.minecraft.class_3956;
import net.minecraft.class_5455;
import net.minecraft.class_5558;
import net.minecraft.class_7225;
import net.minecraft.class_8786;
import net.satisfy.beachparty.client.gui.handler.MiniFridgeGuiHandler;
import net.satisfy.beachparty.core.recipe.MiniFridgeRecipe;
import net.satisfy.beachparty.core.registry.EntityTypeRegistry;
import net.satisfy.beachparty.core.registry.ObjectRegistry;
import net.satisfy.beachparty.core.registry.RecipeTypeRegistry;
import net.satisfy.beachparty.core.world.ImplementedInventory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MiniFridgeBlockEntity
extends class_2586
implements ImplementedInventory,
class_5558<MiniFridgeBlockEntity>,
class_3908 {
    public static final int CAPACITY = 2;
    private static final int[] SLOTS_FOR_INPUT = new int[]{1};
    private static final int[] SLOTS_FOR_OUTPUT = new int[]{0};
    private static final int OUTPUT_SLOT = 0;
    private static final int INPUT_SLOT = 1;
    protected float experience;
    private class_2371<class_1799> inventory;
    private int fermentationTime = 0;
    private int totalFermentationTime;
    private final class_3913 propertyDelegate = new class_3913(){

        public int method_17390(int index) {
            return switch (index) {
                case 0 -> MiniFridgeBlockEntity.this.fermentationTime;
                case 1 -> MiniFridgeBlockEntity.this.totalFermentationTime;
                default -> 0;
            };
        }

        public void method_17391(int index, int value) {
            switch (index) {
                case 0: {
                    MiniFridgeBlockEntity.this.fermentationTime = value;
                    break;
                }
                case 1: {
                    MiniFridgeBlockEntity.this.totalFermentationTime = value;
                }
            }
        }

        public int method_17389() {
            return 2;
        }
    };

    public MiniFridgeBlockEntity(class_2338 pos, class_2680 state) {
        super((class_2591)EntityTypeRegistry.MINI_FRIDGE_BLOCK_ENTITY.get(), pos, state);
        this.inventory = class_2371.method_10213((int)2, (Object)class_1799.field_8037);
    }

    protected void method_11014(class_2487 nbt, class_7225.class_7874 provider) {
        super.method_11014(nbt, provider);
        this.inventory = class_2371.method_10213((int)this.method_5439(), (Object)class_1799.field_8037);
        class_1262.method_5429((class_2487)nbt, this.inventory, (class_7225.class_7874)provider);
        this.fermentationTime = nbt.method_10550("FermentationTime");
        this.totalFermentationTime = nbt.method_10550("TotalFermentationTime");
        this.experience = nbt.method_10583("Experience");
    }

    protected void method_11007(class_2487 compoundTag, class_7225.class_7874 provider) {
        super.method_11007(compoundTag, provider);
        class_1262.method_5426((class_2487)compoundTag, this.inventory, (class_7225.class_7874)provider);
        compoundTag.method_10569("FermentationTime", this.fermentationTime);
        compoundTag.method_10569("TotalFermentationTime", this.totalFermentationTime);
        compoundTag.method_10548("Experience", this.experience);
    }

    public void tick(class_1937 world, class_2338 pos, class_2680 state, MiniFridgeBlockEntity blockEntity) {
        if (world.field_9236) {
            return;
        }
        boolean dirty = false;
        List recipes = world.method_8433().method_30027((class_3956)RecipeTypeRegistry.MINI_FRIDGE_RECIPE_TYPE.get());
        Optional<MiniFridgeRecipe> recipeType = Optional.ofNullable(this.getRecipe(recipes, this.inventory));
        assert (this.field_11863 != null);
        class_5455 access = this.field_11863.method_30349();
        if (recipeType.isPresent() && this.canCraft(recipeType.get(), access)) {
            if (this.fermentationTime == 0) {
                this.totalFermentationTime = recipeType.get().getCraftingTime();
            }
            ++this.fermentationTime;
            if (this.fermentationTime >= this.totalFermentationTime) {
                this.fermentationTime = 0;
                this.craft(recipeType.get(), access);
                dirty = true;
            }
        } else {
            this.fermentationTime = 0;
        }
        if (dirty) {
            this.method_5431();
        }
    }

    private boolean canCraft(MiniFridgeRecipe recipe, class_5455 access) {
        if (recipe == null || recipe.method_8110((class_7225.class_7874)access).method_7960()) {
            return false;
        }
        class_1799 inputStack = this.method_5438(1);
        class_1799 outputStack = this.method_5438(0);
        return !inputStack.method_7960() && (outputStack.method_7960() || outputStack == recipe.method_8110((class_7225.class_7874)access));
    }

    private void craft(MiniFridgeRecipe recipe, class_5455 access) {
        if (!this.canCraft(recipe, access)) {
            return;
        }
        class_1799 recipeOutput = recipe.method_8110((class_7225.class_7874)access);
        class_1799 outputSlotStack = this.method_5438(0);
        if (outputSlotStack.method_7960()) {
            this.method_5447(0, recipeOutput.method_7972());
        }
        class_1799 inputStack = this.method_5438(1);
        inputStack.method_7934(1);
        this.method_5447(1, inputStack.method_7960() ? class_1799.field_8037 : inputStack);
    }

    @Override
    public class_2371<class_1799> getItems() {
        return this.inventory;
    }

    @Override
    public int @NotNull [] method_5494(class_2350 side) {
        if (side == class_2350.field_11033) {
            return SLOTS_FOR_OUTPUT;
        }
        return SLOTS_FOR_INPUT;
    }

    @Override
    public void method_5447(int slot, class_1799 stack) {
        this.inventory.set(slot, (Object)stack);
        if (slot == 1) {
            this.totalFermentationTime = 50;
            this.fermentationTime = 0;
            this.method_5431();
        }
    }

    @Override
    public boolean method_5492(int slot, class_1799 stack, @Nullable class_2350 dir) {
        return slot == 1;
    }

    @Override
    public boolean method_5493(int slot, class_1799 stack, class_2350 dir) {
        return slot == 0;
    }

    @Override
    public boolean method_5443(class_1657 player) {
        assert (this.field_11863 != null);
        return this.field_11863.method_8321(this.field_11867) == this && player.method_5649((double)this.field_11867.method_10263() + 0.5, (double)this.field_11867.method_10264() + 0.5, (double)this.field_11867.method_10260() + 0.5) <= 64.0;
    }

    @NotNull
    public class_2561 method_5476() {
        return ((class_2248)ObjectRegistry.MINI_FRIDGE.get()).method_9518();
    }

    @Nullable
    public class_1703 createMenu(int syncId, class_1661 inv, class_1657 player) {
        return new MiniFridgeGuiHandler(syncId, inv, (class_1263)this, this.propertyDelegate);
    }

    private MiniFridgeRecipe getRecipe(List<class_8786<MiniFridgeRecipe>> recipes, class_2371<class_1799> inventory) {
        block0: for (class_8786<MiniFridgeRecipe> recipeHolder : recipes) {
            MiniFridgeRecipe recipe = (MiniFridgeRecipe)recipeHolder.comp_1933();
            for (class_1856 ingredient : recipe.method_8117()) {
                boolean ingredientFound = false;
                for (int slotIndex = 1; slotIndex < inventory.size(); ++slotIndex) {
                    class_1799 slotItem = (class_1799)inventory.get(slotIndex);
                    if (!ingredient.method_8093(slotItem)) continue;
                    ingredientFound = true;
                    break;
                }
                if (ingredientFound) continue;
                continue block0;
            }
            return recipe;
        }
        return null;
    }
}

