/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.beachparty.core.block.entity;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1278;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3908;
import net.minecraft.class_3913;
import net.minecraft.class_3956;
import net.minecraft.class_5455;
import net.minecraft.class_7225;
import net.minecraft.class_8786;
import net.satisfy.beachparty.client.gui.handler.PalmBarGuiHandler;
import net.satisfy.beachparty.core.recipe.PalmBarRecipe;
import net.satisfy.beachparty.core.registry.EntityTypeRegistry;
import net.satisfy.beachparty.core.registry.ObjectRegistry;
import net.satisfy.beachparty.core.registry.RecipeTypeRegistry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PalmBarBlockEntity
extends class_2586
implements class_1278,
class_3908 {
    public static final int CAPACITY = 5;
    private static final int[] SLOTS_FOR_SIDE = new int[]{2, 3, 4};
    private static final int[] SLOTS_FOR_UP = new int[]{1};
    private static final int[] SLOTS_FOR_DOWN = new int[]{0};
    private static final int OUTPUT_SLOT = 0;
    protected float experience;
    private class_2371<class_1799> inventory;
    private int shakingTime = 0;
    private int totalShakingTime;
    private final class_3913 propertyDelegate = new class_3913(){

        public int method_17390(int index) {
            return switch (index) {
                case 0 -> PalmBarBlockEntity.this.shakingTime;
                case 1 -> PalmBarBlockEntity.this.totalShakingTime;
                default -> 0;
            };
        }

        public void method_17391(int index, int value) {
            switch (index) {
                case 0: {
                    PalmBarBlockEntity.this.shakingTime = value;
                    break;
                }
                case 1: {
                    PalmBarBlockEntity.this.totalShakingTime = value;
                }
            }
        }

        public int method_17389() {
            return 2;
        }
    };

    public PalmBarBlockEntity(class_2338 pos, class_2680 state) {
        super((class_2591)EntityTypeRegistry.PALM_BAR_BLOCK_ENTITY.get(), pos, state);
        this.inventory = class_2371.method_10213((int)5, (Object)class_1799.field_8037);
    }

    public static void tick(class_1937 world, class_2338 pos, class_2680 state, PalmBarBlockEntity blockEntity) {
        if (world.field_9236) {
            return;
        }
        boolean dirty = false;
        List recipes = world.method_8433().method_30027((class_3956)RecipeTypeRegistry.PALM_BAR_RECIPE_TYPE.get());
        Optional<PalmBarRecipe> recipe = Optional.ofNullable(blockEntity.getRecipe(recipes));
        class_5455 access = world.method_30349();
        if (recipe.isPresent() && blockEntity.canCraft(recipe.get(), access)) {
            ++blockEntity.shakingTime;
            if (blockEntity.shakingTime >= blockEntity.totalShakingTime) {
                blockEntity.shakingTime = 0;
                blockEntity.craft(recipe.get(), access);
                dirty = true;
            }
        } else {
            blockEntity.shakingTime = 0;
        }
        if (dirty) {
            blockEntity.method_5431();
            world.method_8413(pos, state, state, 3);
        }
    }

    protected void method_11014(class_2487 nbt, class_7225.class_7874 provider) {
        super.method_11014(nbt, provider);
        this.inventory = class_2371.method_10213((int)this.method_5439(), (Object)class_1799.field_8037);
        class_1262.method_5429((class_2487)nbt, this.inventory, (class_7225.class_7874)provider);
        this.shakingTime = nbt.method_10568("ShakingTime");
        this.totalShakingTime = nbt.method_10568("TotalShakingTime");
        this.experience = nbt.method_10583("Experience");
    }

    protected void method_11007(class_2487 nbt, class_7225.class_7874 provider) {
        super.method_11007(nbt, provider);
        class_1262.method_5426((class_2487)nbt, this.inventory, (class_7225.class_7874)provider);
        nbt.method_10548("Experience", this.experience);
        nbt.method_10575("ShakingTime", (short)this.shakingTime);
        nbt.method_10575("TotalShakingTime", (short)this.totalShakingTime);
    }

    private boolean canCraft(@Nullable PalmBarRecipe recipe, class_5455 access) {
        if (recipe == null) {
            return false;
        }
        class_1799 recipeResultItem = recipe.method_8110((class_7225.class_7874)access);
        if (recipeResultItem.method_7960() || this.areInputsEmpty()) {
            return false;
        }
        class_1799 outputSlotItem = this.method_5438(0);
        if (outputSlotItem.method_7960()) {
            return true;
        }
        return class_1799.method_7984((class_1799)outputSlotItem, (class_1799)recipeResultItem) && outputSlotItem.method_7947() + recipeResultItem.method_7947() <= outputSlotItem.method_7914();
    }

    private boolean areInputsEmpty() {
        for (int i = 1; i <= 4; ++i) {
            if (this.method_5438(i).method_7960()) continue;
            return false;
        }
        return true;
    }

    private void craft(PalmBarRecipe recipe, class_5455 access) {
        if (!this.canCraft(recipe, access)) {
            return;
        }
        class_1799 recipeOutput = recipe.method_8110((class_7225.class_7874)access).method_7972();
        class_1799 outputSlotStack = this.method_5438(0);
        if (outputSlotStack.method_7960()) {
            this.method_5447(0, recipeOutput);
        } else if (class_1799.method_7984((class_1799)outputSlotStack, (class_1799)recipeOutput)) {
            outputSlotStack.method_7933(recipeOutput.method_7947());
            if (outputSlotStack.method_7947() > outputSlotStack.method_7914()) {
                outputSlotStack.method_7939(outputSlotStack.method_7914());
            }
        }
        this.consumeIngredients(recipe);
    }

    private class_1799 getRemainderItem(class_1799 stack) {
        if (stack.method_7909().method_7857()) {
            return new class_1799((class_1935)Objects.requireNonNull(stack.method_7909().method_7858()));
        }
        return class_1799.field_8037;
    }

    private void consumeIngredients(PalmBarRecipe recipe) {
        block0: for (class_1856 ingredient : recipe.method_8117()) {
            for (int i = 1; i <= 4; ++i) {
                class_1799 slotItem = this.method_5438(i);
                if (!ingredient.method_8093(slotItem)) continue;
                class_1799 remainder = this.getRemainderItem(slotItem);
                slotItem.method_7934(1);
                if (slotItem.method_7960() && !remainder.method_7960()) {
                    this.method_5447(i, remainder);
                    continue block0;
                }
                if (!slotItem.method_7960()) continue block0;
                this.method_5447(i, class_1799.field_8037);
                continue block0;
            }
        }
    }

    @NotNull
    public class_1799 method_5438(int i) {
        return (class_1799)this.inventory.get(i);
    }

    @NotNull
    public class_1799 method_5434(int i, int j) {
        return class_1262.method_5430(this.inventory, (int)i, (int)j);
    }

    @NotNull
    public class_1799 method_5441(int i) {
        return (class_1799)this.inventory.remove(i);
    }

    public int @NotNull [] method_5494(class_2350 side) {
        if (side.equals((Object)class_2350.field_11036)) {
            return SLOTS_FOR_UP;
        }
        if (side.equals((Object)class_2350.field_11033)) {
            return SLOTS_FOR_DOWN;
        }
        return SLOTS_FOR_SIDE;
    }

    public boolean method_5492(int i, class_1799 itemStack, @Nullable class_2350 direction) {
        return false;
    }

    public boolean method_5493(int i, class_1799 itemStack, class_2350 direction) {
        return false;
    }

    public int method_5439() {
        return 5;
    }

    public boolean method_5442() {
        return this.inventory.stream().allMatch(Predicate.isEqual(class_1799.field_8037));
    }

    public void method_5447(int slot, class_1799 stack) {
        this.inventory.set(slot, (Object)stack);
        if (stack.method_7947() > this.method_5444()) {
            stack.method_7939(this.method_5444());
        }
        if (slot >= 1 && slot <= 4) {
            this.totalShakingTime = 50;
            this.shakingTime = 0;
            this.method_5431();
        }
    }

    public boolean method_5443(class_1657 player) {
        return this.field_11863 != null && this.field_11863.method_8321(this.field_11867) == this && player.method_5649((double)this.field_11867.method_10263() + 0.5, (double)this.field_11867.method_10264() + 0.5, (double)this.field_11867.method_10260() + 0.5) <= 64.0;
    }

    @NotNull
    public class_2561 method_5476() {
        return ((class_2248)ObjectRegistry.PALM_BAR.get()).method_9518();
    }

    @Nullable
    public class_1703 createMenu(int syncId, class_1661 inv, class_1657 player) {
        return new PalmBarGuiHandler(syncId, inv, (class_1263)this, this.propertyDelegate);
    }

    public void method_5448() {
        this.inventory.clear();
    }

    private PalmBarRecipe getRecipe(List<class_8786<PalmBarRecipe>> recipes) {
        block0: for (class_8786<PalmBarRecipe> holder : recipes) {
            PalmBarRecipe recipe = (PalmBarRecipe)holder.comp_1933();
            for (class_1856 ingredient : recipe.method_8117()) {
                boolean ok = false;
                for (int slotIndex = 1; slotIndex < this.inventory.size(); ++slotIndex) {
                    class_1799 slotItem = (class_1799)this.inventory.get(slotIndex);
                    if (!ingredient.method_8093(slotItem)) continue;
                    ok = true;
                    break;
                }
                if (ok) continue;
                continue block0;
            }
            return recipe;
        }
        return null;
    }
}

