/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.beachparty.core.block.entity;

import java.util.List;
import net.minecraft.class_1792;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_5321;
import net.minecraft.class_5712;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_9793;
import net.satisfy.beachparty.core.registry.EntityTypeRegistry;
import net.satisfy.beachparty.core.registry.ObjectRegistry;
import net.satisfy.beachparty.core.registry.SoundEventRegistry;

public class RadioBlockEntity
extends class_2586 {
    private static final List<class_5321<class_9793>> TRACKS = SoundEventRegistry.RADIO_SONGS;
    private int currentIndex = -1;
    private int ticks;
    private long tickCount;
    private long startTick;
    public boolean isPlaying;
    private boolean syncedWithClient = false;

    public RadioBlockEntity(class_2338 pos, class_2680 state) {
        super((class_2591)EntityTypeRegistry.RADIO_BLOCK_ENTITY.get(), pos, state);
    }

    public static void tick(class_1937 level, class_2338 pos, RadioBlockEntity entity) {
        if (!entity.isPlaying || !(level instanceof class_3218)) {
            return;
        }
        class_3218 server = (class_3218)level;
        if (!entity.syncedWithClient) {
            entity.resendSoundToClient(server);
            entity.syncedWithClient = true;
        }
        ++entity.ticks;
        ++entity.tickCount;
        if (server.method_8510() >= entity.startTick + 1200L) {
            entity.stop();
            return;
        }
        if (level.method_8409().method_43057() < 0.05f) {
            double baseX = (double)pos.method_10263() + 0.5;
            double baseY = (double)pos.method_10264() + 1.0;
            double baseZ = (double)pos.method_10260() + 0.5;
            double offsetX = (level.method_8409().method_43058() - 0.5) * 0.6;
            double offsetZ = (level.method_8409().method_43058() - 0.5) * 0.6;
            float color = level.method_8409().method_43057();
            server.method_14199((class_2394)class_2398.field_11224, baseX + offsetX, baseY, baseZ + offsetZ, 0, (double)color, 0.0, 0.0, 1.0);
        }
    }

    public boolean toggleOrNext() {
        if (!this.isPlaying) {
            this.start();
        } else {
            this.next(this.field_11863);
        }
        return true;
    }

    public void start() {
        this.currentIndex = 0;
        this.play(this.field_11863);
    }

    public void next(class_1937 level) {
        this.currentIndex = (this.currentIndex + 1) % TRACKS.size();
        this.play(level);
    }

    public void stop() {
        class_1937 class_19372 = this.field_11863;
        if (!(class_19372 instanceof class_3218)) {
            return;
        }
        class_3218 server = (class_3218)class_19372;
        server.method_20290(1011, this.field_11867, 0);
        server.method_43276((class_6880)class_5712.field_39486, this.field_11867, class_5712.class_7397.method_43287((class_2680)this.method_11010()));
        this.isPlaying = false;
        this.ticks = 0;
        this.tickCount = 0L;
        this.syncedWithClient = false;
    }

    private void play(class_1937 level) {
        this.stop();
        if (!(level instanceof class_3218)) {
            return;
        }
        class_3218 server = (class_3218)level;
        if (this.currentIndex < 0 || this.currentIndex >= TRACKS.size()) {
            return;
        }
        this.isPlaying = true;
        this.ticks = 0;
        this.startTick = server.method_8510();
        class_1792 recordItem = this.getRecordItemForCurrentTrack();
        int id = class_1792.method_7880((class_1792)recordItem);
        server.method_8444(null, 1010, this.field_11867, id);
        server.method_43276((class_6880)class_5712.field_39485, this.field_11867, class_5712.class_7397.method_43287((class_2680)this.method_11010()));
        this.syncedWithClient = true;
    }

    private void resendSoundToClient(class_3218 server) {
        class_1792 recordItem = this.getRecordItemForCurrentTrack();
        int id = class_1792.method_7880((class_1792)recordItem);
        server.method_8444(null, 1010, this.field_11867, id);
    }

    private class_1792 getRecordItemForCurrentTrack() {
        return switch (this.currentIndex) {
            case 0 -> (class_1792)ObjectRegistry.MUSIC_DISC_BEACHPARTY.get();
            case 1 -> (class_1792)ObjectRegistry.MUSIC_DISC_CARIBBEAN_BEACH.get();
            case 2 -> (class_1792)ObjectRegistry.MUSIC_DISC_PRIDELANDS.get();
            case 3 -> (class_1792)ObjectRegistry.MUSIC_DISC_VOCALISTA.get();
            case 4 -> (class_1792)ObjectRegistry.MUSIC_DISC_WILD_VEINS.get();
            default -> (class_1792)ObjectRegistry.OVERGROWN_DISC.get();
        };
    }

    protected void method_11014(class_2487 compoundTag, class_7225.class_7874 provider) {
        super.method_11014(compoundTag, provider);
        this.currentIndex = compoundTag.method_10550("CurrentIndex");
        this.ticks = compoundTag.method_10550("Ticks");
        this.tickCount = compoundTag.method_10537("TickCount");
        this.startTick = compoundTag.method_10537("StartTick");
        this.isPlaying = compoundTag.method_10577("IsPlaying");
        this.syncedWithClient = false;
    }

    protected void method_11007(class_2487 tag, class_7225.class_7874 provider) {
        tag.method_10569("CurrentIndex", this.currentIndex);
        tag.method_10569("Ticks", this.ticks);
        tag.method_10544("TickCount", this.tickCount);
        tag.method_10544("StartTick", this.startTick);
        tag.method_10556("IsPlaying", this.isPlaying);
    }
}

