/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.beachparty.core.event;

import dev.architectury.event.EventResult;
import dev.architectury.event.events.common.EntityEvent;
import dev.architectury.event.events.common.LootEvent;
import dev.architectury.event.events.common.PlayerEvent;
import net.minecraft.class_1268;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3966;
import net.minecraft.class_52;
import net.minecraft.class_5321;
import net.minecraft.class_55;
import net.minecraft.class_79;
import net.minecraft.class_7924;
import net.minecraft.class_8111;
import net.minecraft.class_83;
import net.satisfy.beachparty.core.block.BeachParasolBlock;
import net.satisfy.beachparty.core.registry.ObjectRegistry;
import net.satisfy.beachparty.core.util.BeachpartyIdentifier;
import org.jetbrains.annotations.Nullable;

public class CommonEvents {
    public static void init() {
        LootEvent.MODIFY_LOOT_TABLE.register(CommonEvents::onModifyLootTable);
        PlayerEvent.ATTACK_ENTITY.register(CommonEvents::onPlayerAttack);
        EntityEvent.LIVING_HURT.register(CommonEvents::onLivingHurt);
    }

    private static void onModifyLootTable(class_5321<class_52> id, LootEvent.LootTableModificationContext ctx, boolean b) {
        LoottableInjector.InjectLoot(id, ctx);
    }

    private static EventResult onPlayerAttack(class_1657 player, class_1937 level, class_1297 entity, class_1268 hand, @Nullable class_3966 result) {
        class_1799 itemInHand = player.method_5998(hand);
        if (itemInHand.method_7909() == ObjectRegistry.POOL_NOODLE.get()) {
            class_243 knockbackDirection = new class_243(entity.method_23317() - player.method_23317(), 0.6, entity.method_23321() - player.method_23321()).method_1029().method_1021(1.5);
            entity.method_5762(knockbackDirection.field_1352, knockbackDirection.field_1351, knockbackDirection.field_1350);
            level.method_43128(null, entity.method_23317(), entity.method_23318(), entity.method_23321(), class_3417.field_15098, class_3419.field_15248, 1.0f, 1.5f);
            return EventResult.interruptTrue();
        }
        return EventResult.pass();
    }

    private static EventResult onLivingHurt(class_1309 entity, class_1282 source, float amount) {
        if (entity.method_37908().method_8608()) {
            return EventResult.pass();
        }
        if (CommonEvents.isFireDamage(source) && CommonEvents.isNearBeachParasol(entity)) {
            float reducedDamage = amount * 0.96f;
            entity.method_6033(entity.method_6032() + (amount - reducedDamage));
            return EventResult.interruptFalse();
        }
        return EventResult.pass();
    }

    private static boolean isFireDamage(class_1282 source) {
        return source.method_49708(class_8111.field_42335) || source.method_49708(class_8111.field_42337) || source.method_49708(class_8111.field_42338);
    }

    private static boolean isNearBeachParasol(class_1309 entity) {
        class_1937 level = entity.method_37908();
        class_2338 entityPos = entity.method_24515();
        for (int x = -1; x <= 1; ++x) {
            for (int y = -1; y <= 1; ++y) {
                for (int z = -1; z <= 1; ++z) {
                    class_2338 checkPos = entityPos.method_10069(x, y, z);
                    class_2680 blockState = level.method_8320(checkPos);
                    if (!(blockState.method_26204() instanceof BeachParasolBlock)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static class LoottableInjector {
        public static void InjectLoot(class_5321 id, LootEvent.LootTableModificationContext context) {
            String prefix = "minecraft:chests/";
            String name = id.toString();
            if (name.startsWith(prefix)) {
                String file;
                switch (file = name.substring(name.indexOf(prefix) + prefix.length())) {
                    case "desert_pyramid": 
                    case "buried_treasure": 
                    case "shipwreck_supply": 
                    case "shipwreck_treasure": 
                    case "simple_dungeon": 
                    case "underwater_ruin_big": 
                    case "underwater_ruin_small": 
                    case "woodland_mansion": {
                        context.addPool(LoottableInjector.getPool(file));
                        break;
                    }
                }
            }
        }

        public static class_55.class_56 getPool(String entryName) {
            return class_55.method_347().method_351(LoottableInjector.getPoolEntry(entryName));
        }

        private static class_79.class_80<?> getPoolEntry(String name) {
            class_5321 table = class_5321.method_29179((class_5321)class_7924.field_50079, (class_2960)BeachpartyIdentifier.identifier("chests/" + name));
            return class_83.method_428((class_5321)table);
        }
    }
}

