/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.beachparty.core.util;

import com.mojang.datafixers.util.Pair;
import dev.architectury.platform.Platform;
import dev.architectury.registry.client.rendering.ColorHandlerRegistry;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.Registrar;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_247;
import net.minecraft.class_2487;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2754;
import net.minecraft.class_2960;
import net.minecraft.class_3542;
import net.minecraft.class_3965;
import net.minecraft.class_9062;
import net.minecraft.class_9279;
import net.minecraft.class_9282;
import net.minecraft.class_9334;
import net.minecraft.class_9695;
import net.satisfy.beachparty.core.entity.ChairEntity;
import net.satisfy.beachparty.core.registry.EntityTypeRegistry;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3i;

public class BeachpartyUtil {
    public static final class_2754<LineConnectingType> LINE_CONNECTING_TYPE = class_2754.method_11850((String)"type", LineConnectingType.class);
    private static final Map<class_2960, Map<class_2338, Pair<ChairEntity, class_2338>>> CHAIRS = new HashMap<class_2960, Map<class_2338, Pair<ChairEntity, class_2338>>>();

    public static <T extends class_2248> RegistrySupplier<T> registerWithItem(DeferredRegister<class_2248> registerB, Registrar<class_2248> registrarB, DeferredRegister<class_1792> registerI, Registrar<class_1792> registrarI, class_2960 name, Supplier<T> block) {
        RegistrySupplier toReturn = BeachpartyUtil.registerWithoutItem(registerB, registrarB, name, block);
        BeachpartyUtil.registerItem(registerI, registrarI, name, () -> new class_1747((class_2248)toReturn.get(), new class_1792.class_1793()));
        return toReturn;
    }

    public static <T extends class_2248> RegistrySupplier<T> registerWithoutItem(DeferredRegister<class_2248> register, Registrar<class_2248> registrar, class_2960 path, Supplier<T> block) {
        return Platform.isNeoForge() ? register.register(path.method_12832(), block) : registrar.register(path, block);
    }

    public static <T extends class_1792> RegistrySupplier<T> registerItem(DeferredRegister<class_1792> register, Registrar<class_1792> registrar, class_2960 path, Supplier<T> itemSupplier) {
        return Platform.isNeoForge() ? register.register(path.method_12832(), itemSupplier) : registrar.register(path, itemSupplier);
    }

    public static class_265 rotateShape(class_2350 from, class_2350 to, class_265 shape) {
        class_265[] buffer = new class_265[]{shape, class_259.method_1073()};
        int times = (to.method_10161() - from.method_10161() + 4) % 4;
        for (int i = 0; i < times; ++i) {
            buffer[0].method_1089((minX, minY, minZ, maxX, maxY, maxZ) -> {
                buffer[1] = class_259.method_1082((class_265)buffer[1], (class_265)class_259.method_1081((double)(1.0 - maxZ), (double)minY, (double)minX, (double)(1.0 - minZ), (double)maxY, (double)maxX), (class_247)class_247.field_1366);
            });
            buffer[0] = buffer[1];
            buffer[1] = class_259.method_1073();
        }
        return buffer[0];
    }

    public static class_9062 onUse(class_1937 world, class_1657 player, class_1268 hand, class_3965 hit, double extraHeight) {
        if (world.field_9236) {
            return class_9062.field_47731;
        }
        if (player.method_5715()) {
            return class_9062.field_47731;
        }
        if (BeachpartyUtil.isPlayerSitting(player)) {
            return class_9062.field_47731;
        }
        if (hit.method_17780() == class_2350.field_11033) {
            return class_9062.field_47731;
        }
        class_2338 hitPos = hit.method_17777();
        if (!BeachpartyUtil.isOccupied(world, hitPos) && player.method_5998(hand).method_7960()) {
            ChairEntity chair = (ChairEntity)((class_1299)EntityTypeRegistry.CHAIR.get()).method_5883(world);
            assert (chair != null);
            chair.method_5808((double)hitPos.method_10263() + 0.5, (double)hitPos.method_10264() + 0.25 + extraHeight, (double)hitPos.method_10260() + 0.5, 0.0f, 0.0f);
            if (BeachpartyUtil.addChairEntity(world, hitPos, chair, player.method_24515())) {
                world.method_8649((class_1297)chair);
                player.method_5804((class_1297)chair);
                return class_9062.field_47728;
            }
        }
        return class_9062.field_47731;
    }

    public static void onStateReplaced(class_1937 world, class_2338 pos) {
        ChairEntity entity;
        if (!world.field_9236 && (entity = BeachpartyUtil.getChairEntity(world, pos)) != null) {
            BeachpartyUtil.removeChairEntity(world, pos);
            entity.method_5772();
        }
    }

    public static boolean addChairEntity(class_1937 world, class_2338 blockPos, ChairEntity entity, class_2338 playerPos) {
        if (!world.field_9236) {
            class_2960 id = BeachpartyUtil.getDimensionTypeId(world);
            if (!CHAIRS.containsKey(id)) {
                CHAIRS.put(id, new HashMap());
            }
            CHAIRS.get(id).put(blockPos, (Pair<ChairEntity, class_2338>)Pair.of((Object)((Object)entity), (Object)playerPos));
            return true;
        }
        return false;
    }

    public static void removeChairEntity(class_1937 world, class_2338 pos) {
        class_2960 id;
        if (!world.field_9236 && CHAIRS.containsKey(id = BeachpartyUtil.getDimensionTypeId(world))) {
            CHAIRS.get(id).remove(pos);
        }
    }

    public static ChairEntity getChairEntity(class_1937 world, class_2338 pos) {
        class_2960 id;
        if (!world.method_8608() && CHAIRS.containsKey(id = BeachpartyUtil.getDimensionTypeId(world)) && CHAIRS.get(id).containsKey(pos)) {
            return (ChairEntity)((Object)CHAIRS.get(id).get(pos).getFirst());
        }
        return null;
    }

    public static class_2338 getPreviousPlayerPosition(class_1657 player, ChairEntity chairEntity) {
        class_2960 id;
        if (!player.method_37908().method_8608() && CHAIRS.containsKey(id = BeachpartyUtil.getDimensionTypeId(player.method_37908()))) {
            for (Pair<ChairEntity, class_2338> pair : CHAIRS.get(id).values()) {
                if (pair.getFirst() != chairEntity) continue;
                return (class_2338)pair.getSecond();
            }
        }
        return null;
    }

    public static boolean isOccupied(class_1937 world, class_2338 pos) {
        class_2960 id = BeachpartyUtil.getDimensionTypeId(world);
        return CHAIRS.containsKey(id) && CHAIRS.get(id).containsKey(pos);
    }

    public static boolean isPlayerSitting(class_1657 player) {
        for (class_2960 i : CHAIRS.keySet()) {
            for (Pair<ChairEntity, class_2338> pair : CHAIRS.get(i).values()) {
                if (!((ChairEntity)((Object)pair.getFirst())).method_5626((class_1297)player)) continue;
                return true;
            }
        }
        return false;
    }

    public static void registerColorArmor(class_1792 item, int defaultColor) {
        ColorHandlerRegistry.registerItemColors((stack, tintIndex) -> tintIndex == 0 ? BeachpartyUtil.getColor(stack, defaultColor) : -1, (class_1935[])new class_1935[]{item});
    }

    public static void registerColorWeapon(class_1792 item, int defaultColor) {
        ColorHandlerRegistry.registerItemColors((stack, tintIndex) -> tintIndex == 0 ? BeachpartyUtil.getColor(stack, defaultColor) : -1, (class_1935[])new class_1935[]{item});
    }

    static int getColor(class_1799 itemStack, int defaultColor) {
        class_9282 dyed = (class_9282)itemStack.method_57824(class_9334.field_49644);
        if (dyed != null) {
            return 0xFF000000 | dyed.comp_2384();
        }
        class_2487 displayTag = ((class_9279)itemStack.method_57825(class_9334.field_49628, (Object)class_9279.field_49302)).method_57461().method_10562("display");
        if (displayTag.method_10573("color", 99)) {
            return 0xFF000000 | displayTag.method_10550("color");
        }
        Vector3i rgb = new Vector3i(defaultColor >> 16 & 0xFF, defaultColor >> 8 & 0xFF, defaultColor & 0xFF);
        return 0xFF000000 | rgb.x() << 16 | rgb.y() << 8 | rgb.z();
    }

    private static class_2960 getDimensionTypeId(class_1937 world) {
        return world.method_27983().method_29177();
    }

    public static boolean matchesRecipe(class_9695 inventory, class_2371<class_1856> recipe, int startIndex, int endIndex) {
        ArrayList<class_1799> validStacks = new ArrayList<class_1799>();
        for (int i = startIndex; i <= endIndex; ++i) {
            class_1799 stackInSlot = inventory.method_59984(i);
            if (stackInSlot.method_7960()) continue;
            validStacks.add(stackInSlot);
        }
        for (class_1856 entry : recipe) {
            boolean matches = false;
            for (class_1799 item : validStacks) {
                if (!entry.method_8093(item)) continue;
                matches = true;
                validStacks.remove(item);
                break;
            }
            if (matches) continue;
            return false;
        }
        return true;
    }

    public static enum LineConnectingType implements class_3542
    {
        NONE("none"),
        MIDDLE("middle"),
        LEFT("left"),
        RIGHT("right");

        private final String name;

        private LineConnectingType(String type) {
            this.name = type;
        }

        @NotNull
        public String method_15434() {
            return this.name;
        }
    }
}

