/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.beachparty.core.util;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_2338;
import net.minecraft.class_2382;

public class SandCastleManager {
    private static final Map<Long, Set<class_2338>> sandCastleChunks = new HashMap<Long, Set<class_2338>>();

    private static long getChunkKey(class_2338 pos) {
        int chunkX = pos.method_10263() >> 4;
        int chunkZ = pos.method_10260() >> 4;
        return (long)chunkX & 0xFFFFFFFFL | ((long)chunkZ & 0xFFFFFFFFL) << 32;
    }

    public static void registerSandCastle(class_2338 pos) {
        long chunkKey = SandCastleManager.getChunkKey(pos);
        sandCastleChunks.computeIfAbsent(chunkKey, k -> new HashSet()).add(pos);
    }

    public static void unregisterSandCastle(class_2338 pos) {
        long chunkKey = SandCastleManager.getChunkKey(pos);
        Set<class_2338> positions = sandCastleChunks.get(chunkKey);
        if (positions != null) {
            positions.remove(pos);
            if (positions.isEmpty()) {
                sandCastleChunks.remove(chunkKey);
            }
        }
    }

    public static class_2338 getNearestSandCastle(class_2338 mobPos) {
        int chunkX = mobPos.method_10263() >> 4;
        int chunkZ = mobPos.method_10260() >> 4;
        class_2338 nearestPos = null;
        double nearestDistance = Double.MAX_VALUE;
        for (int dx = -1; dx <= 1; ++dx) {
            for (int dz = -1; dz <= 1; ++dz) {
                long chunkKey = (long)(chunkX + dx) & 0xFFFFFFFFL | ((long)(chunkZ + dz) & 0xFFFFFFFFL) << 32;
                Set<class_2338> positions = sandCastleChunks.get(chunkKey);
                if (positions == null) continue;
                for (class_2338 pos : positions) {
                    double distance = pos.method_10262((class_2382)mobPos);
                    if (!(distance < nearestDistance)) continue;
                    nearestDistance = distance;
                    nearestPos = pos;
                }
            }
        }
        return nearestPos;
    }
}

