/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.beachparty.fabric;

import java.util.function.Predicate;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.serializer.GsonConfigSerializer;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.biome.v1.BiomeModification;
import net.fabricmc.fabric.api.biome.v1.BiomeModifications;
import net.fabricmc.fabric.api.biome.v1.BiomeSelectionContext;
import net.fabricmc.fabric.api.biome.v1.BiomeSelectors;
import net.fabricmc.fabric.api.biome.v1.ModificationPhase;
import net.fabricmc.fabric.api.entity.event.v1.EntitySleepEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2680;
import net.minecraft.class_2893;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7924;
import net.satisfy.beachparty.Beachparty;
import net.satisfy.beachparty.core.block.BeachSunLounger;
import net.satisfy.beachparty.core.block.BeachTowelBlock;
import net.satisfy.beachparty.core.registry.CompostablesRegistry;
import net.satisfy.beachparty.core.util.BeachpartyIdentifier;
import net.satisfy.beachparty.core.world.PlacedFeatures;
import net.satisfy.beachparty.fabric.core.compat.trinkets.TrinketsCompatibility;
import net.satisfy.beachparty.fabric.core.config.ConfigFabric;
import net.satisfy.beachparty.fabric.core.world.entity.npc.VillagerTrades;

public class BeachpartyFabric
implements ModInitializer {
    public static boolean trinketsLoaded;

    public void onInitialize() {
        AutoConfig.register(ConfigFabric.class, GsonConfigSerializer::new);
        Beachparty.init();
        CompostablesRegistry.init();
        Beachparty.commonSetup();
        this.addBiomeModification();
        VillagerTrades.init();
        EntitySleepEvents.ALLOW_SETTING_SPAWN.register((player, sleepingPos) -> {
            boolean onClient = player.method_37908().field_9236;
            class_2680 blockState = player.method_37908().method_8320(sleepingPos);
            return !onClient && !(blockState.method_26204() instanceof BeachTowelBlock) && !(blockState.method_26204() instanceof BeachSunLounger);
        });
        trinketsLoaded = FabricLoader.getInstance().isModLoaded("trinkets");
        if (trinketsLoaded) {
            TrinketsCompatibility.load();
        }
    }

    private void addBiomeModification() {
        ConfigFabric config = (ConfigFabric)AutoConfig.getConfigHolder(ConfigFabric.class).getConfig();
        BiomeModification world = BiomeModifications.create((class_2960)BeachpartyIdentifier.identifier("world_features"));
        Predicate<BiomeSelectionContext> beachBiomes = BeachpartyFabric.getBeachpartySelector();
        if (config.spawnSeashells) {
            world.add(ModificationPhase.ADDITIONS, beachBiomes, ctx -> ctx.getGenerationSettings().addFeature(class_2893.class_2895.field_13178, PlacedFeatures.SEASHELLS_KEY));
        }
        if (config.spawnPalms) {
            world.add(ModificationPhase.ADDITIONS, beachBiomes, ctx -> ctx.getGenerationSettings().addFeature(class_2893.class_2895.field_13178, PlacedFeatures.PALM_TREE_KEY));
        } else {
            world.add(ModificationPhase.REMOVALS, beachBiomes, ctx -> ctx.getGenerationSettings().removeFeature(class_2893.class_2895.field_13178, PlacedFeatures.PALM_TREE_KEY));
        }
        if (config.spawnSandwaves) {
            world.add(ModificationPhase.ADDITIONS, beachBiomes, ctx -> ctx.getGenerationSettings().addFeature(class_2893.class_2895.field_13178, PlacedFeatures.SANDWAVES_KEY));
        } else {
            world.add(ModificationPhase.REMOVALS, beachBiomes, ctx -> ctx.getGenerationSettings().removeFeature(class_2893.class_2895.field_13178, PlacedFeatures.SANDWAVES_KEY));
        }
    }

    private static Predicate<BiomeSelectionContext> getBeachpartySelector() {
        return BiomeSelectors.tag((class_6862)class_6862.method_40092((class_5321)class_7924.field_41236, (class_2960)BeachpartyIdentifier.identifier("beach")));
    }
}

