/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.beachparty.fabric.core.compat;

import dev.emi.trinkets.api.SlotReference;
import dev.emi.trinkets.api.Trinket;
import dev.emi.trinkets.api.TrinketComponent;
import dev.emi.trinkets.api.TrinketInventory;
import dev.emi.trinkets.api.TrinketsApi;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_239;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_746;
import net.satisfy.beachparty.core.registry.ObjectRegistry;

public class BeachpartyTrinket {
    public static boolean isTrinketEquipped(class_1657 player, class_1792 ... trinkets) {
        for (class_1799 itemStack : player.method_5661()) {
            for (class_1792 trinket : trinkets) {
                if (itemStack.method_7909() != trinket) continue;
                return true;
            }
        }
        Optional componentOptional = TrinketsApi.getTrinketComponent((class_1309)player);
        if (componentOptional.isPresent()) {
            TrinketComponent component = (TrinketComponent)componentOptional.get();
            Map inventoryMap = component.getInventory();
            for (Map trinketGroup : inventoryMap.values()) {
                for (TrinketInventory trinketInventory : trinketGroup.values()) {
                    for (int i = 0; i < trinketInventory.method_5439(); ++i) {
                        class_1799 trinketStack = trinketInventory.method_5438(i);
                        if (trinketStack.method_7960()) continue;
                        for (class_1792 trinket : trinkets) {
                            if (trinketStack.method_7909() != trinket) continue;
                            return true;
                        }
                    }
                }
            }
        }
        return false;
    }

    public static class SwimWingsTrinket
    extends BaseTrinket {
        public SwimWingsTrinket() {
            super(0.0f, (class_1792)ObjectRegistry.SWIM_WINGS.get());
        }

        public void tick(class_1799 stack, SlotReference slot, class_1309 entity) {
            if (!entity.method_37908().method_8608() && entity instanceof class_1657) {
                class_1657 player = (class_1657)entity;
                if (player.field_6012 > 20 && !player.method_7357().method_7904((class_1792)ObjectRegistry.SWIM_WINGS.get()) && !player.method_24828() && player.method_18798().field_1351 < (double)-0.1f && player.field_6017 > 3.0f) {
                    player.field_6017 *= 0.5f;
                    player.method_7357().method_7906((class_1792)ObjectRegistry.SWIM_WINGS.get(), 2400);
                }
            }
        }
    }

    public static class SwimSuitTrinket
    extends BaseTrinket {
        public SwimSuitTrinket() {
            super(0.0f, (class_1792)ObjectRegistry.TRUNKS.get(), (class_1792)ObjectRegistry.BIKINI.get());
        }

        public void tick(class_1799 stack, SlotReference slot, class_1309 entity) {
            class_1657 player;
            super.tick(stack, slot, entity);
            if (entity instanceof class_1657 && (player = (class_1657)entity).method_5799() && player.method_5681()) {
                player.method_18799(player.method_18798().method_18805(1.08, 1.0, 1.08));
            }
        }
    }

    public static class SunglassesTrinket
    extends BaseTrinket {
        public SunglassesTrinket() {
            super(0.12f, (class_1792)ObjectRegistry.SUNGLASSES.get());
        }
    }

    public static class RubberRingTrinket
    extends BaseTrinket {
        private static final Random RANDOM = new Random();

        public RubberRingTrinket() {
            super(0.0f, (class_1792)ObjectRegistry.RUBBER_RING_AXOLOTL.get(), (class_1792)ObjectRegistry.RUBBER_RING_PELICAN.get(), (class_1792)ObjectRegistry.RUBBER_RING_BLUE.get(), (class_1792)ObjectRegistry.RUBBER_RING_STRIPPED.get(), (class_1792)ObjectRegistry.RUBBER_RING_PINK.get());
        }

        public void tick(class_1799 stack, SlotReference slot, class_1309 entity) {
            if (!(entity instanceof class_1657)) {
                return;
            }
            class_1657 player = (class_1657)entity;
            if (player.method_5799()) {
                if (this.shouldSkipDueToJumpKeyPress(player)) {
                    return;
                }
                class_243 motion = player.method_18798();
                double newY = Math.min(motion.field_1351 + 0.01, 0.3);
                class_243 newMotion = motion.method_18805(1.17, 1.0, 1.17).method_38499(class_2350.class_2351.field_11052, newY);
                double maxSpeed = 0.1989;
                if (newMotion.method_37267() > maxSpeed) {
                    newMotion = newMotion.method_1029().method_1021(maxSpeed).method_38499(class_2350.class_2351.field_11052, newY);
                }
                player.method_18799(newMotion);
                if (player.method_37908().method_8477(player.method_24515())) {
                    try {
                        class_3965 hitResult = player.method_37908().method_17742(new class_3959(player.method_19538(), player.method_19538().method_1023(0.0, 256.0, 0.0), class_3959.class_3960.field_17559, class_3959.class_242.field_1345, (class_1297)player));
                        if (hitResult.method_17783() != class_239.class_240.field_1333) {
                            class_2338 pos = hitResult.method_17777();
                            double targetY = pos.method_10264();
                            if (player.method_23318() > targetY + 1.0 && !player.method_5869()) {
                                player.method_5814(player.method_23317(), targetY + 1.0, player.method_23321());
                            }
                        }
                    }
                    catch (Exception hitResult) {
                        // empty catch block
                    }
                }
                class_243 look = player.method_5720();
                class_243 lookJ = new class_243(look.field_1352, 0.0, look.field_1350);
                if (lookJ.method_1027() == 0.0) {
                    lookJ = new class_243(1.0, 0.0, 0.0);
                }
                class_243 left = lookJ.method_1036(new class_243(0.0, 1.0, 0.0)).method_1029();
                double offset = 0.5;
                class_243 leftPos = player.method_19538().method_1019(left.method_1021(offset)).method_1031(0.0, 0.8, 0.0);
                class_243 rightPos = player.method_19538().method_1020(left.method_1021(offset)).method_1031(0.0, 0.8, 0.0);
                this.spawnWaterParticles(player, leftPos, rightPos);
            }
        }

        private boolean shouldSkipDueToJumpKeyPress(class_1657 player) {
            if (FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT) {
                return this.checkJumpKeyOnClient(player);
            }
            return false;
        }

        @Environment(value=EnvType.CLIENT)
        private boolean checkJumpKeyOnClient(class_1657 player) {
            return player instanceof class_746 && class_310.method_1551().field_1690.field_1903.method_1434();
        }

        private void spawnWaterParticles(class_1657 player, class_243 leftPos, class_243 rightPos) {
            block3: {
                double spread;
                block2: {
                    spread = 0.2;
                    double motionThreshold = 0.005;
                    if (!(player.method_18798().method_1027() > motionThreshold)) break block2;
                    for (int i = 0; i < 3; ++i) {
                        this.spawnParticlePair(player, (class_2394)class_2398.field_11202, leftPos, rightPos, spread);
                        this.spawnParticlePair(player, (class_2394)class_2398.field_11241, leftPos, rightPos, spread);
                    }
                    break block3;
                }
                if (player.method_37908().method_8510() % 20L != 0L) break block3;
                for (int i = 0; i < 5; ++i) {
                    this.spawnRandomSplash(player, spread);
                }
            }
        }

        private void spawnParticlePair(class_1657 player, class_2394 particle, class_243 leftPos, class_243 rightPos, double spread) {
            this.spawnParticle(player, particle, leftPos, spread);
            this.spawnParticle(player, particle, rightPos, spread);
        }

        private void spawnParticle(class_1657 player, class_2394 particle, class_243 pos, double spread) {
            player.method_37908().method_8406(particle, pos.field_1352 + (RANDOM.nextDouble() * spread - spread / 2.0), pos.field_1351 + (RANDOM.nextDouble() * spread - spread / 2.0), pos.field_1350 + (RANDOM.nextDouble() * spread - spread / 2.0), 0.0, 0.0, 0.0);
        }

        private void spawnRandomSplash(class_1657 player, double spread) {
            double offset = 0.25;
            double angle = RANDOM.nextDouble() * Math.PI * 2.0;
            double xOffset = Math.cos(angle) * offset;
            double zOffset = Math.sin(angle) * offset;
            double x = player.method_23317() + xOffset;
            double y = player.method_23318() + (double)player.method_5751() - 0.5 + (RANDOM.nextDouble() * spread - spread / 2.0);
            double z = player.method_23321() + zOffset;
            player.method_37908().method_8406((class_2394)class_2398.field_11202, x, y, z, 0.0, 0.0, 0.0);
        }
    }

    public static class CrocsTrinket
    extends BaseTrinket {
        public CrocsTrinket() {
            super(0.0f, new class_1792[0]);
        }
    }

    public static class BeachhatTrinket
    extends BaseTrinket {
        public BeachhatTrinket() {
            super(0.1f, (class_1792)ObjectRegistry.BEACH_HAT.get());
        }
    }

    public static abstract class BaseTrinket
    implements Trinket {
        private final float fireDamageReduction;
        private final class_1792[] conflictingItems;

        protected BaseTrinket(float fireDamageReduction, class_1792 ... conflictingItems) {
            this.fireDamageReduction = fireDamageReduction;
            this.conflictingItems = conflictingItems;
        }

        public void onEquip(class_1799 stack, SlotReference slot, class_1309 entity) {
            if (entity instanceof class_1657) {
                float damage;
                class_1657 player = (class_1657)entity;
                if (this.fireDamageReduction > 0.0f && (damage = Math.max(0.0f, 1.0f - this.fireDamageReduction)) > 0.0f && !player.method_5679(player.method_37908().method_48963().method_48794())) {
                    player.method_5643(player.method_37908().method_48963().method_48794(), damage);
                }
            }
        }

        public boolean canEquip(class_1799 stack, SlotReference slot, class_1309 entity) {
            if (!(entity instanceof class_1657)) {
                return false;
            }
            class_1657 player = (class_1657)entity;
            return !BeachpartyTrinket.isTrinketEquipped(player, this.conflictingItems);
        }
    }
}

