package net.satisfy.beachparty.core.registry;

import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.block.Blocks;
import net.satisfy.beachparty.core.util.BeachpartyIdentifier;

import java.util.EnumMap;
import java.util.List;
import java.util.function.Supplier;

@SuppressWarnings("SameParameterValue")
public class ArmorMaterialRegistry {
    private static final int ENCHANTMENT_VALUE = 15;
    private static final Holder<SoundEvent> EQUIP_SOUND = SoundEvents.ARMOR_EQUIP_LEATHER;
    private static final float TOUGHNESS = 0.0F;
    private static final float KNOCKBACK_RESISTANCE = 0.0F;

    public static final ArmorMaterial TRUNKS = createMaterial("trunks", Ingredient.of(Items.STRING), true);
    public static final ArmorMaterial BIKINI = createMaterial("bikini", Ingredient.of(Items.STRING), true);
    public static final ArmorMaterial RING = createMaterial("ring", Ingredient.of(Items.DRIED_KELP), false);
    public static final ArmorMaterial BEACH_HAT = createMaterial("beach_hat", Ingredient.of(Items.WHEAT), false);
    public static final ArmorMaterial SUNGLASSES = createMaterial("sunglasses", Ingredient.of(Blocks.BLACK_STAINED_GLASS_PANE.asItem()), false);
    public static final ArmorMaterial SWIM_WINGS = createMaterial("swim_wings", Ingredient.of(Items.DRIED_KELP), true);
    public static final ArmorMaterial CROCS = createMaterial("crocs", Ingredient.of(Items.DRIED_KELP), true);

    private static ArmorMaterial createMaterial(String name, Ingredient repairIngredient, boolean dyeable) {
        return register(slots(1, 1, 1, 1, 1), ENCHANTMENT_VALUE, EQUIP_SOUND, TOUGHNESS, KNOCKBACK_RESISTANCE, () -> repairIngredient, layers(name, dyeable)
        );
    }

    private static EnumMap<ArmorItem.Type, Integer> slots(int boots, int leggings, int chestplate, int helmet, int body) {
        EnumMap<ArmorItem.Type, Integer> map = new EnumMap<>(ArmorItem.Type.class);
        map.put(ArmorItem.Type.BOOTS, boots);
        map.put(ArmorItem.Type.LEGGINGS, leggings);
        map.put(ArmorItem.Type.CHESTPLATE, chestplate);
        map.put(ArmorItem.Type.HELMET, helmet);
        map.put(ArmorItem.Type.BODY, body);
        return map;
    }

    private static List<ArmorMaterial.Layer> layers(String name, boolean dyeable) {
        ResourceLocation base = BeachpartyIdentifier.identifier(name);
        return List.of(new ArmorMaterial.Layer(base, "", dyeable));
    }


    private static ArmorMaterial register(EnumMap<ArmorItem.Type, Integer> health, int enchantValue, Holder<SoundEvent> equipSound, float toughness, float knockback, Supplier<Ingredient> repair, List<ArmorMaterial.Layer> layers) {
        EnumMap<ArmorItem.Type, Integer> copy = new EnumMap<>(ArmorItem.Type.class);
        copy.putAll(health);
        return new ArmorMaterial(copy, enchantValue, equipSound, repair, layers, toughness, knockback);
    }
}
