/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.beachparty.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.world.entity.Entity;
import net.satisfy.beachparty.client.model.LeggingsModel;
import net.satisfy.beachparty.core.util.BeachpartyIdentifier;

public class CrocsModel<T extends Entity>
extends EntityModel<T>
implements LeggingsModel {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(BeachpartyIdentifier.identifier("crocs"), "main");
    private final ModelPart right_leg;
    private final ModelPart left_leg;

    public CrocsModel(ModelPart root) {
        this.right_leg = root.getChild("right_leg");
        this.left_leg = root.getChild("left_leg");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition right_leg = partdefinition.addOrReplaceChild("right_leg", CubeListBuilder.create().texOffs(0, 10).addBox(-2.0f, 8.0f, -2.0f, 4.0f, 2.0f, 4.0f, new CubeDeformation(0.25f)), PartPose.offset((float)-1.9f, (float)12.0f, (float)0.0f));
        PartDefinition left_leg = partdefinition.addOrReplaceChild("left_leg", CubeListBuilder.create().texOffs(0, 10).mirror().addBox(-2.0f, 8.0f, -2.0f, 4.0f, 2.0f, 4.0f, new CubeDeformation(0.25f)).mirror(false), PartPose.offset((float)1.9f, (float)12.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)16, (int)16);
    }

    public void setupAnim(Entity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
    }

    @Override
    public void copyBody(ModelPart model, ModelPart left_leg, ModelPart right_leg) {
        this.right_leg.copyFrom(right_leg);
        this.left_leg.copyFrom(left_leg);
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int i, int j, int k) {
        poseStack.pushPose();
        poseStack.scale(1.09f, 1.09f, 1.09f);
        this.right_leg.render(poseStack, vertexConsumer, i, j, k);
        this.left_leg.render(poseStack, vertexConsumer, i, j, k);
        poseStack.popPose();
    }
}

