/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.beachparty.core.block;

import com.mojang.serialization.MapCodec;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextColor;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.satisfy.beachparty.core.block.entity.BeachGoalBlockEntity;
import net.satisfy.beachparty.core.registry.EntityTypeRegistry;
import net.satisfy.beachparty.core.registry.ObjectRegistry;
import net.satisfy.beachparty.core.util.BeachpartyUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BeachGoalBlock
extends BaseEntityBlock {
    public static final EnumProperty<Part> PART = EnumProperty.create((String)"part", Part.class);
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    private static final VoxelShape SHAPE_BOTTOM_LEFT = BeachGoalBlock.makeBottomLeftShape();
    private static final VoxelShape SHAPE_BOTTOM_RIGHT = BeachGoalBlock.makeBottomRightShape();
    private static final VoxelShape SHAPE_TOP_LEFT = BeachGoalBlock.makeTopLeftShape();
    private static final VoxelShape SHAPE_TOP_RIGHT = BeachGoalBlock.makeTopRightShape();
    public static final Map<Direction, Map<Part, VoxelShape>> SHAPE = (Map)Util.make(new HashMap(), map -> {
        for (Direction direction : Direction.Plane.HORIZONTAL.stream().toList()) {
            HashMap<Part, VoxelShape> partShapeMap = new HashMap<Part, VoxelShape>();
            partShapeMap.put(Part.BOTTOM_LEFT, BeachpartyUtil.rotateShape(Direction.NORTH, direction, SHAPE_BOTTOM_LEFT));
            partShapeMap.put(Part.BOTTOM_RIGHT, BeachpartyUtil.rotateShape(Direction.NORTH, direction, SHAPE_BOTTOM_RIGHT));
            partShapeMap.put(Part.TOP_LEFT, BeachpartyUtil.rotateShape(Direction.NORTH, direction, SHAPE_TOP_LEFT));
            partShapeMap.put(Part.TOP_RIGHT, BeachpartyUtil.rotateShape(Direction.NORTH, direction, SHAPE_TOP_RIGHT));
            map.put(direction, partShapeMap);
        }
    });
    private static final Supplier<VoxelShape> detectionShapeSupplier = () -> Shapes.box((double)0.125, (double)0.0, (double)0.1875, (double)0.875, (double)0.6875, (double)0.75);
    public static final Map<Direction, VoxelShape> DETECTION_SHAPE = (Map)Util.make(new HashMap(), map -> {
        for (Direction direction : Direction.Plane.HORIZONTAL.stream().toList()) {
            map.put(direction, BeachpartyUtil.rotateShape(Direction.NORTH, direction, detectionShapeSupplier.get()));
        }
    });
    public static final MapCodec<BeachGoalBlock> CODEC = BeachGoalBlock.simpleCodec(BeachGoalBlock::new);

    private static VoxelShape makeBottomLeftShape() {
        VoxelShape shape = Shapes.empty();
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.125, (double)0.0, (double)0.1875, (double)0.25, (double)1.0, (double)0.3125), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.125, (double)0.0, (double)0.6875, (double)1.0, (double)0.125, (double)0.8125), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.125, (double)0.0, (double)0.3125, (double)0.25, (double)0.125, (double)0.6875), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.1875, (double)0.125, (double)0.3125, (double)0.25, (double)1.0, (double)0.75), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.1875, (double)0.125, (double)0.6875, (double)1.0, (double)1.0, (double)0.75), (BooleanOp)BooleanOp.OR);
        return shape;
    }

    private static VoxelShape makeBottomRightShape() {
        VoxelShape shape = Shapes.empty();
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.75, (double)0.0, (double)0.1875, (double)0.875, (double)1.0, (double)0.3125), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0, (double)0.0, (double)0.6875, (double)0.875, (double)0.125, (double)0.8125), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.75, (double)0.0, (double)0.3125, (double)0.875, (double)0.125, (double)0.6875), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.75, (double)0.125, (double)0.3125, (double)0.8125, (double)1.0, (double)0.75), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0, (double)0.125, (double)0.6875, (double)0.8125, (double)1.0, (double)0.75), (BooleanOp)BooleanOp.OR);
        return shape;
    }

    private static VoxelShape makeTopLeftShape() {
        VoxelShape shape = Shapes.empty();
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.125, (double)0.0, (double)0.1875, (double)0.25, (double)0.625, (double)0.3125), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.125, (double)0.625, (double)0.1875, (double)1.0, (double)0.75, (double)0.3125), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.1875, (double)0.0, (double)0.3125, (double)0.25, (double)0.625, (double)0.75), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.25, (double)0.0, (double)0.6875, (double)1.0, (double)0.625, (double)0.75), (BooleanOp)BooleanOp.OR);
        return shape;
    }

    private static VoxelShape makeTopRightShape() {
        VoxelShape shape = Shapes.empty();
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.75, (double)0.0, (double)0.1875, (double)0.875, (double)0.625, (double)0.3125), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0, (double)0.625, (double)0.1875, (double)0.875, (double)0.75, (double)0.3125), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.75, (double)0.0, (double)0.3125, (double)0.8125, (double)0.625, (double)0.75), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0, (double)0.0, (double)0.6875, (double)0.75, (double)0.625, (double)0.75), (BooleanOp)BooleanOp.OR);
        return shape;
    }

    public BeachGoalBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(PART, (Comparable)((Object)Part.BOTTOM_LEFT))).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    @NotNull
    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{PART, FACING});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Direction direction;
        BlockPos pos = context.getClickedPos();
        Level world = context.getLevel();
        if (!this.canPlaceAt(world, pos, direction = context.getHorizontalDirection().getOpposite())) {
            return null;
        }
        return (BlockState)((BlockState)this.defaultBlockState().setValue(PART, (Comparable)((Object)Part.BOTTOM_LEFT))).setValue((Property)FACING, (Comparable)direction);
    }

    @NotNull
    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rot.rotate((Direction)state.getValue((Property)FACING)));
    }

    @NotNull
    public BlockState mirror(BlockState state, Mirror mirrorIn) {
        return state.rotate(mirrorIn.getRotation((Direction)state.getValue((Property)FACING)));
    }

    public VoxelShape getDetectionShape(BlockState state) {
        return DETECTION_SHAPE.get(state.getValue((Property)FACING));
    }

    @NotNull
    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        Direction direction = (Direction)state.getValue((Property)FACING);
        Part part = (Part)((Object)state.getValue(PART));
        return SHAPE.get(direction).get((Object)part);
    }

    private boolean canPlaceAt(Level world, BlockPos pos, Direction direction) {
        return world.getBlockState(pos).canBeReplaced() && world.getBlockState(pos.above()).canBeReplaced() && world.getBlockState(pos.relative(direction.getClockWise())).canBeReplaced() && world.getBlockState(pos.relative(direction.getClockWise()).above()).canBeReplaced();
    }

    public void setPlacedBy(Level world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        Direction direction = (Direction)state.getValue((Property)FACING);
        world.setBlock(pos.above(), (BlockState)((BlockState)this.defaultBlockState().setValue(PART, (Comparable)((Object)Part.TOP_LEFT))).setValue((Property)FACING, (Comparable)direction), 3);
        world.setBlock(pos.relative(direction.getClockWise()), (BlockState)((BlockState)this.defaultBlockState().setValue(PART, (Comparable)((Object)Part.BOTTOM_RIGHT))).setValue((Property)FACING, (Comparable)direction), 3);
        world.setBlock(pos.relative(direction.getClockWise()).above(), (BlockState)((BlockState)this.defaultBlockState().setValue(PART, (Comparable)((Object)Part.TOP_RIGHT))).setValue((Property)FACING, (Comparable)direction), 3);
        world.playSound(null, pos, SoundEvents.WOOD_PLACE, SoundSource.BLOCKS, 1.0f, 1.0f);
        world.playSound(null, pos, SoundEvents.CHERRY_WOOD_PLACE, SoundSource.BLOCKS, 1.0f, 1.0f);
    }

    public void onRemove(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        state.getBlock();
        newState.getBlock();
        super.onRemove(state, world, pos, newState, isMoving);
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new BeachGoalBlockEntity(pos, state);
    }

    @NotNull
    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    public boolean isSignalSource(BlockState state) {
        return true;
    }

    public int getSignal(BlockState state, BlockGetter world, BlockPos pos, Direction direction) {
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity instanceof BeachGoalBlockEntity) {
            BeachGoalBlockEntity goalBlockEntity = (BeachGoalBlockEntity)blockEntity;
            return goalBlockEntity.hasBeachBall() ? 15 : 0;
        }
        return 0;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return level.isClientSide ? null : BaseEntityBlock.createTickerHelper(type, (BlockEntityType)((BlockEntityType)EntityTypeRegistry.BEACH_GOAL_BLOCK_ENTITY.get()), BeachGoalBlockEntity::tick);
    }

    public void appendHoverText(ItemStack itemStack, Item.TooltipContext tooltipContext, List<Component> tooltip, TooltipFlag tooltipFlag) {
        tooltip.add((Component)Component.translatable((String)"tooltip.beachparty.canbeplaced").withStyle(style -> style.withColor(TextColor.fromRgb((int)13939843))));
    }

    @NotNull
    public BlockState playerWillDestroy(Level world, BlockPos pos, BlockState state, Player player) {
        BlockPos basePos = this.getBasePos(world.getBlockState(pos), pos);
        BlockEntity entity = world.getBlockEntity(basePos);
        if (!(entity instanceof BeachGoalBlockEntity)) {
            super.playerWillDestroy(world, pos, state, player);
            return state;
        }
        BeachGoalBlockEntity beachGoalBlockEntity = (BeachGoalBlockEntity)entity;
        if (world.isClientSide()) {
            return state;
        }
        CompoundTag blockEntityTag = new CompoundTag();
        beachGoalBlockEntity.saveAdditional(blockEntityTag, (HolderLookup.Provider)world.registryAccess());
        CompoundTag tag = new CompoundTag();
        tag.put("BlockEntityTag", (Tag)blockEntityTag);
        ItemStack stack = new ItemStack((ItemLike)ObjectRegistry.BEACH_GOAL.get());
        stack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)tag));
        world.addFreshEntity((Entity)new ItemEntity(world, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), stack));
        this.destroyAdjacentBlocks(world, basePos);
        super.playerWillDestroy(world, pos, state, player);
        return state;
    }

    private BlockPos getBasePos(BlockState state, BlockPos pos) {
        Part part = (Part)((Object)state.getValue(PART));
        Direction direction = (Direction)state.getValue((Property)FACING);
        return switch (part.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> pos;
            case 2 -> pos.below();
            case 1 -> pos.relative(direction.getCounterClockWise(), 1);
            case 3 -> pos.relative(direction.getCounterClockWise(), 1).below();
        };
    }

    private void destroyAdjacentBlocks(Level world, BlockPos basePos) {
        BlockState blockstate = world.getBlockState(basePos);
        Direction facing = (Direction)blockstate.getValue((Property)FACING);
        world.removeBlock(basePos, false);
        world.removeBlock(basePos.above(), false);
        world.removeBlock(basePos.relative(facing.getClockWise(), 1), false);
        world.removeBlock(basePos.relative(facing.getClockWise(), 1).above(), false);
    }

    public static enum Part implements StringRepresentable
    {
        BOTTOM_LEFT("bottom_left"),
        BOTTOM_RIGHT("bottom_right"),
        TOP_LEFT("top_left"),
        TOP_RIGHT("top_right");

        private final String name;

        private Part(String name) {
            this.name = name;
        }

        @NotNull
        public String getSerializedName() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }
    }
}

