/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.beachparty.core.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.satisfy.beachparty.core.registry.ObjectRegistry;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;

public class HangingCoconutBlock
extends FallingBlock
implements BonemealableBlock {
    public static final IntegerProperty AGE = BlockStateProperties.AGE_2;
    protected static final VoxelShape[] SHAPE_BY_AGE = new VoxelShape[]{Block.box((double)4.0, (double)7.0, (double)4.0, (double)12.0, (double)15.0, (double)12.0), Block.box((double)3.0, (double)5.0, (double)3.0, (double)13.0, (double)15.0, (double)13.0), Block.box((double)2.0, (double)3.0, (double)2.0, (double)14.0, (double)15.0, (double)14.0)};
    private static final float FALL_DAMAGE = 2.0f;
    private static final int FALL_DAMAGE_THRESHOLD = 40;
    private static final float COCONUT_SMASH_VOLUME = 0.7f;
    private static final float COCONUT_SMASH_PITCH_BASE = 0.9f;

    public HangingCoconutBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)AGE, (Comparable)Integer.valueOf(0)));
    }

    protected MapCodec<? extends FallingBlock> codec() {
        return null;
    }

    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        return level.getBlockState(pos.above()).is((Block)ObjectRegistry.PALM_LEAVES.get());
    }

    @NotNull
    public BlockState updateShape(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        if (facing == Direction.UP && !this.canSurvive(state, (LevelReader)level, currentPos)) {
            if (!level.isClientSide()) {
                level.scheduleTick(currentPos, (Block)this, 1);
            }
            return state;
        }
        return super.updateShape(state, facing, facingState, level, currentPos, facingPos);
    }

    public boolean isRandomlyTicking(BlockState state) {
        return true;
    }

    public void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        int age = (Integer)state.getValue((Property)AGE);
        if (random.nextInt(3) == 0) {
            if (age < 2) {
                level.setBlock(pos, (BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf(age + 1)), 2);
            } else if (pos.getY() >= level.getMinBuildHeight() && HangingCoconutBlock.isFree((BlockState)level.getBlockState(pos.below()))) {
                FallingBlockEntity fallingEntity = FallingBlockEntity.fall((Level)level, (BlockPos)pos, (BlockState)level.getBlockState(pos));
                this.falling(fallingEntity);
                level.removeBlock(pos, false);
            }
        }
    }

    public void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (level.isEmptyBlock(pos.above()) && pos.getY() >= level.getMinBuildHeight() && HangingCoconutBlock.isFree((BlockState)level.getBlockState(pos.below()))) {
            FallingBlockEntity fallingEntity = FallingBlockEntity.fall((Level)level, (BlockPos)pos, (BlockState)level.getBlockState(pos));
            this.falling(fallingEntity);
            level.removeBlock(pos, false);
        }
    }

    @NotNull
    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE_BY_AGE[(Integer)state.getValue((Property)AGE)];
    }

    public boolean isValidBonemealTarget(LevelReader levelReader, BlockPos blockPos, BlockState blockState) {
        return (Integer)blockState.getValue((Property)AGE) < 2;
    }

    public boolean isBonemealSuccess(Level level, RandomSource random, BlockPos pos, BlockState state) {
        return true;
    }

    public void performBonemeal(ServerLevel level, RandomSource random, BlockPos pos, BlockState state) {
        level.setBlock(pos, (BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf((Integer)state.getValue((Property)AGE) + 1)), 2);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{AGE});
    }

    protected boolean isPathfindable(BlockState blockState, PathComputationType pathComputationType) {
        return false;
    }

    protected void falling(FallingBlockEntity entity) {
        entity.setHurtsEntities(2.0f, 40);
    }

    @NotNull
    public DamageSource getFallDamageSource(Entity entity) {
        return entity.damageSources().fallingBlock(entity);
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        if (random.nextInt(16) == 0 && (Integer)state.getValue((Property)AGE) == 2) {
            double x = (double)pos.getX() + random.nextDouble();
            double y = (double)pos.getY() - 0.05;
            double z = (double)pos.getZ() + random.nextDouble();
            level.addParticle((ParticleOptions)new DustParticleOptions(new Vector3f(0.545f, 0.345f, 0.169f), 1.0f), x, y, z, 0.0, -0.2, 0.0);
        }
    }

    public void onBrokenAfterFall(Level level, BlockPos pos, FallingBlockEntity fallingEntity) {
        level.playSound(null, pos, SoundEvents.BAMBOO_BREAK, SoundSource.BLOCKS, 0.7f, 0.9f + level.getRandom().nextFloat() * 0.2f);
        if (level instanceof ServerLevel) {
            RandomSource random = level.getRandom();
            int chance = random.nextInt(100);
            if (chance < 5) {
                HangingCoconutBlock.popResource((Level)level, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)ObjectRegistry.PALM_SPROUT.get().asItem()));
            } else if (chance < 25) {
                HangingCoconutBlock.popResource((Level)level, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)((Item)ObjectRegistry.COCONUT_OPEN.get()).asItem()));
            } else if (chance < 100) {
                HangingCoconutBlock.popResource((Level)level, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)((Item)ObjectRegistry.COCONUT.get()).asItem()));
            }
        }
    }
}

