/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.beachparty.core.block;

import java.util.OptionalInt;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.satisfy.beachparty.core.block.HangingCoconutBlock;
import net.satisfy.beachparty.core.registry.ObjectRegistry;
import org.jetbrains.annotations.NotNull;

public class PalmLeavesBlock
extends LeavesBlock
implements BonemealableBlock {
    public static final IntegerProperty DISTANCE_9 = IntegerProperty.create((String)"distance_9", (int)1, (int)9);

    public PalmLeavesBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)DISTANCE_9, (Comparable)Integer.valueOf(9))).setValue((Property)PERSISTENT, (Comparable)Boolean.valueOf(false))).setValue((Property)DISTANCE, (Comparable)Integer.valueOf(7))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    private static BlockState updateDistance(BlockState pState, LevelAccessor pLevel, BlockPos pPos) {
        int i = 9;
        BlockPos.MutableBlockPos blockpos$autocloseable = new BlockPos.MutableBlockPos();
        for (Direction direction : Direction.values()) {
            blockpos$autocloseable.setWithOffset((Vec3i)pPos, direction);
            i = Math.min(i, PalmLeavesBlock.getDistanceAt(pLevel.getBlockState((BlockPos)blockpos$autocloseable)) + 1);
            if (i == 1) break;
        }
        return (BlockState)pState.setValue((Property)DISTANCE_9, (Comparable)Integer.valueOf(i));
    }

    private static int getDistanceAt(BlockState blockState) {
        return PalmLeavesBlock.getOptionalDistanceAt(blockState).orElse(9);
    }

    @NotNull
    public static OptionalInt getOptionalDistanceAt(BlockState blockState) {
        if (blockState.is(BlockTags.LOGS)) {
            return OptionalInt.of(0);
        }
        return blockState.hasProperty((Property)DISTANCE_9) ? OptionalInt.of((Integer)blockState.getValue((Property)DISTANCE_9)) : OptionalInt.empty();
    }

    public boolean isRandomlyTicking(BlockState state) {
        return (Integer)state.getValue((Property)DISTANCE_9) == 9 && (Boolean)state.getValue((Property)PERSISTENT) == false;
    }

    public void randomTick(BlockState blockState, ServerLevel serverLevel, BlockPos blockPos, RandomSource randomSource) {
        if (this.decaying(blockState)) {
            LeavesBlock.dropResources((BlockState)blockState, (Level)serverLevel, (BlockPos)blockPos);
            serverLevel.removeBlock(blockPos, false);
        }
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.createBlockStateDefinition(pBuilder);
        pBuilder.add(new Property[]{DISTANCE_9});
    }

    @NotNull
    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        FluidState fluidstate = pContext.getLevel().getFluidState(pContext.getClickedPos());
        BlockState blockstate = (BlockState)((BlockState)this.defaultBlockState().setValue((Property)PERSISTENT, (Comparable)Boolean.valueOf(true))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.getType() == Fluids.WATER));
        return PalmLeavesBlock.updateDistance(blockstate, (LevelAccessor)pContext.getLevel(), pContext.getClickedPos());
    }

    protected boolean decaying(BlockState pState) {
        return (Boolean)pState.getValue((Property)PERSISTENT) == false && (Integer)pState.getValue((Property)DISTANCE_9) == 9;
    }

    public void tick(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        pLevel.setBlock(pPos, PalmLeavesBlock.updateDistance(pState, (LevelAccessor)pLevel, pPos), 3);
    }

    @NotNull
    public BlockState updateShape(BlockState pState, Direction pFacing, BlockState pFacingState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pFacingPos) {
        int i;
        if (((Boolean)pState.getValue((Property)WATERLOGGED)).booleanValue()) {
            pLevel.scheduleTick(pCurrentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)pLevel));
        }
        if ((i = PalmLeavesBlock.getDistanceAt(pFacingState) + 1) != 1 || (Integer)pState.getValue((Property)DISTANCE_9) != i) {
            pLevel.scheduleTick(pCurrentPos, (Block)this, 1);
        }
        return pState;
    }

    public boolean isValidBonemealTarget(LevelReader levelReader, BlockPos blockPos, BlockState blockState) {
        return levelReader.getBlockState(blockPos.below()).isAir();
    }

    public boolean isBonemealSuccess(Level level, RandomSource random, BlockPos pos, BlockState state) {
        return true;
    }

    public void performBonemeal(ServerLevel level, RandomSource random, BlockPos pos, BlockState state) {
        if (level.getBlockState(pos.below()).isAir()) {
            level.setBlock(pos.below(), (BlockState)((Block)ObjectRegistry.HANGING_COCONUT.get()).defaultBlockState().setValue((Property)HangingCoconutBlock.AGE, (Comparable)Integer.valueOf(0)), 2);
        }
    }
}

