/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.beachparty.core.entity;

import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerEntity;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.satisfy.beachparty.core.util.BeachpartyUtil;
import org.jetbrains.annotations.NotNull;

public class ChairEntity
extends Entity {
    public ChairEntity(EntityType<?> type, Level world) {
        super(type, world);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
    }

    @NotNull
    public Vec3 getDismountLocationForPassenger(LivingEntity passenger) {
        Player p;
        BlockPos pos;
        if (passenger instanceof Player && (pos = BeachpartyUtil.getPreviousPlayerPosition(p = (Player)passenger, this)) != null) {
            this.discard();
            return new Vec3((double)pos.getX() + 0.5, (double)pos.getY(), (double)pos.getZ() + 0.5);
        }
        this.discard();
        return super.getDismountLocationForPassenger(passenger);
    }

    public void remove(Entity.RemovalReason reason) {
        super.remove(reason);
        BeachpartyUtil.removeChairEntity(this.level(), this.blockPosition());
    }

    protected void readAdditionalSaveData(CompoundTag nbt) {
    }

    protected void addAdditionalSaveData(CompoundTag nbt) {
    }

    @NotNull
    public Packet<ClientGamePacketListener> getAddEntityPacket(ServerEntity serverEntity) {
        return new ClientboundAddEntityPacket((Entity)this, serverEntity);
    }
}

